/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Options {
    private static final long serialVersionUID = 0L;
    public static final Context.Key<Options> optionsKey = new Context.Key();
    private final LinkedHashMap<String, String> values;
    private boolean initialized;
    private List<Runnable> listeners = List.nil();

    public static Options instance(Context context) {
        Options instance = context.get(optionsKey);
        if (instance == null) {
            instance = new Options(context);
        }
        return instance;
    }

    protected Options(Context context) {
        this.values = new LinkedHashMap();
        context.put(optionsKey, this);
    }

    public void initialize() {
        this.initialized = true;
    }

    public String get(String name) {
        return this.computeIfReady(() -> this.values.get(name), null, Option.XD.primaryName + name);
    }

    public String get(Option option) {
        return this.computeIfReady(() -> this.values.get(option.primaryName), null, option.primaryName);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.computeIfReady(() -> Optional.of(name).map(this.values::get).map(Boolean::parseBoolean).orElse(defaultValue), defaultValue, Option.XD.primaryName + name);
    }

    public boolean isSet(String name) {
        return this.computeIfReady(() -> this.values.get(name) != null, false, Option.XD.primaryName + name);
    }

    public boolean isSet(Option option) {
        return this.computeIfReady(() -> this.values.get(option.primaryName) != null, false, option.primaryName);
    }

    public boolean isSet(Option option, String value) {
        return this.computeIfReady(() -> this.values.get(option.primaryName + value) != null, false, option.primaryName + value);
    }

    public boolean isUnset(String name) {
        return !this.isSet(name);
    }

    public boolean isUnset(Option option) {
        return !this.isSet(option);
    }

    public boolean isUnset(Option option, String value) {
        return !this.isSet(option, value);
    }

    public boolean isEnabled(Option option, Lint.LintCategory lc) {
        Option custom = option.getLintCustom();
        return this.isExplicitlyEnabled(option, lc) || this.isSet(custom) || this.isSet(custom, "all");
    }

    public boolean isDisabled(Option option, Lint.LintCategory lc) {
        return this.isExplicitlyDisabled(option, lc) || this.isSet(option.getLintCustom(), "none");
    }

    public boolean isExplicitlyEnabled(Option option, Lint.LintCategory lc) {
        Option customOption = option.getLintCustom();
        return lc.optionList.stream().anyMatch(alias -> this.isSet(customOption, (String)alias));
    }

    public boolean isExplicitlyDisabled(Option option, Lint.LintCategory lc) {
        Option customOption = option.getLintCustom();
        return lc.optionList.stream().anyMatch(alias -> this.isSet(customOption, "-" + alias));
    }

    public EnumSet<Lint.LintCategory> getLintCategoriesOf(Option option, Supplier<? extends EnumSet<Lint.LintCategory>> defaults) {
        Option customOption = option.getLintCustom();
        EnumSet<Lint.LintCategory> categories = this.isSet(option) || this.isSet(customOption, "all") ? EnumSet.allOf(Lint.LintCategory.class) : (this.isSet(customOption, "none") ? EnumSet.noneOf(Lint.LintCategory.class) : defaults.get());
        for (Lint.LintCategory category : Lint.LintCategory.values()) {
            if (this.isExplicitlyEnabled(option, category)) {
                categories.add(category);
                continue;
            }
            if (!this.isExplicitlyDisabled(option, category)) continue;
            categories.remove((Object)category);
        }
        return categories;
    }

    public void put(String name, String value) {
        this.values.put(name, value);
        this.initialized = true;
    }

    public void put(Option option, String value) {
        this.values.put(option.primaryName, value);
        this.initialized = true;
    }

    public void putAll(Options options) {
        this.values.putAll(options.values);
        this.initialized = true;
    }

    public void remove(String name) {
        this.values.remove(name);
        this.initialized = true;
    }

    public Set<String> keySet() {
        return this.values.keySet();
    }

    public int size() {
        return this.values.size();
    }

    public void addListener(Runnable listener) {
        this.listeners = this.listeners.prepend(listener);
    }

    public void notifyListeners() {
        this.initialized = true;
        for (Runnable r : this.listeners) {
            r.run();
        }
        this.listeners = List.nil();
    }

    public void clear() {
        this.values.clear();
        this.listeners = List.nil();
        this.initialized = false;
    }

    public void whenReady(Consumer<? super Options> action) {
        if (this.initialized) {
            action.accept(this);
        } else {
            this.addListener(() -> action.accept(this));
        }
    }

    private <T> T computeIfReady(Supplier<T> ifReady, T ifNotReady, String flag) {
        if (this.initialized) {
            return ifReady.get();
        }
        this.addListener(() -> Assert.check(Objects.equals(ifReady.get(), ifNotReady), () -> "ignored flag: " + flag));
        return ifNotReady;
    }
}

