/*
 * Decompiled with CFR 0.152.
 */
package nbjavac;

public final class ExactConversionsSupport {
    private ExactConversionsSupport() {
    }

    public static boolean isIntToByteExact(int n) {
        return n == (byte)n;
    }

    public static boolean isIntToShortExact(int n) {
        return n == (short)n;
    }

    public static boolean isIntToCharExact(int n) {
        return n == (char)n;
    }

    public static boolean isIntToFloatExact(int n) {
        return n == (int)((float)n) && n != Integer.MAX_VALUE;
    }

    public static boolean isLongToByteExact(long n) {
        return n == (long)((byte)n);
    }

    public static boolean isLongToShortExact(long n) {
        return n == (long)((short)n);
    }

    public static boolean isLongToCharExact(long n) {
        return n == (long)((char)n);
    }

    public static boolean isLongToIntExact(long n) {
        return n == (long)((int)n);
    }

    public static boolean isLongToFloatExact(long n) {
        return n == (long)((float)n) && n != Long.MAX_VALUE;
    }

    public static boolean isLongToDoubleExact(long n) {
        return n == (long)((double)n) && n != Long.MAX_VALUE;
    }

    public static boolean isFloatToByteExact(float n) {
        return n == (float)((byte)n) && !ExactConversionsSupport.isNegativeZero(n);
    }

    public static boolean isFloatToShortExact(float n) {
        return n == (float)((short)n) && !ExactConversionsSupport.isNegativeZero(n);
    }

    public static boolean isFloatToCharExact(float n) {
        return n == (float)((char)n) && !ExactConversionsSupport.isNegativeZero(n);
    }

    public static boolean isFloatToIntExact(float n) {
        return n == (float)((int)n) && n != 2.1474836E9f && !ExactConversionsSupport.isNegativeZero(n);
    }

    public static boolean isFloatToLongExact(float n) {
        return n == (float)((long)n) && n != 9.223372E18f && !ExactConversionsSupport.isNegativeZero(n);
    }

    public static boolean isDoubleToByteExact(double n) {
        return n == (double)((byte)n) && !ExactConversionsSupport.isNegativeZero(n);
    }

    public static boolean isDoubleToShortExact(double n) {
        return n == (double)((short)n) && !ExactConversionsSupport.isNegativeZero(n);
    }

    public static boolean isDoubleToCharExact(double n) {
        return n == (double)((char)n) && !ExactConversionsSupport.isNegativeZero(n);
    }

    public static boolean isDoubleToIntExact(double n) {
        return n == (double)((int)n) && !ExactConversionsSupport.isNegativeZero(n);
    }

    public static boolean isDoubleToLongExact(double n) {
        return n == (double)((long)n) && n != 9.223372036854776E18 && !ExactConversionsSupport.isNegativeZero(n);
    }

    public static boolean isDoubleToFloatExact(double n) {
        return n == (double)((float)n) || n != n;
    }

    private static boolean isNegativeZero(float n) {
        return Float.floatToRawIntBits(n) == Integer.MIN_VALUE;
    }

    private static boolean isNegativeZero(double n) {
        return Double.doubleToRawLongBits(n) == Long.MIN_VALUE;
    }
}

