/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.AutomaticDependencies;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ManifestSection;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.NbStartStop;
import org.netbeans.core.startup.ProxyTask;
import org.netbeans.core.startup.WarmUpSupport;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.BaseUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.SharedClassObject;
import org.openide.util.Task;
import org.openide.util.lookup.InstanceContent;

final class NbInstaller
extends ModuleInstaller {
    private static final Logger LOG = Logger.getLogger(NbInstaller.class.getName());
    private final Map<Module, Set<ManifestSection>> sections = new HashMap<Module, Set<ManifestSection>>(100);
    private final Map<Module, Class<? extends ModuleInstall>> installs = new HashMap<Module, Class<? extends ModuleInstall>>(100);
    private final Map<Module, String> layers = new HashMap<Module, String>(100);
    private boolean initializedFolderLookup = false;
    private final Events ev;
    private ModuleList moduleList;
    private ModuleManager mgr;
    private final Map<Module, Set<String>> kosherPackages = new HashMap<Module, Set<String>>(100);
    private final Map<Module, List<Module.PackageExport>> hiddenClasspathPackages = new HashMap<Module, List<Module.PackageExport>>();
    private final Map<Module.PackageExport, List<Module>> hiddenClasspathPackagesReverse = new HashMap<Module.PackageExport, List<Module>>();
    private final Cache cache = new Cache();
    private final NbStartStop onStartStop = new NbStartStop(null, null);
    private final InstanceContent.Convertor<ManifestSection, Object> convertor = new Convertor();
    private static String cacheCnb;
    private static Set<Dependency> cacheDeps;
    private static final String[] CLASSPATH_PACKAGES;
    private static final String[][] CLASSPATH_JARS;

    public NbInstaller(Events ev) {
        this.ev = ev;
    }

    void registerList(ModuleList list) {
        if (this.moduleList != null) {
            throw new IllegalStateException();
        }
        this.moduleList = list;
    }

    void registerManager(ModuleManager manager) {
        if (this.mgr != null) {
            throw new IllegalStateException();
        }
        this.mgr = manager;
    }

    public void prepare(Module m) throws InvalidException {
        URL layer;
        String layerResource;
        String installClass;
        this.ev.log("prepare", new Object[]{m});
        this.checkForHiddenPackages(m);
        HashSet<ManifestSection> mysections = null;
        Class<?> clazz = null;
        String processSections = this.cache.findGlobalProperty("processSections", null, "false");
        if (!"false".equals(processSections)) {
            Manifest mani = m.getManifest();
            if (mani == null) {
                throw new InvalidException(m, "no manifest");
            }
            for (Map.Entry<String, Attributes> entry : mani.getEntries().entrySet()) {
                ManifestSection section = ManifestSection.create(entry.getKey(), entry.getValue(), m);
                if (section == null) continue;
                if (mysections == null) {
                    mysections = new HashSet<ManifestSection>(25);
                }
                mysections.add(section);
            }
            if (mysections != null) {
                this.cache.findGlobalProperty("processSections", "false", "true");
            }
        }
        if ((installClass = this.cache.findProperty((ModuleInfo)m, "OpenIDE-Module-Install", false)) != null) {
            InvalidException ie;
            String installClassName;
            try {
                installClassName = Util.createPackageName((String)installClass);
            }
            catch (IllegalArgumentException iae) {
                ie = new InvalidException(m, iae.toString());
                ie.initCause((Throwable)iae);
                throw ie;
            }
            if (installClass.endsWith(".ser")) {
                throw new InvalidException(m, "Serialized module installs not supported: " + installClass);
            }
            try {
                Class<?> c;
                clazz = Class.forName(installClassName, false, m.getClassLoader());
                if (clazz.getClassLoader() != m.getClassLoader()) {
                    this.ev.log("wrongClassLoader", new Object[]{m, clazz, m.getClassLoader()});
                }
                for (c = clazz; c != ModuleInstall.class && c != Object.class; c = c.getSuperclass()) {
                    try {
                        c.getDeclaredMethod("validate", new Class[0]);
                        ModuleInstall install = (ModuleInstall)SharedClassObject.findObject(clazz.asSubclass(ModuleInstall.class), (boolean)true);
                        install.validate();
                        continue;
                    }
                    catch (NoSuchMethodException install) {
                        // empty catch block
                    }
                }
                if (c == Object.class) {
                    throw new ClassCastException("Should extend ModuleInstall: " + clazz.getName());
                }
            }
            catch (Exception t) {
                ie = new InvalidException(m, t.toString());
                ie.initCause((Throwable)t);
                throw ie;
            }
            catch (LinkageError t) {
                ie = new InvalidException(m, t.toString());
                ie.initCause((Throwable)t);
                throw ie;
            }
        }
        if ((layerResource = this.cache.findProperty((ModuleInfo)m, "OpenIDE-Module-Layer", false)) != null && !m.isNetigso() && (layer = m.getClassLoader().getResource(layerResource)) == null) {
            throw new InvalidException(m, "Layer not found: " + layerResource);
        }
        String helpSetName = this.cache.findProperty((ModuleInfo)m, "OpenIDE-Module-Description", false);
        if (helpSetName != null) {
            Util.err.log(Level.WARNING, "Use of OpenIDE-Module-Description in {0} is deprecated.", m.getCodeNameBase());
            Util.err.warning("(Please install help using an XML layer instead.)");
        }
        if (mysections != null) {
            this.sections.put(m, (Set<ManifestSection>)mysections);
        }
        if (clazz != null) {
            this.installs.put(m, clazz.asSubclass(ModuleInstall.class));
        }
        if (layerResource != null) {
            this.layers.put(m, layerResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForHiddenPackages(Module m) throws InvalidException {
        ArrayList<Module.PackageExport> hiddenPackages = new ArrayList<Module.PackageExport>();
        LinkedList<Module> mWithDeps = new LinkedList<Module>();
        mWithDeps.add(m);
        if (this.mgr != null) {
            this.addEnabledFragments(m, mWithDeps);
            for (Dependency d : m.getDependencies()) {
                if (d.getType() != 1) continue;
                Module _m = this.mgr.get((String)Util.parseCodeName((String)d.getName())[0]);
                assert (_m != null) : d;
                mWithDeps.add(_m);
                this.addEnabledFragments(_m, mWithDeps);
            }
        }
        for (Module _m : mWithDeps) {
            String hidden = this.cache.findProperty((ModuleInfo)_m, "OpenIDE-Module-Hide-Classpath-Packages", false);
            if (hidden == null) continue;
            for (String piece : hidden.trim().split("[ ,]+")) {
                try {
                    String pkg;
                    if (piece.endsWith(".*")) {
                        pkg = piece.substring(0, piece.length() - 2);
                        Dependency.create((int)1, (String)pkg);
                        if (pkg.lastIndexOf(47) != -1) {
                            throw new IllegalArgumentException("Illegal OpenIDE-Module-Hide-Classpath-Packages: " + hidden);
                        }
                        hiddenPackages.add(new Module.PackageExport(pkg.replace('.', '/') + "/", false));
                        continue;
                    }
                    if (piece.endsWith(".**")) {
                        pkg = piece.substring(0, piece.length() - 3);
                        Dependency.create((int)1, (String)pkg);
                        if (pkg.lastIndexOf(47) != -1) {
                            throw new IllegalArgumentException("Illegal OpenIDE-Module-Hide-Classpath-Packages: " + hidden);
                        }
                        hiddenPackages.add(new Module.PackageExport(pkg.replace('.', '/') + "/", true));
                        continue;
                    }
                    throw new IllegalArgumentException("Illegal OpenIDE-Module-Hide-Classpath-Packages: " + hidden);
                }
                catch (IllegalArgumentException x) {
                    throw new InvalidException(_m, x.getMessage());
                }
            }
        }
        if (!hiddenPackages.isEmpty()) {
            Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
            synchronized (map) {
                this.hiddenClasspathPackages.put(m, hiddenPackages);
                for (Module.PackageExport pkg : hiddenPackages) {
                    List<Module> ms = this.hiddenClasspathPackagesReverse.get(pkg);
                    if (ms == null) {
                        ms = new LinkedList<Module>();
                        this.hiddenClasspathPackagesReverse.put(pkg, ms);
                    }
                    ms.add(m);
                }
            }
        }
    }

    private void addEnabledFragments(Module forModule, List<Module> moduleWithDependencies) {
        for (Module fragment : this.mgr.getAttachedFragments(forModule)) {
            if (!this.mgr.isOrWillEnable(fragment)) continue;
            moduleWithDependencies.add(fragment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Module m) {
        Util.err.fine("dispose: " + m);
        Set<ManifestSection> s = this.sections.remove(m);
        if (s != null) {
            for (ManifestSection sect : s) {
                sect.dispose();
            }
        }
        this.installs.remove(m);
        this.layers.remove(m);
        this.kosherPackages.remove(m);
        Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
        synchronized (map) {
            this.hiddenClasspathPackages.remove(m);
            for (List<Module> ms : this.hiddenClasspathPackagesReverse.values()) {
                ms.remove(m);
            }
        }
    }

    protected void classLoaderUp(ClassLoader cl) {
        MainLookup.systemClassLoaderChanged(cl);
        this.ev.log("perfTick", new Object[]{"META-INF/services/ additions registered"});
    }

    final void waitOnStart() {
        this.onStartStop.waitOnStart();
    }

    public void load(final List<Module> modules) {
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                NbInstaller.this.loadImpl(modules);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImpl(List<Module> modules) {
        this.ev.log("startLoad", new Object[]{modules});
        this.checkForDeprecations(modules);
        this.loadLayers(modules, true);
        this.ev.log("perfTick", new Object[]{"layers loaded"});
        this.onStartStop.initialize();
        this.ev.log("perfTick", new Object[]{"@OnStart"});
        this.ev.log("perfStart", new Object[]{"NbInstaller.load - sections"});
        this.ev.log("loadSection", new Object[0]);
        CoreBridge.getDefault().loaderPoolTransaction(true);
        try {
            for (Module m : modules) {
                try {
                    this.loadSections(m, true);
                }
                catch (Exception t) {
                    Util.err.log(Level.SEVERE, null, t);
                }
                catch (LinkageError le) {
                    Util.err.log(Level.SEVERE, null, le);
                }
                this.ev.log("perfTick", new Object[]{"sections for " + m.getCodeName() + " loaded"});
            }
        }
        finally {
            CoreBridge.getDefault().loaderPoolTransaction(false);
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller.load - sections"});
        if (!this.initializedFolderLookup) {
            Util.err.fine("modulesClassPathInitialized");
            MainLookup.modulesClassPathInitialized();
            this.initializedFolderLookup = true;
        }
        Main.initUICustomizations();
        this.ev.log("perfStart", new Object[]{"NbInstaller.load - ModuleInstalls"});
        for (Module m : modules) {
            try {
                this.loadCode(m, true);
            }
            catch (Exception t) {
                Util.err.log(Level.SEVERE, null, t);
            }
            catch (LinkageError le) {
                Util.err.log(Level.SEVERE, null, le);
            }
            catch (AssertionError e) {
                Util.err.log(Level.SEVERE, null, (Throwable)((Object)e));
            }
            this.ev.log("perfTick", new Object[]{"ModuleInstall for " + m.getCodeName() + " called"});
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller.load - ModuleInstalls"});
        this.ev.log("finishLoad", new Object[]{modules});
        if (Boolean.getBoolean("netbeans.preresolve.classes")) {
            this.preresolveClasses(modules);
        }
    }

    final void preloadCache(Collection<Module> modules) {
        for (Module m : modules) {
            this.isShowInAutoUpdateClient((ModuleInfo)m);
        }
    }

    public void unload(final List<Module> modules) {
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                NbInstaller.this.unloadImpl(modules);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadImpl(List<Module> modules) {
        this.ev.log("startUnload", new Object[]{modules});
        for (Module m : modules) {
            try {
                this.loadCode(m, false);
            }
            catch (Exception t) {
                Util.err.log(Level.SEVERE, null, t);
            }
            catch (LinkageError le) {
                Util.err.log(Level.SEVERE, null, le);
            }
        }
        CoreBridge.getDefault().loaderPoolTransaction(true);
        try {
            for (Module m : modules) {
                try {
                    this.loadSections(m, false);
                }
                catch (Exception t) {
                    Util.err.log(Level.SEVERE, null, t);
                }
                catch (LinkageError le) {
                    Util.err.log(Level.SEVERE, null, le);
                }
            }
        }
        finally {
            try {
                CoreBridge.getDefault().loaderPoolTransaction(false);
            }
            catch (RuntimeException e) {
                Util.err.log(Level.SEVERE, null, e);
            }
        }
        this.loadLayers(modules, false);
        this.ev.log("finishUnload", new Object[]{modules});
    }

    private void loadCode(Module m, boolean load) throws Exception {
        Class<? extends ModuleInstall> instClazz = this.installs.get(m);
        if (instClazz != null) {
            ModuleInstall inst = (ModuleInstall)SharedClassObject.findObject(instClazz, (boolean)true);
            if (load) {
                this.ev.log("restore", new Object[]{m});
                inst.restored();
            } else {
                this.ev.log("uninstall", new Object[]{m});
                inst.uninstalled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSections(Module m, boolean load) throws Exception {
        Set<ManifestSection> s = this.sections.get(m);
        if (s == null) {
            return;
        }
        boolean attachedToMA = false;
        try {
            this.ev.log("loadSection", new Object[0]);
            for (ManifestSection sect : s) {
                if (sect instanceof ManifestSection.ActionSection) {
                    if (!attachedToMA) {
                        Object category = m.getLocalizedAttribute("OpenIDE-Module-Display-Category");
                        if (category == null) {
                            category = m.getCodeNameBase();
                        }
                        CoreBridge.getDefault().attachToCategory(category);
                        attachedToMA = true;
                    }
                    CoreBridge.getDefault().loadActionSection((ManifestSection.ActionSection)sect, load);
                    continue;
                }
                if (sect instanceof ManifestSection.ClipboardConvertorSection) {
                    this.loadGenericSection(sect, load);
                    continue;
                }
                if (sect instanceof ManifestSection.DebuggerSection) {
                    this.loadGenericSection(sect, load);
                    continue;
                }
                if (sect instanceof ManifestSection.LoaderSection) {
                    CoreBridge.getDefault().loadLoaderSection((ManifestSection.LoaderSection)sect, load);
                    continue;
                }
                assert (false) : sect;
            }
        }
        finally {
            if (attachedToMA) {
                CoreBridge.getDefault().attachToCategory(null);
            }
        }
    }

    private void loadGenericSection(ManifestSection s, boolean load) {
        CoreBridge.getDefault().loadDefaultSection(s, this.convertor, load);
    }

    void loadLayers(List<Module> modules, boolean load) {
        LinkedHashSet<URL> theseurls;
        ModuleLayeredFileSystem host;
        this.ev.log(load ? "loadLayers" : "unloadLayers", new Object[]{modules});
        modules = new ArrayList<Module>(modules);
        Collections.reverse(modules);
        HashMap urls = new HashMap(5);
        ModuleLayeredFileSystem userModuleLayer = ModuleLayeredFileSystem.getUserModuleLayer();
        ModuleLayeredFileSystem installationModuleLayer = ModuleLayeredFileSystem.getInstallationModuleLayer();
        urls.put(userModuleLayer, new LinkedHashSet(1000));
        urls.put(installationModuleLayer, new LinkedHashSet(1000));
        for (Module module : modules) {
            String s;
            host = module.isReloadable() ? userModuleLayer : installationModuleLayer;
            theseurls = (LinkedHashSet<URL>)urls.get(host);
            if (theseurls == null) {
                theseurls = new LinkedHashSet<URL>(1000);
                urls.put(host, theseurls);
            }
            if ((s = this.layers.get(module)) != null) {
                String ext;
                String base;
                Util.err.log(Level.FINE, "loadLayer: {0} load={1}", new Object[]{s, load});
                int idx = s.lastIndexOf(46);
                if (idx == -1) {
                    base = s;
                    ext = "";
                } else {
                    base = s.substring(0, idx);
                    ext = s.substring(idx);
                }
                boolean foundSomething = false;
                for (String suffix : NbCollections.iterable((Iterator)NbBundle.getLocalizingSuffixes())) {
                    String resource = base + suffix + ext;
                    Enumeration en = module.findResources(resource);
                    if (!en.hasMoreElements()) continue;
                    URL u = (URL)en.nextElement();
                    theseurls.add(u);
                    foundSomething = true;
                    if (!en.hasMoreElements()) continue;
                    String patchesClassPath = System.getProperty("netbeans.patches." + module.getCodeNameBase());
                    assert (patchesClassPath != null) : "At most one resource per module: " + module;
                    Util.err.log(Level.INFO, "Using {0} as layer for {1} not {2}", new Object[]{u, module.getCodeNameBase(), en.nextElement()});
                }
                if (!foundSomething) {
                    Util.err.fine("Module layer not found: " + s);
                    continue;
                }
            }
            Enumeration e = module.findResources("META-INF/generated-layer.xml");
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                theseurls.add(u);
            }
        }
        for (Map.Entry entry : urls.entrySet()) {
            host = (ModuleLayeredFileSystem)entry.getKey();
            theseurls = (Collection)entry.getValue();
            Util.err.log(Level.FINE, "Adding/removing layer URLs: host={0} urls={1}", new Object[]{host, theseurls});
            try {
                if (load) {
                    host.addURLs(theseurls);
                    continue;
                }
                userModuleLayer.removeURLs(theseurls);
                installationModuleLayer.removeURLs(theseurls);
            }
            catch (Exception e) {
                Util.err.log(Level.WARNING, null, e);
            }
        }
    }

    private void checkForDeprecations(List<Module> modules) {
        TreeSet<String> users;
        TreeMap<String, TreeSet<String>> depToUsers = new TreeMap<String, TreeSet<String>>();
        for (Module module : modules) {
            String depr = this.cache.findProperty((ModuleInfo)module, "OpenIDE-Module-Deprecated", false);
            if (Boolean.parseBoolean(depr)) continue;
            for (Dependency dep : module.getDependencies()) {
                if (dep.getType() != 1) continue;
                String cnb = (String)Util.parseCodeName((String)dep.getName())[0];
                users = (TreeSet<String>)depToUsers.get(cnb);
                if (users == null) {
                    users = new TreeSet<String>();
                    depToUsers.put(cnb, users);
                }
                users.add(module.getCodeNameBase());
            }
        }
        for (Map.Entry entry : depToUsers.entrySet()) {
            String dep = (String)entry.getKey();
            Module o = this.mgr.get(dep);
            assert (o != null) : "No such module: " + dep;
            String depr = this.cache.findProperty((ModuleInfo)o, "OpenIDE-Module-Deprecated", false);
            if (!Boolean.parseBoolean(depr)) continue;
            String message = this.cache.findProperty((ModuleInfo)o, "OpenIDE-Module-Deprecation-Message", true);
            users = (Set)entry.getValue();
            if (message != null) {
                Util.err.log(Level.WARNING, "the modules {0} use {1} which is deprecated: {2}", new Object[]{users, dep, message});
                continue;
            }
            Util.err.log(Level.WARNING, "the modules {0} use {1} which is deprecated.", new Object[]{users, dep});
        }
    }

    public boolean closing(List<Module> modules) {
        Util.err.fine("closing: " + modules);
        for (Module m : modules) {
            Class<? extends ModuleInstall> instClazz = this.installs.get(m);
            if (instClazz == null) continue;
            try {
                ModuleInstall inst = (ModuleInstall)SharedClassObject.findObject(instClazz, (boolean)true);
                if (inst.closing()) continue;
                Util.err.fine("Module " + m + " refused to close");
                return false;
            }
            catch (RuntimeException re) {
                Util.err.log(Level.SEVERE, null, re);
            }
            catch (LinkageError le) {
                Util.err.log(Level.SEVERE, null, le);
            }
        }
        return this.onStartStop.closing(modules);
    }

    public void close(List<Module> modules) {
        this.closeAsync(modules).waitFinished();
    }

    public Task closeAsync(List<Module> modules) {
        Util.err.fine("close: " + modules);
        this.ev.log("close", new Object[0]);
        this.moduleList.shutDown();
        List<Task> waitFor = this.onStartStop.startClose(modules);
        for (Module m : modules) {
            Class<? extends ModuleInstall> instClazz = this.installs.get(m);
            if (instClazz == null) continue;
            try {
                ModuleInstall inst = (ModuleInstall)SharedClassObject.findObject(instClazz, (boolean)true);
                if (inst == null) {
                    throw new IllegalStateException("Inconsistent state: " + instClazz);
                }
                inst.close();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                Util.err.log(Level.SEVERE, null, t);
            }
        }
        waitFor.add(WarmUpSupport.waitTask());
        return new ProxyTask(waitFor);
    }

    protected Set<Dependency> loadDependencies(String cnb) {
        return cnb.equals(cacheCnb) ? cacheDeps : null;
    }

    static void register(String name, Object obj) {
        cacheCnb = name;
        cacheDeps = (Set)obj;
    }

    public void refineDependencies(Module m, Set<Dependency> dependencies) {
        if (Boolean.getBoolean("org.netbeans.core.modules.NbInstaller.noAutoDeps")) {
            return;
        }
        AutomaticDependencies.Report rep = AutomaticDependencies.getDefault().refineDependenciesAndReport(m.getCodeNameBase(), dependencies);
        if (rep.isModified()) {
            Util.err.warning(rep.toString());
        }
    }

    public String[] refineProvides(Module m) {
        if (m.getCodeNameBase().equals("org.openide.modules")) {
            ArrayList<String> arr = new ArrayList<String>(4);
            CoreBridge.defineOsTokens(arr);
            arr.add("org.openide.modules.ModuleFormat1");
            arr.add("org.openide.modules.ModuleFormat2");
            return arr.toArray(new String[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldDelegateResource(Module m, Module parent, String pkg) {
        if (parent == null) {
            List<Module.PackageExport> hiddenPackages;
            for (String cppkg : CLASSPATH_PACKAGES) {
                if (!pkg.startsWith(cppkg) || this.findKosher(m).contains(cppkg)) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Refusing to load classpath package " + pkg + " for " + m.getCodeNameBase() + " without a proper dependency");
                }
                return false;
            }
            Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
            synchronized (map) {
                hiddenPackages = this.hiddenClasspathPackages.get(m);
            }
            if (hiddenPackages != null) {
                for (Module.PackageExport hidden : hiddenPackages) {
                    if (!(hidden.recursive ? pkg.startsWith(hidden.pkg) : pkg.equals(hidden.pkg))) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Refusing to load classpath package " + pkg + " for " + m.getCodeNameBase());
                    }
                    return false;
                }
            }
            if (!this.checkBootDelegation(pkg)) {
                return false;
            }
        }
        if (LOG.isLoggable(Level.FINER) && !pkg.equals("java/util/logging/")) {
            LOG.finer("Delegating resource " + pkg + " from " + parent + " for " + m.getCodeNameBase());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldDelegateClasspathResource(String pkg) {
        Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
        synchronized (map) {
            for (Map.Entry<Module.PackageExport, List<Module>> entry : this.hiddenClasspathPackagesReverse.entrySet()) {
                Module.PackageExport hidden = entry.getKey();
                if (!(hidden.recursive ? pkg.startsWith(hidden.pkg) : pkg.equals(hidden.pkg))) continue;
                for (Module m : entry.getValue()) {
                    if (!m.isEnabled()) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Refusing to load classpath package " + pkg + " because of " + m.getCodeNameBase());
                    }
                    return false;
                }
            }
        }
        return this.checkBootDelegation(pkg);
    }

    private boolean checkBootDelegation(String pkg) {
        String del = System.getProperty("netbeans.bootdelegation");
        if (del != null && !pkg.startsWith("java/")) {
            boolean allowed = false;
            for (String string : del.split(",")) {
                String string2 = string.trim();
                if (string2.endsWith(".*")) {
                    String string3 = string2.substring(0, string2.length() - 2).replace('.', '/') + "/";
                    if (!pkg.startsWith(string3) || pkg.length() <= string3.length()) continue;
                    allowed = true;
                    break;
                }
                String string4 = string2.replace('.', '/') + "/";
                if (!pkg.equals(string4)) continue;
                allowed = true;
                break;
            }
            if (!allowed) {
                return false;
            }
        }
        return true;
    }

    private Set<String> findKosher(Module m) {
        Set<String> s = this.kosherPackages.get(m);
        if (s == null) {
            s = new HashSet<String>();
            Set deps = m.getDependencies();
            SpecificationVersion openide = Util.getModuleDep((Set)deps, (String)"org.openide");
            boolean pre27853 = openide == null || openide.compareTo(new SpecificationVersion("1.3.12")) < 0;
            for (Dependency dep : deps) {
                String req;
                if (dep.getType() == 1 && dep.getName().equals("org.netbeans.core.startup/1")) {
                    s.add("org/netbeans/core/startup/");
                    continue;
                }
                if (pre27853 && dep.getType() == 1) {
                    Module other;
                    String name = dep.getName();
                    int idx = name.indexOf(47);
                    if (idx != -1) {
                        name = name.substring(0, idx);
                    }
                    if ((other = this.mgr.get(name)) == null) {
                        throw new IllegalStateException("Should have found dep " + dep + " from " + m);
                    }
                    s.addAll(this.findKosher(other));
                    continue;
                }
                if (dep.getType() != 2) continue;
                String depname = dep.getName();
                int idx = depname.indexOf(91);
                if (idx == -1) {
                    req = depname.replace('.', '/').concat("/");
                } else if (idx == 0) {
                    int idx2 = depname.lastIndexOf(46);
                    req = depname.substring(1, idx2).replace('.', '/').concat("/");
                } else {
                    req = depname.substring(0, idx).replace('.', '/').concat("/");
                }
                for (String cppkg : CLASSPATH_PACKAGES) {
                    if (!req.startsWith(cppkg)) continue;
                    s.add(cppkg);
                }
            }
            if (s.isEmpty()) {
                s = Collections.emptySet();
            }
            this.kosherPackages.put(m, s);
        }
        return s;
    }

    String getEffectiveClasspath(Module m) {
        if (!m.isEnabled()) {
            return "";
        }
        ArrayList<String> l = new ArrayList<String>(100);
        NbInstaller.createBootClassPath(l);
        Set<String> kosher = m.isFixed() ? null : this.findKosher(m);
        StringTokenizer tok = new StringTokenizer(System.getProperty("java.class.path", ""), File.pathSeparator);
        while (tok.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(tok.nextToken()), l, kosher);
        }
        tok = new StringTokenizer(System.getProperty("netbeans.dynamic.classpath", ""), File.pathSeparator);
        while (tok.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(tok.nextToken()), l, kosher);
        }
        HashSet<Module> modulesConsidered = new HashSet<Module>(50);
        HashSet<String> implDeps = new HashSet<String>(10);
        for (Dependency dep : m.getDependencies()) {
            if (dep.getType() != 1 || dep.getComparison() != 2) continue;
            implDeps.add(dep.getName());
        }
        SpecificationVersion openide = Util.getModuleDep((Set)m.getDependencies(), (String)"org.openide");
        boolean pre27853 = openide == null || openide.compareTo(new SpecificationVersion("1.3.12")) < 0;
        this.addModuleClasspathEntries(m, m, modulesConsidered, implDeps, l, pre27853 ? Integer.MAX_VALUE : 1);
        StringBuilder buf = new StringBuilder(l.size() * 100 + 1);
        for (String s : l) {
            if (buf.length() > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    private static void createBootClassPath(List<String> l) {
        String extensions;
        String boot = System.getProperty("sun.boot.class.path");
        if (boot != null) {
            StringTokenizer tok = new StringTokenizer(boot, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                l.add(tok.nextToken());
            }
        }
        if ((extensions = System.getProperty("java.ext.dirs")) != null) {
            StringTokenizer st = new StringTokenizer(extensions, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                File[] entries = dir.listFiles();
                if (entries == null) continue;
                for (File f : entries) {
                    String name = f.getName().toLowerCase(Locale.US);
                    if (!name.endsWith(".zip") && !name.endsWith(".jar")) continue;
                    l.add(f.getAbsolutePath());
                }
            }
        }
    }

    private static void addStartupClasspathEntry(File cpEntry, List<String> cp, Set<String> kosher) {
        if (cpEntry.isDirectory()) {
            cp.add(cpEntry.getAbsolutePath());
            return;
        }
        String name = cpEntry.getName();
        for (String[] cpjar : CLASSPATH_JARS) {
            if (kosher == null || !name.startsWith(cpjar[0])) continue;
            StringBuilder entry = null;
            for (int k = 1; k < cpjar.length; ++k) {
                String pkg = cpjar[k];
                if (!kosher.contains(pkg)) continue;
                if (entry == null) {
                    entry = new StringBuilder(100);
                    entry.append(cpEntry.getAbsolutePath());
                    entry.append('[');
                } else {
                    entry.append(',');
                }
                entry.append(pkg.replace('/', '.'));
                entry.append("**");
            }
            if (entry != null) {
                entry.append(']');
                cp.add(entry.toString());
            }
            return;
        }
        cp.add(cpEntry.getAbsolutePath());
    }

    private void addModuleClasspathEntries(Module m, Module orig, Set<Module> considered, Set<String> implDeps, List<String> cp, int depth) {
        if (!considered.add(m)) {
            return;
        }
        for (Dependency dep : m.getDependencies()) {
            if (dep.getType() != 1) continue;
            String cnb = (String)Util.parseCodeName((String)dep.getName())[0];
            Module next = this.mgr.get(cnb);
            if (next == null) {
                throw new IllegalStateException("No such module: " + cnb);
            }
            if (depth <= 0) continue;
            this.addModuleClasspathEntries(next, orig, considered, implDeps, cp, depth - 1);
        }
        boolean friend = m == orig || implDeps.contains(m.getCodeName());
        Module.PackageExport[] exports = friend ? null : m.getPublicPackages();
        String qualification = "";
        if (exports != null) {
            if (exports.length == 0) {
                return;
            }
            StringBuilder b = new StringBuilder(100);
            b.append('[');
            for (int i = 0; i < exports.length; ++i) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(exports[i].pkg.replace('/', '.'));
                b.append(exports[i].recursive ? "**" : "*");
            }
            b.append(']');
            qualification = b.toString();
        }
        for (File jar : m.getAllJars()) {
            cp.add(jar.getAbsolutePath() + qualification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preresolveClasses(List<Module> modules) {
        Util.err.info("Pre-resolving classes for all loaded modules...be sure you have not specified -J-Xverify:none in ide.cfg");
        for (Module m : modules) {
            if (m.isFixed() || m.getJarFile() == null) continue;
            File jar = m.getJarFile();
            try (JarFile j = new JarFile(jar, true);){
                for (JarEntry entry : NbCollections.iterable(j.entries())) {
                    String name = entry.getName();
                    if (!name.endsWith(".class")) continue;
                    String clazz = name.substring(0, name.length() - 6).replace('/', '.');
                    Throwable t = null;
                    try {
                        Class.forName(clazz, false, m.getClassLoader());
                    }
                    catch (ClassNotFoundException cnfe) {
                        t = cnfe;
                    }
                    catch (LinkageError le) {
                        t = le;
                    }
                    catch (RuntimeException re) {
                        t = re;
                    }
                    if (t == null) continue;
                    Util.err.log(Level.WARNING, "From " + clazz + " in " + m.getCodeNameBase() + " with effective classpath " + this.getEffectiveClasspath(m), t);
                }
            }
            catch (IOException ioe) {
                Util.err.log(Level.WARNING, null, ioe);
            }
        }
    }

    final boolean isShowInAutoUpdateClient(ModuleInfo m) {
        String show = this.cache.findProperty(m, "AutoUpdate-Show-In-Client", false);
        if (show != null) {
            return Boolean.parseBoolean(show);
        }
        if (m instanceof Module) {
            return !((Module)m).isNetigso();
        }
        return true;
    }

    static {
        CLASSPATH_PACKAGES = new String[]{"org/netbeans/core/startup/"};
        CLASSPATH_JARS = new String[][]{{"core", "org/netbeans/core/", "org/netbeans/beaninfo/"}, {"boot"}};
    }

    static class Cache
    implements Stamps.Updater {
        private static final String CACHE = "all-installer.dat";
        private final boolean modulePropertiesCached;
        private final Properties moduleProperties;

        public Cache() {
            block3: {
                InputStream is = Stamps.getModulesJARs().asStream(CACHE);
                if (is != null) {
                    Properties p = new Properties();
                    try {
                        p.load(is);
                        is.close();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, "Can't load all-installer.dat", ex);
                        break block3;
                    }
                    this.moduleProperties = p;
                    this.modulePropertiesCached = true;
                    return;
                }
            }
            this.moduleProperties = new Properties();
            this.modulePropertiesCached = false;
        }

        final String findProperty(ModuleInfo m, String name, boolean localized) {
            String prop;
            Object p;
            String fullName = m.getCodeNameBase() + "." + name;
            String nullValue = "\u0000";
            if (this.modulePropertiesCached) {
                String val = this.moduleProperties.getProperty(fullName);
                if ("\u0000".equals(val)) {
                    return null;
                }
                if (val != null) {
                    return val;
                }
                LOG.log(Level.FINE, "not cached value: {0} for {1}", new Object[]{name, m});
            }
            Object object = p = localized ? m.getLocalizedAttribute(name) : m.getAttribute(name);
            if (p == null) {
                this.moduleProperties.setProperty(fullName, "\u0000");
                Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this, CACHE, false);
                return null;
            }
            String string = prop = p instanceof String ? (String)p : null;
            if (prop != null) {
                this.moduleProperties.setProperty(fullName, prop);
                Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this, CACHE, false);
            }
            return prop;
        }

        final String findGlobalProperty(String name, String expValue, String replaceValue) {
            assert (name != null);
            assert (replaceValue != null);
            if (this.modulePropertiesCached) {
                return this.moduleProperties.getProperty(name);
            }
            Object prevValue = this.moduleProperties.get(name);
            if (BaseUtilities.compareObjects((Object)expValue, (Object)prevValue)) {
                this.moduleProperties.put(name, replaceValue);
            }
            Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this, CACHE, false);
            return null;
        }

        public void flushCaches(DataOutputStream os) throws IOException {
            this.moduleProperties.store(os, null);
        }

        public void cacheReady() {
        }
    }

    private final class Convertor
    implements InstanceContent.Convertor<ManifestSection, Object> {
        Convertor() {
        }

        public Object convert(ManifestSection s) {
            try {
                return s.getInstance();
            }
            catch (Exception e) {
                Util.err.log(Level.WARNING, null, e);
                NbInstaller.this.loadGenericSection(s, false);
                return null;
            }
        }

        public Class<?> type(ManifestSection s) {
            return s.getSuperclass();
        }

        public String id(ManifestSection obj) {
            return obj.toString();
        }

        public String displayName(ManifestSection obj) {
            return obj.toString();
        }
    }
}

