/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.netbeans.core.startup.logging.NbFormatter;

final class MessagesHandler
extends StreamHandler {
    static final int MAX_REPEAT_COUNT_FLUSH = 10;
    private final File dir;
    private final File[] files;
    private final long limit;
    private final boolean filterRepeats;
    private LogRecord lastLogRecord;
    private LogRecord repeatingRecord;
    private long repeatCounter;
    private long lastRecordAllRepeatsCounter = 1L;

    MessagesHandler(File dir) {
        this(dir, -1, 0x100000L);
    }

    MessagesHandler(File dir, int count, long limit) {
        this.dir = dir;
        if (count == -1 && (count = Integer.getInteger("org.netbeans.log.numberOfFiles", 3).intValue()) < 3) {
            count = 3;
        }
        File[] arr = new File[count];
        arr[0] = new File(dir, "messages.log");
        for (int i = 1; i < arr.length; ++i) {
            arr[i] = new File(dir, "messages.log." + i);
        }
        this.files = arr;
        this.limit = limit;
        this.filterRepeats = !Boolean.getBoolean("org.netbeans.log.disableRepeatingMessagesFilter");
        this.setFormatter(NbFormatter.FORMATTER);
        this.setLevel(Level.ALL);
        this.checkRotate(true);
        this.initStream();
    }

    private boolean checkRotate(boolean always) {
        if (!always && this.files[0].length() < this.limit) {
            return false;
        }
        this.flush();
        this.doRotate();
        return true;
    }

    private void initStream() {
        try {
            this.setOutputStream(new FileOutputStream(this.files[0], false));
        }
        catch (FileNotFoundException ex) {
            this.setOutputStream(System.err);
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (this.filterRepeats) {
            if (this.lastLogRecord != null) {
                if (this.compareRepeating(this.lastLogRecord, record)) {
                    ++this.repeatCounter;
                    ++this.lastRecordAllRepeatsCounter;
                    LogRecord rr = this.createRepeatingRecord(record, this.repeatCounter);
                    if (rr != null) {
                        this.repeatingRecord = rr;
                    }
                    return;
                }
                if (this.repeatCounter > 0L || this.lastRecordAllRepeatsCounter > 1L) {
                    if (this.lastRecordAllRepeatsCounter > 10L) {
                        this.repeatingRecord = this.createAllRepeatsRecord(this.lastLogRecord, this.lastRecordAllRepeatsCounter);
                    }
                    this.flushRepeatCounter();
                    this.lastRecordAllRepeatsCounter = 1L;
                }
            }
            this.lastLogRecord = record;
        }
        super.publish(record);
        if (this.checkRotate(false)) {
            this.initStream();
        }
    }

    @Override
    public synchronized void flush() {
        this.flushRepeatCounter();
        super.flush();
    }

    private synchronized void doRotate() {
        this.close();
        int n = this.files.length;
        if (this.files[n - 1].exists()) {
            this.files[n - 1].delete();
        }
        for (int i = n - 2; i >= 0; --i) {
            if (!this.files[i].exists()) continue;
            this.files[i].renameTo(this.files[i + 1]);
        }
    }

    private synchronized void flushRepeatCounter() {
        if (this.repeatingRecord != null) {
            super.publish(this.repeatingRecord);
            this.repeatingRecord = null;
        }
        this.repeatCounter = 0L;
    }

    private boolean compareRepeating(LogRecord r1, LogRecord r2) {
        return r1.getLevel().equals(r2.getLevel()) && Objects.equals(r1.getLoggerName(), r2.getLoggerName()) && Objects.equals(r1.getMessage(), r2.getMessage()) && Objects.deepEquals(r1.getParameters(), r2.getParameters()) && Objects.equals(r1.getResourceBundle(), r2.getResourceBundle()) && Objects.equals(r1.getResourceBundleName(), r2.getResourceBundleName()) && Objects.equals(r1.getSourceClassName(), r2.getSourceClassName()) && Objects.equals(r1.getSourceMethodName(), r2.getSourceMethodName()) && this.compareThrown(r1.getThrown(), r2.getThrown());
    }

    private boolean compareThrown(Throwable t1, Throwable t2) {
        if (t1 == null) {
            return t2 == null;
        }
        if (t2 == null) {
            return false;
        }
        return t1.getClass().equals(t2.getClass()) && Objects.equals(t1.getMessage(), t2.getMessage()) && Objects.equals(t1.getLocalizedMessage(), t2.getLocalizedMessage()) && Arrays.deepEquals(t1.getStackTrace(), t2.getStackTrace()) && this.compareThrown(t1.getCause(), t2.getCause());
    }

    private LogRecord createRepeatingRecord(LogRecord r, long rc) {
        if (this.lastRecordAllRepeatsCounter <= 11L) {
            return new LogRecord(r.getLevel(), MessagesHandler.getRepeatingMessage(rc, this.lastRecordAllRepeatsCounter));
        }
        return null;
    }

    private LogRecord createAllRepeatsRecord(LogRecord r, long allRc) {
        return new LogRecord(r.getLevel(), MessagesHandler.getAllRepeatsMessage(allRc));
    }

    static String getRepeatingMessage(long rc, long allRc) {
        Object msg = allRc > 10L ? "Last record repeated more than 10 times, further logs of this record are ignored until the log record changes." : (rc == 1L ? "Last record repeated again." : "Last record repeated " + rc + " more times.");
        return msg;
    }

    static String getAllRepeatsMessage(long allRc) {
        return "Last record repeated " + allRc + " times in total.";
    }
}

