/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.refactoring.php.RefactoringUtils;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.UserQuestionException;
import org.openide.util.lookup.Lookups;

public class WhereUsedElement
extends SimpleRefactoringElementImplementation {
    private final PositionBounds bounds;
    private final String displayText;
    private final FileObject parentFile;
    private final Icon icon;
    private final String name;
    private static final Logger LOGGER = Logger.getLogger(WhereUsedElement.class.getName());

    public WhereUsedElement(PositionBounds bounds, String displayText, FileObject parentFile, String name, OffsetRange range, Icon icon) {
        this.bounds = bounds;
        this.displayText = displayText;
        this.parentFile = parentFile;
        this.name = name;
        this.icon = icon;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        FileObject composite = this.parentFile;
        return Lookups.singleton((Object)composite);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public FileObject getFile() {
        return this.parentFile;
    }

    public FileObject getParentFile() {
        return this.getFile();
    }

    public static String extractVariableName(Variable var) {
        if (var.getName() instanceof Identifier) {
            Identifier id = (Identifier)var.getName();
            StringBuilder varName = new StringBuilder();
            if (var.isDollared()) {
                varName.append("$");
            }
            varName.append(id.getName());
            return varName.toString();
        }
        if (var.getName() instanceof Variable) {
            Variable name = (Variable)var.getName();
            return WhereUsedElement.extractVariableName(name);
        }
        return null;
    }

    public static WhereUsedElement create(String name, FileObject fo, OffsetRange range, Icon icon) {
        WhereUsedElement result = null;
        int start = range.getStart();
        int end = range.getEnd();
        try {
            DataObject od = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)od.getLookup().lookup(EditorCookie.class);
            if (ec != null) {
                int en;
                BaseDocument bdoc = (BaseDocument)ec.openDocument();
                String content = bdoc.getText(0, bdoc.getLength());
                int sta = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)bdoc, (int)start);
                if (sta == -1) {
                    sta = LineDocumentUtils.getLineStartOffset((LineDocument)bdoc, (int)start);
                }
                en = (en = LineDocumentUtils.getLineLastNonWhitespace((LineDocument)bdoc, (int)start)) == -1 ? LineDocumentUtils.getLineEndOffset((LineDocument)bdoc, (int)start) : ++en;
                if (end > en && (end = start + name.length()) > bdoc.getLength()) {
                    end = bdoc.getLength();
                }
                StringBuilder sb = new StringBuilder();
                if (end < sta) {
                    sta = end;
                }
                if (start < sta) {
                    start = sta;
                }
                if (en < end) {
                    en = end;
                }
                sb.append(RefactoringUtils.getHtml(content.subSequence(sta, start).toString()));
                sb.append("<b>");
                sb.append(content.subSequence(start, end));
                sb.append("</b>");
                sb.append(RefactoringUtils.getHtml(content.subSequence(end, en).toString()));
                CloneableEditorSupport ces = RefactoringUtils.findCloneableEditorSupport(fo);
                PositionRef ref1 = ces.createPositionRef(start, Position.Bias.Forward);
                PositionRef ref2 = ces.createPositionRef(end, Position.Bias.Forward);
                PositionBounds bounds = new PositionBounds(ref1, ref2);
                result = new WhereUsedElement(bounds, sb.toString().trim(), fo, name, new OffsetRange(start, end), icon);
            }
        }
        catch (UserQuestionException ex) {
            LOGGER.log(Level.INFO, "Was not possible to obtain document for " + fo.getPath(), ex);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }
}

