/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;

public class ConvertInvalidVarToExplicitArrayType
implements ErrorRule<Void> {
    private static final Set<String> CODES;

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        if (treePath.getParentPath() == null) {
            return null;
        }
        TypeMirror arrayType = null;
        if (treePath.getLeaf().getKind() == Tree.Kind.VARIABLE) {
            VariableTree oldVariableTree = (VariableTree)treePath.getLeaf();
            ExpressionTree init = oldVariableTree.getInitializer();
            if (init == null || init.getKind() != Tree.Kind.NEW_ARRAY) {
                return null;
            }
            NewArrayTree arrayTree = (NewArrayTree)oldVariableTree.getInitializer();
            List<? extends ExpressionTree> currentValues = arrayTree.getInitializers();
            if (currentValues.isEmpty()) {
                return null;
            }
            TreePath initArrayTreePath = new TreePath(treePath, arrayTree);
            Types types = compilationInfo.getTypes();
            Trees trees = compilationInfo.getTrees();
            for (ExpressionTree expressionTree : currentValues) {
                TypeMirror etType = trees.getTypeMirror(new TreePath(initArrayTreePath, expressionTree));
                if (etType == null || etType.getKind() == TypeKind.ERROR || etType.getKind() == TypeKind.DECLARED && !((DeclaredType)etType).getTypeArguments().isEmpty() || Utilities.isAnonymousType(etType)) {
                    return null;
                }
                if (arrayType == null) {
                    arrayType = etType;
                    continue;
                }
                if (types.isAssignable(etType, arrayType)) continue;
                if (types.isAssignable(arrayType, etType)) {
                    arrayType = etType;
                    continue;
                }
                return null;
            }
            return Collections.singletonList(new FixImpl(compilationInfo, treePath, arrayType).toEditorFix());
        }
        return Collections.emptyList();
    }

    public String getId() {
        return ConvertInvalidVarToExplicitArrayType.class.getName();
    }

    public String getDisplayName() {
        return Bundle.DN_ConvertVarToExplicitType();
    }

    public void cancel() {
    }

    static {
        HashSet<String> codes = new HashSet<String>();
        codes.add("compiler.err.cant.infer.local.var.type");
        CODES = Collections.unmodifiableSet(codes);
    }

    private static final class FixImpl
    extends JavaFix {
        private final TypeMirrorHandle arrayTypeMirror;

        public FixImpl(CompilationInfo info, TreePath tp, TypeMirror arrayType) {
            super(info, tp);
            this.arrayTypeMirror = TypeMirrorHandle.create((TypeMirror)arrayType);
        }

        protected String getText() {
            return Bundle.DN_ConvertVarToExplicitType();
        }

        protected void performRewrite(JavaFix.TransformationContext tc) throws Exception {
            WorkingCopy wc = tc.getWorkingCopy();
            wc.toPhase(JavaSource.Phase.RESOLVED);
            TreePath statementPath = tc.getPath();
            TreeMaker make = wc.getTreeMaker();
            VariableTree oldVariableTree = null;
            if (statementPath.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                oldVariableTree = (VariableTree)statementPath.getLeaf();
                TypeMirror arrayType = this.arrayTypeMirror.resolve((CompilationInfo)wc);
                if (arrayType == null) {
                    return;
                }
                arrayType = Utilities.resolveCapturedType((CompilationInfo)wc, arrayType);
                VariableTree newVariableTree = make.Variable(oldVariableTree.getModifiers(), (CharSequence)oldVariableTree.getName(), (Tree)make.ArrayType(make.Type(arrayType)), oldVariableTree.getInitializer());
                tc.getWorkingCopy().rewrite((Tree)oldVariableTree, (Tree)newVariableTree);
            }
        }
    }
}

