/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.refactoring.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lsp.TextEdit;
import org.openide.util.Exceptions;

public class DocumentChangesConverter
implements DocumentListener {
    private final Document document;
    private boolean adjustPositions;
    private List<TextEdit> recordedEdits = new ArrayList<TextEdit>();
    private List<TextEdit> ordered = new ArrayList<TextEdit>();
    private TreeSet<TextEdit> condensed = new TreeSet((t1, t2) -> {
        int d = t1.getStartOffset() - t2.getStartOffset();
        if (d != 0) {
            return d;
        }
        int n1 = this.ordered.indexOf(t1);
        int n2 = this.ordered.indexOf(t2);
        if (n1 == -1) {
            return 1;
        }
        if (n2 == -1) {
            return 1;
        }
        return n1 - n2;
    });

    public DocumentChangesConverter(Document document) {
        this.document = document;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            String text = this.document.getText(e.getOffset(), e.getLength());
            TextEdit edit = new TextEdit(e.getOffset(), e.getOffset(), text);
            this.recordedEdits.add(edit);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        TextEdit edit = new TextEdit(e.getOffset(), e.getOffset() + e.getLength(), null);
        this.recordedEdits.add(edit);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    void replaceOrderedEdits(Collection<TextEdit> remove, TextEdit replaceWith) {
        int pos = -1;
        for (TextEdit candidate : remove) {
            int p = this.ordered.indexOf(candidate);
            if (pos == -1) {
                pos = p;
                continue;
            }
            if (candidate.getNewText() == null || p >= pos) continue;
            pos = p;
        }
        this.ordered.set(pos, replaceWith);
        this.ordered.removeAll(remove);
    }

    public List<TextEdit> makeTextEdits() {
        this.ordered.clear();
        this.ordered.addAll(this.recordedEdits);
        this.condensed.clear();
        block0: for (int i = 0; i < this.recordedEdits.size(); ++i) {
            int sz;
            TextEdit t = this.recordedEdits.get(i);
            int adjustedStart = t.getStartOffset();
            int adjustedEnd = t.getEndOffset();
            int l = t.getEndOffset() - t.getStartOffset();
            NavigableSet<TextEdit> priorEdits = this.condensed.headSet(t, false).descendingSet();
            Iterator<TextEdit> it = priorEdits.iterator();
            while (it.hasNext()) {
                int added;
                TextEdit p = it.next();
                int n = added = p.getNewText() != null ? p.getNewText().length() : 0;
                if (p.getStartOffset() + added >= adjustedStart && (l == 0 || adjustedStart < p.getStartOffset() + added)) {
                    this.mergePrecedingOverlap(t, p, adjustedStart, it);
                    continue block0;
                }
                int editLength = p.getNewText() != null ? p.getNewText().length() : 0;
                adjustedEnd = (adjustedStart -= (editLength -= p.getEndOffset() - p.getStartOffset())) + l;
            }
            SortedSet<TextEdit> nextEdits = this.condensed.tailSet(t);
            int n = sz = t.getNewText() == null ? 0 : t.getNewText().length();
            if (!nextEdits.isEmpty()) {
                TextEdit n2;
                ArrayList<TextEdit> toMerge = new ArrayList<TextEdit>();
                Iterator it2 = nextEdits.iterator();
                while (it2.hasNext() && (n2 = (TextEdit)it2.next()).getStartOffset() <= adjustedEnd + sz) {
                    toMerge.add(n2);
                    it2.remove();
                }
                if (!toMerge.isEmpty()) {
                    this.mergeOverlappingEdits(toMerge, t, adjustedStart, adjustedEnd);
                    continue;
                }
            }
            if (adjustedStart != t.getStartOffset()) {
                TextEdit edit = new TextEdit(adjustedStart, adjustedEnd, t.getNewText());
                this.replaceOrderedEdits(Collections.singletonList(t), edit);
                this.condensed.add(edit);
                continue;
            }
            this.condensed.add(t);
        }
        return new ArrayList<TextEdit>(this.condensed);
    }

    private void mergeOverlappingEdits(List<TextEdit> toMerge, TextEdit newEdit, int adjustedStart, int adjustedEnd) {
        TextEdit remainder = null;
        for (int i = 0; i < toMerge.size(); ++i) {
            int nl;
            TextEdit t = toMerge.get(i);
            int l = t.getNewText() == null ? 0 : t.getNewText().length();
            int n = nl = newEdit.getNewText() == null ? 0 : newEdit.getNewText().length();
            if (adjustedEnd >= t.getStartOffset() + l) {
                adjustedEnd += t.getEndOffset() - t.getStartOffset();
                adjustedEnd -= l;
                continue;
            }
            if (adjustedEnd > t.getStartOffset()) {
                int delPart = adjustedEnd - t.getStartOffset();
                Object nt = t.getNewText().substring(delPart);
                nt = newEdit.getNewText() != null ? newEdit.getNewText() + t.getNewText().substring(delPart) : t.getNewText().substring(delPart);
                if (((String)nt).isEmpty()) {
                    nt = null;
                }
                TextEdit edit = new TextEdit(adjustedStart, t.getEndOffset(), (String)nt);
                this.replaceOrderedEdits(toMerge, edit);
                this.condensed.add(edit);
                return;
            }
            if (adjustedEnd + nl == t.getStartOffset() && (nl == 0 || t.getEndOffset() == t.getStartOffset() && t.getNewText() != null)) {
                TextEdit edit = new TextEdit(adjustedStart, adjustedEnd, (String)(nl == 0 ? "" : newEdit.getNewText() + t.getNewText()));
                this.replaceOrderedEdits(toMerge, edit);
                this.condensed.add(edit);
                return;
            }
            remainder = t;
            break;
        }
        TextEdit edit = new TextEdit(adjustedStart, adjustedEnd, newEdit.getNewText());
        if (remainder != null) {
            this.condensed.add(remainder);
        } else {
            this.replaceOrderedEdits(toMerge, edit);
        }
        this.condensed.add(edit);
    }

    private void mergePrecedingOverlap(TextEdit newEdit, TextEdit conflicting, int adjustedStart, Iterator<TextEdit> it) {
        boolean deleteContained;
        int del = newEdit.getEndOffset() - newEdit.getStartOffset();
        String confText = conflicting.getNewText();
        String newText = newEdit.getNewText();
        int confLen = confText == null ? 0 : confText.length();
        int off = adjustedStart - conflicting.getStartOffset();
        boolean bl = deleteContained = conflicting.getStartOffset() + confLen >= adjustedStart + del;
        if (deleteContained) {
            Object text = off == confLen ? (confText != null ? (newText != null ? confText + newText : confText) : newText) : (newText != null ? (confText != null ? confText.substring(0, off) + newText + confText.substring(off + del) : newText + confText.substring(off + del)) : confText.substring(0, off) + confText.substring(off + del));
            if (text != null && ((String)text).isEmpty()) {
                text = null;
            }
            it.remove();
            if (conflicting.getStartOffset() != conflicting.getEndOffset() || text != null) {
                TextEdit edit = new TextEdit(conflicting.getStartOffset(), conflicting.getEndOffset(), (String)text);
                this.replaceOrderedEdits(Collections.singleton(conflicting), edit);
                this.condensed.add(edit);
            }
            return;
        }
        if (off == 0) {
            int mergeDel = conflicting.getEndOffset() - conflicting.getStartOffset() + (del - confLen);
            it.remove();
            TextEdit edit = new TextEdit(conflicting.getStartOffset(), conflicting.getStartOffset() + mergeDel, newText);
            this.replaceOrderedEdits(Collections.singleton(conflicting), edit);
            this.condensed.add(edit);
            return;
        }
        it.remove();
        TextEdit edit = new TextEdit(conflicting.getStartOffset(), conflicting.getEndOffset(), confText.substring(0, off));
        this.replaceOrderedEdits(Collections.singleton(conflicting), edit);
        this.condensed.add(edit);
        int del2 = del - (confLen - off);
        TextEdit edit2 = new TextEdit(adjustedStart, adjustedStart + del2, newText);
        this.ordered.add(edit2);
        this.condensed.add(edit2);
    }
}

