/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.modules.java.j2seembedded.platform.ConnectionMethod;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatformProbe;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatformProvider;
import org.netbeans.modules.java.j2seembedded.ui.CreateJREPanel;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public class SetUpRemotePlatform
extends JPanel {
    private static final String HELP_ID = "java.j2seembedded.setup-remote-platform";
    private static final String ENV_JAVA_HOME = "JAVA_HOME";
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private String currentDefaultWorkDir;
    private WizardDescriptor wizardDescriptor;
    private JButton buttonBrowse;
    private JButton buttonCreate;
    private ButtonGroup buttonGroupAuth;
    private JTextField displayName;
    private JLabel displayNameLabel;
    private Box.Filler fillerBottomVertical;
    private JTextField host;
    private JLabel hostLabel;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField jreLocation;
    private JLabel jreLocationLabel;
    private JLabel keyFileLabel;
    private JTextField keyFilePath;
    private JPasswordField passphrase;
    private JLabel passphraseLabel;
    private JPasswordField password;
    private JLabel passwordLabel;
    private JSpinner port;
    private JLabel portLabel;
    private JRadioButton radioButtonKey;
    private JRadioButton radioButtonPassword;
    private JTextField username;
    private JLabel usernameLabel;
    private JTextField workingDir;
    private JLabel workingDirLabel;

    private SetUpRemotePlatform() {
        this.initComponents();
        this.postInitComponents();
    }

    private void postInitComponents() {
        int i = 1;
        while (true) {
            this.displayName.setText("Remote Platform " + i);
            String antName = PropertyUtils.getUsablePropertyName((String)this.displayName.getText());
            if (RemotePlatformProvider.isValidPlatformAntName(antName)) break;
            ++i;
        }
        this.displayName.selectAll();
        ChangeListener radioChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SetUpRemotePlatform.this.toggleAuthMethod(SetUpRemotePlatform.this.radioButtonPassword.isSelected());
                SetUpRemotePlatform.this.cs.fireChange();
            }
        };
        this.radioButtonKey.addChangeListener(radioChangeListener);
        this.radioButtonPassword.addChangeListener(radioChangeListener);
        this.radioButtonPassword.setSelected(true);
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SetUpRemotePlatform.this.updateDefaultDirectory(e);
                SetUpRemotePlatform.this.cs.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SetUpRemotePlatform.this.updateDefaultDirectory(e);
                SetUpRemotePlatform.this.cs.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SetUpRemotePlatform.this.updateDefaultDirectory(e);
                SetUpRemotePlatform.this.cs.fireChange();
            }
        };
        this.displayName.getDocument().addDocumentListener(docListener);
        this.host.getDocument().addDocumentListener(docListener);
        this.username.getDocument().addDocumentListener(docListener);
        this.password.getDocument().addDocumentListener(docListener);
        this.keyFilePath.getDocument().addDocumentListener(docListener);
        this.passphrase.getDocument().addDocumentListener(docListener);
        this.jreLocation.getDocument().addDocumentListener(docListener);
        this.workingDir.getDocument().addDocumentListener(docListener);
    }

    private void toggleAuthMethod(boolean usePasswordAuth) {
        this.password.setEnabled(usePasswordAuth);
        this.keyFilePath.setEnabled(!usePasswordAuth);
        this.passphrase.setEnabled(!usePasswordAuth);
        this.buttonBrowse.setEnabled(!usePasswordAuth);
    }

    public final synchronized void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public final synchronized void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    private void updateDefaultDirectory(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc.equals(this.username.getDocument())) {
            String usernameText = this.username.getText();
            if (!usernameText.isEmpty()) {
                String workdirText = this.workingDir.getText();
                if (workdirText.isEmpty() || this.currentDefaultWorkDir != null && workdirText.equals(this.currentDefaultWorkDir)) {
                    String updatedDefaultworkDir = "/home/" + usernameText + "/NetBeansProjects/";
                    this.workingDir.setText(updatedDefaultworkDir);
                    this.currentDefaultWorkDir = updatedDefaultworkDir;
                }
            } else if (this.currentDefaultWorkDir != null && this.workingDir.getText().equals(this.currentDefaultWorkDir)) {
                this.workingDir.setText("");
                this.currentDefaultWorkDir = null;
            }
        }
    }

    private void initComponents() {
        this.buttonGroupAuth = new ButtonGroup();
        this.hostLabel = new JLabel();
        this.host = new JTextField();
        this.portLabel = new JLabel();
        this.port = new JSpinner();
        this.usernameLabel = new JLabel();
        this.username = new JTextField();
        this.radioButtonPassword = new JRadioButton();
        this.passwordLabel = new JLabel();
        this.password = new JPasswordField();
        this.radioButtonKey = new JRadioButton();
        this.keyFileLabel = new JLabel();
        this.keyFilePath = new JTextField();
        this.buttonBrowse = new JButton();
        this.passphraseLabel = new JLabel();
        this.passphrase = new JPasswordField();
        this.jSeparator1 = new JSeparator();
        this.jreLocationLabel = new JLabel();
        this.jreLocation = new JTextField();
        this.workingDirLabel = new JLabel();
        this.workingDir = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.displayNameLabel = new JLabel();
        this.displayName = new JTextField();
        this.fillerBottomVertical = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.buttonCreate = new JButton();
        this.setName(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"TXT_SetUpRemotePlatform"));
        this.setLayout(new GridBagLayout());
        this.hostLabel.setLabelFor(this.host);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.hostLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.hostLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.host, gridBagConstraints);
        this.portLabel.setLabelFor(this.port);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.portLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.portLabel, gridBagConstraints);
        this.port.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.port.setEditor(new JSpinner.NumberEditor(this.port, "#0"));
        this.port.setPreferredSize(new Dimension(54, 20));
        this.port.setValue(22);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.port, gridBagConstraints);
        this.usernameLabel.setLabelFor(this.username);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.usernameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.usernameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.username, gridBagConstraints);
        this.buttonGroupAuth.add(this.radioButtonPassword);
        Mnemonics.setLocalizedText((AbstractButton)this.radioButtonPassword, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.radioButtonPassword.text"));
        this.radioButtonPassword.setActionCommand(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.radioButtonPassword.actionCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.radioButtonPassword, gridBagConstraints);
        this.passwordLabel.setLabelFor(this.password);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.passwordLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.passwordLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.password, gridBagConstraints);
        this.buttonGroupAuth.add(this.radioButtonKey);
        Mnemonics.setLocalizedText((AbstractButton)this.radioButtonKey, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.radioButtonKey.text"));
        this.radioButtonKey.setActionCommand(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.radioButtonKey.actionCommand"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.radioButtonKey, gridBagConstraints);
        this.keyFileLabel.setLabelFor(this.keyFilePath);
        Mnemonics.setLocalizedText((JLabel)this.keyFileLabel, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.keyFileLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.keyFileLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.keyFilePath, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonBrowse, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.buttonBrowse.text"));
        this.buttonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetUpRemotePlatform.this.buttonBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.buttonBrowse, gridBagConstraints);
        this.passphraseLabel.setLabelFor(this.passphrase);
        Mnemonics.setLocalizedText((JLabel)this.passphraseLabel, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.passphraseLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.passphraseLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.passphrase, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jreLocationLabel.setLabelFor(this.jreLocation);
        Mnemonics.setLocalizedText((JLabel)this.jreLocationLabel, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.jreLocationLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jreLocationLabel, gridBagConstraints);
        this.jreLocation.setText(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.jreLocation.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jreLocation, gridBagConstraints);
        this.workingDirLabel.setLabelFor(this.workingDir);
        Mnemonics.setLocalizedText((JLabel)this.workingDirLabel, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.workingDirLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.workingDirLabel, gridBagConstraints);
        this.workingDir.setText(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.workingDir.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.workingDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.jSeparator2, gridBagConstraints);
        this.displayNameLabel.setLabelFor(this.displayName);
        Mnemonics.setLocalizedText((JLabel)this.displayNameLabel, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.displayNameLabel.text"));
        this.displayNameLabel.setToolTipText(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.displayNameLabel.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.displayNameLabel, gridBagConstraints);
        this.displayName.setText(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.displayName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.displayName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerBottomVertical, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonCreate, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"SetUpRemotePlatform.buttonCreate.text"));
        this.buttonCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetUpRemotePlatform.this.buttonCreateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.buttonCreate, gridBagConstraints);
    }

    private void buttonBrowseActionPerformed(ActionEvent evt) {
        String oldValue = this.keyFilePath.getText();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        if (oldValue != null) {
            chooser.setSelectedFile(new File(oldValue));
        }
        chooser.setDialogTitle(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"Title_Chooser_SelectKeyfile"));
        if (chooser.showOpenDialog(this) == 0) {
            this.keyFilePath.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void buttonCreateActionPerformed(ActionEvent evt) {
        final File ejreTmp = SetUpRemotePlatform.createJRETempDir();
        final Pair<List<String>, String> data = CreateJREPanel.configure(this.username.getText(), this.host.getText(), ejreTmp);
        if (data != null) {
            final ConnectionMethod cm = this.radioButtonPassword.isSelected() ? ConnectionMethod.sshPassword(this.host.getText(), (Integer)this.port.getValue(), this.username.getText(), String.valueOf(this.password.getPassword())) : ConnectionMethod.sshKey(this.host.getText(), (Integer)this.port.getValue(), this.username.getText(), new File(this.keyFilePath.getText()), String.valueOf(this.passphrase.getPassword()));
            BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run(ProgressHandle handle) {
                    handle.switchToDeterminate(2);
                    handle.progress(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"LBL_JRECreate"), 0);
                    try {
                        int res = SetUpRemotePlatform.jreCreate((List)data.first());
                        if (res != 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"ERROR_JRECreate"), 0));
                                }
                            });
                            Void void_ = null;
                            return void_;
                        }
                        handle.progress(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"LBL_JREUpload"), 1);
                        res = SetUpRemotePlatform.upload(ejreTmp, (String)data.second(), cm, SetUpRemotePlatform.this.wizardDescriptor);
                        if (res != 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"ERROR_JREUpload"), 0));
                                }
                            });
                            Void void_ = null;
                            return void_;
                        }
                        handle.finish();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SetUpRemotePlatform.this.jreLocation.setText((String)data.second());
                            }
                        });
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        SetUpRemotePlatform.deleteAll(ejreTmp);
                    }
                }
            }, (String)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"LBL_CreatingNewPlatform"), (boolean)true);
        }
    }

    private static File createJRETempDir() {
        File tmpJreDir;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String namePattern = "nb-jrecreate-%d";
        int i = -1;
        while ((tmpJreDir = new File(tmpDir, String.format("nb-jrecreate-%d", ++i))).exists()) {
        }
        return tmpJreDir;
    }

    private static void deleteAll(File file) {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                SetUpRemotePlatform.deleteAll(child);
            }
        }
        file.delete();
    }

    private static int jreCreate(@NonNull List<String> cmdLine) {
        int res;
        ExternalProcessBuilder pb = new ExternalProcessBuilder(cmdLine.get(0));
        pb = pb.addEnvironmentVariable(ENV_JAVA_HOME, FileUtil.toFile((FileObject)((FileObject)JavaPlatform.getDefault().getInstallFolders().iterator().next())).getAbsolutePath());
        for (String arg : cmdLine.subList(1, cmdLine.size())) {
            pb = pb.addArgument(arg);
        }
        try {
            Process process = pb.call();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    System.out.println(line);
                }
            }
            process.waitFor();
            res = process.exitValue();
        }
        catch (IOException | InterruptedException e) {
            res = -1;
        }
        return res;
    }

    private static int upload(@NonNull File folder, @NonNull String path, @NonNull ConnectionMethod cm, @NonNull WizardDescriptor wd) {
        File buildScript;
        Object scriptObject = wd.getProperty("buildscript");
        File file = buildScript = scriptObject != null ? (File)scriptObject : null;
        if (buildScript == null || !buildScript.exists()) {
            buildScript = RemotePlatformProbe.createBuildScript();
            wd.putProperty("buildscript", (Object)buildScript);
        }
        return RemotePlatformProbe.uploadJRE(folder.getAbsolutePath(), path, cm, buildScript);
    }

    public void setWizardDescriptor(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
    }

    private static class ConnectionValidator
    implements Callable<Properties> {
        private final String jreLocation;
        private final String workingDir;
        private final ConnectionMethod connectionMethod;
        private final File buildScript;

        ConnectionValidator(@NonNull String jreLocation, @NonNull String workingDir, @NonNull ConnectionMethod connectionMethod, @NullAllowed File buildScript) {
            Parameters.notNull((CharSequence)"jreLocation", (Object)jreLocation);
            Parameters.notNull((CharSequence)"workingDir", (Object)workingDir);
            Parameters.notNull((CharSequence)"connectionMethod", (Object)connectionMethod);
            this.jreLocation = jreLocation;
            this.workingDir = workingDir;
            this.connectionMethod = connectionMethod;
            this.buildScript = buildScript;
        }

        @Override
        public Properties call() throws WizardValidationException {
            return RemotePlatformProbe.verifyPlatform(this.jreLocation, null, this.workingDir, this.connectionMethod, this.buildScript);
        }
    }

    static class Panel
    implements WizardDescriptor.AsynchronousValidatingPanel<WizardDescriptor>,
    ChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private SetUpRemotePlatform ui;
        private boolean valid = false;
        private volatile WizardDescriptor wizardDescriptor;
        private volatile ConnectionValidator connectionValidator;

        public Component getComponent() {
            if (this.ui == null) {
                this.ui = new SetUpRemotePlatform();
                this.ui.addChangeListener(this);
            }
            this.checkPanelValidity();
            return this.ui;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(SetUpRemotePlatform.HELP_ID);
        }

        public void readSettings(WizardDescriptor settings) {
            this.wizardDescriptor = settings;
            this.ui.setWizardDescriptor(this.wizardDescriptor);
            if (settings.getProperty("displayName") != null) {
                this.ui.displayName.setText((String)settings.getProperty("displayName"));
            }
            if (settings.getProperty("host") != null) {
                this.ui.host.setText((String)settings.getProperty("host"));
            }
            if (settings.getProperty("port") != null) {
                this.ui.port.setValue((Integer)settings.getProperty("port"));
            }
            if (settings.getProperty("username") != null) {
                this.ui.username.setText((String)settings.getProperty("username"));
            }
            if (settings.getProperty("password") != null) {
                this.ui.password.setText((String)settings.getProperty("password"));
                this.ui.radioButtonPassword.setSelected(true);
            }
            if (settings.getProperty("keyfile") != null) {
                this.ui.keyFilePath.setText((String)settings.getProperty("keyfile"));
                this.ui.radioButtonKey.setSelected(true);
            }
            if (settings.getProperty("passphrase") != null) {
                this.ui.passphrase.setText((String)settings.getProperty("passphrase"));
            }
            if (settings.getProperty("jrePath") != null) {
                this.ui.jreLocation.setText((String)settings.getProperty("jrePath"));
            }
            if (settings.getProperty("workingDir") != null) {
                this.ui.workingDir.setText((String)settings.getProperty("workingDir"));
            }
        }

        public void storeSettings(WizardDescriptor settings) {
            settings.putProperty("displayName", (Object)this.ui.displayName.getText());
            settings.putProperty("host", (Object)this.ui.host.getText());
            settings.putProperty("port", (Object)((Integer)this.ui.port.getValue()));
            settings.putProperty("username", (Object)this.ui.username.getText());
            if (this.ui.radioButtonPassword.isSelected()) {
                settings.putProperty("password", (Object)String.valueOf(this.ui.password.getPassword()));
                settings.putProperty("keyfile", null);
                settings.putProperty("passphrase", null);
            } else {
                settings.putProperty("keyfile", (Object)this.ui.keyFilePath.getText());
                settings.putProperty("passphrase", (Object)String.valueOf(this.ui.passphrase.getPassword()));
                settings.putProperty("password", null);
            }
            settings.putProperty("jrePath", (Object)this.ui.jreLocation.getText());
            settings.putProperty("workingDir", (Object)this.ui.workingDir.getText());
        }

        public boolean isValid() {
            return this.valid;
        }

        public void addChangeListener(@NonNull ChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.changeSupport.removeChangeListener(listener);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.valid = this.checkPanelValidity();
            this.changeSupport.fireChange();
        }

        private boolean checkPanelValidity() {
            this.ui.buttonCreate.setEnabled(false);
            if (this.ui.displayName.getText().isEmpty()) {
                this.displayNotification(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"ERROR_Empty_DisplayName"));
                return false;
            }
            if (!RemotePlatformProvider.isValidPlatformAntName(PropertyUtils.getUsablePropertyName((String)this.ui.displayName.getText()))) {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SetUpRemotePlatform.class, (String)"ERROR_PlatformAlreadyExists"));
                return false;
            }
            if (this.ui.host.getText().isEmpty()) {
                this.displayNotification(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"ERROR_Empty_Host"));
                return false;
            }
            if (this.ui.username.getText().isEmpty()) {
                this.displayNotification(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"ERROR_Empty_Username"));
                return false;
            }
            if (this.ui.radioButtonPassword.isSelected() && this.ui.password.getPassword().length == 0) {
                this.displayNotification(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"ERROR_Empty_Password"));
                return false;
            }
            if (this.ui.radioButtonKey.isSelected() && this.ui.keyFilePath.getText().isEmpty()) {
                this.displayNotification(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"ERROR_Empty_KeyFile"));
                return false;
            }
            this.ui.buttonCreate.setEnabled(true);
            if (this.ui.jreLocation.getText().isEmpty()) {
                this.displayNotification(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"ERROR_Empty_JRE"));
                return false;
            }
            if (this.ui.workingDir.getText().isEmpty()) {
                this.displayNotification(NbBundle.getMessage(SetUpRemotePlatform.class, (String)"MSG_Empty_WorkingDir"));
                return false;
            }
            if (!this.valid) {
                this.displayNotification("");
            }
            return true;
        }

        private void displayNotification(String message) {
            if (this.wizardDescriptor != null) {
                this.wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)message);
            }
        }

        public void prepareValidation() {
            if (this.ui != null) {
                ConnectionMethod cm = this.ui.radioButtonPassword.isSelected() ? ConnectionMethod.sshPassword(this.ui.host.getText(), (Integer)this.ui.port.getValue(), this.ui.username.getText(), String.valueOf(this.ui.password.getPassword())) : ConnectionMethod.sshKey(this.ui.host.getText(), (Integer)this.ui.port.getValue(), this.ui.username.getText(), new File(this.ui.keyFilePath.getText()), String.valueOf(this.ui.passphrase.getPassword()));
                File buildScript = (File)this.wizardDescriptor.getProperty("buildscript");
                this.connectionValidator = new ConnectionValidator(this.ui.jreLocation.getText(), this.ui.workingDir.getText(), cm, buildScript);
            }
        }

        public void validate() throws WizardValidationException {
            ConnectionValidator cv = this.connectionValidator;
            if (cv != null) {
                Properties props = cv.call();
                this.wizardDescriptor.putProperty("sysProperties", (Object)props);
            }
        }
    }
}

