/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.ProvidedExtensionsAccessor;
import org.netbeans.modules.masterfs.providers.BaseAnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class ProvidedExtensionsProxy
extends ProvidedExtensions {
    private final Collection<BaseAnnotationProvider> annotationProviders;
    private static final ThreadLocal<Boolean> reentrantCheck = new ThreadLocal();

    public ProvidedExtensionsProxy(Collection<BaseAnnotationProvider> annotationProviders) {
        this.annotationProviders = annotationProviders;
    }

    @Override
    public ProvidedExtensions.IOHandler getCopyHandler(File from, File to) {
        if (to == null) {
            return null;
        }
        DelegatingIOHandler retValue = null;
        Iterator<BaseAnnotationProvider> it = this.annotationProviders.iterator();
        while (it.hasNext() && retValue == null) {
            BaseAnnotationProvider provider = it.next();
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensions.IOHandler delgate = pe.getCopyHandler(from, to);
            retValue = delgate != null ? new DelegatingIOHandler(delgate) : null;
        }
        return retValue;
    }

    @Override
    public ProvidedExtensions.DeleteHandler getDeleteHandler(File f) {
        DelegatingDeleteHandler retValue = null;
        Iterator<BaseAnnotationProvider> it = this.annotationProviders.iterator();
        while (it.hasNext() && retValue == null) {
            BaseAnnotationProvider provider = it.next();
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensions.DeleteHandler delegate = pe.getDeleteHandler(f);
            retValue = delegate != null ? new DelegatingDeleteHandler(delegate) : null;
        }
        return retValue;
    }

    @Override
    public ProvidedExtensions.IOHandler getRenameHandler(File from, String newName) {
        DelegatingIOHandler retValue = null;
        Iterator<BaseAnnotationProvider> it = this.annotationProviders.iterator();
        while (it.hasNext() && retValue == null) {
            BaseAnnotationProvider provider = it.next();
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensions.IOHandler delgate = pe.getRenameHandler(from, newName);
            retValue = delgate != null ? new DelegatingIOHandler(delgate) : null;
        }
        return retValue;
    }

    @Override
    public ProvidedExtensions.IOHandler getMoveHandler(File from, File to) {
        if (to == null) {
            return null;
        }
        DelegatingIOHandler retValue = null;
        Iterator<BaseAnnotationProvider> it = this.annotationProviders.iterator();
        while (it.hasNext() && retValue == null) {
            BaseAnnotationProvider provider = it.next();
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensions.IOHandler delgate = pe.getMoveHandler(from, to);
            retValue = delgate != null ? new DelegatingIOHandler(delgate) : null;
        }
        return retValue;
    }

    @Override
    public void createFailure(FileObject parent, String name, boolean isFolder) {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (iListener == null) continue;
            ProvidedExtensionsProxy.runCheckCode(() -> iListener.createFailure(parent, name, isFolder));
        }
    }

    @Override
    public void beforeCreate(FileObject parent, String name, boolean isFolder) {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (iListener == null) continue;
            ProvidedExtensionsProxy.runCheckCode(() -> iListener.beforeCreate(parent, name, isFolder));
        }
    }

    @Override
    public void deleteSuccess(FileObject fo) {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (iListener == null) continue;
            ProvidedExtensionsProxy.runCheckCode(() -> iListener.deleteSuccess(fo));
        }
    }

    @Override
    public void deleteFailure(FileObject fo) {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (iListener == null) continue;
            ProvidedExtensionsProxy.runCheckCode(() -> iListener.deleteFailure(fo));
        }
    }

    @Override
    public void createSuccess(FileObject fo) {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (iListener == null) continue;
            ProvidedExtensionsProxy.runCheckCode(() -> iListener.createSuccess(fo));
        }
    }

    @Override
    public void beforeDelete(FileObject fo) {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (iListener == null) continue;
            ProvidedExtensionsProxy.runCheckCode(() -> iListener.beforeDelete(fo));
        }
    }

    @Override
    public boolean canWrite(File f) {
        Boolean[] ret = new Boolean[]{null};
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> {
                ProvidedExtensions extension = pe;
                if (ProvidedExtensionsAccessor.IMPL != null && ProvidedExtensionsAccessor.IMPL.providesCanWrite(extension)) {
                    ret[0] = pe.canWrite(f);
                }
            });
            if (ret[0] == null || !ret[0].booleanValue()) continue;
            break;
        }
        return ret[0] != null ? ret[0].booleanValue() : super.canWrite(f);
    }

    @Override
    public void beforeChange(FileObject f) {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> pe.beforeChange(f));
        }
    }

    @Override
    public void fileLocked(FileObject fo) throws IOException {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> pe.fileLocked(fo));
        }
    }

    @Override
    public void fileUnlocked(FileObject fo) {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> pe.fileUnlocked(fo));
        }
    }

    @Override
    public Object getAttribute(File file, String attrName) {
        AtomicReference value = new AtomicReference();
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener;
            InterceptionListener interceptionListener = iListener = provider != null ? provider.getInterceptionListener() : null;
            if (iListener instanceof ProvidedExtensions) {
                ProvidedExtensions pe = (ProvidedExtensions)iListener;
                ProvidedExtensionsProxy.runCheckCode(() -> value.set(pe.getAttribute(file, attrName)));
            }
            if (value.get() == null) continue;
            return value.get();
        }
        return null;
    }

    @Override
    public long refreshRecursively(File dir, long lastTimeStamp, List<? super File> children) {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            int prev = children.size();
            long ret = pe.refreshRecursively(dir, lastTimeStamp, children);
            assert (ret != -1L || prev == children.size()) : "When returning -1 from refreshRecursively, you cannot modify children: " + pe;
            if (ret == -1L) continue;
            return ret;
        }
        File[] arr = dir.listFiles();
        if (arr != null) {
            children.addAll(Arrays.asList(arr));
        }
        return 0L;
    }

    @Override
    public void createdExternally(FileObject fo) {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> pe.createdExternally(fo));
        }
    }

    @Override
    public void deletedExternally(FileObject fo) {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> pe.deletedExternally(fo));
        }
    }

    @Override
    public void fileChanged(FileObject fo) {
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> pe.fileChanged(fo));
        }
    }

    @Override
    public void beforeMove(FileObject from, File to) {
        if (to == null) {
            return;
        }
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> pe.beforeMove(from, to));
        }
    }

    @Override
    public void moveSuccess(FileObject from, File to) {
        if (to == null) {
            return;
        }
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> pe.moveSuccess(from, to));
        }
    }

    @Override
    public void moveFailure(FileObject from, File to) {
        if (to == null) {
            return;
        }
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> pe.moveFailure(from, to));
        }
    }

    @Override
    public void beforeCopy(FileObject from, File to) {
        if (to == null) {
            return;
        }
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> pe.beforeCopy(from, to));
        }
    }

    @Override
    public void copySuccess(FileObject from, File to) {
        if (to == null) {
            return;
        }
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> pe.copySuccess(from, to));
        }
    }

    @Override
    public void copyFailure(FileObject from, File to) {
        if (to == null) {
            return;
        }
        for (BaseAnnotationProvider provider : this.annotationProviders) {
            InterceptionListener iListener = provider != null ? provider.getInterceptionListener() : null;
            if (!(iListener instanceof ProvidedExtensions)) continue;
            ProvidedExtensions pe = (ProvidedExtensions)iListener;
            ProvidedExtensionsProxy.runCheckCode(() -> pe.copyFailure(from, to));
        }
    }

    public static void checkReentrancy() {
        if (reentrantCheck.get() != null) {
            Logger.getLogger("org.netbeans.modules.masterfs.ProvidedExtensionsProxy").log(Level.INFO, "Unexpected reentrant call", new Throwable());
        }
    }

    private static void runCheckCode(Runnable code) {
        try {
            reentrantCheck.set(Boolean.TRUE);
            code.run();
        }
        finally {
            reentrantCheck.set(null);
        }
    }

    private static void runCheckCode(FileSystem.AtomicAction code) throws IOException {
        try {
            reentrantCheck.set(Boolean.TRUE);
            code.run();
        }
        finally {
            reentrantCheck.set(null);
        }
    }

    private class DelegatingIOHandler
    implements ProvidedExtensions.IOHandler {
        private final ProvidedExtensions.IOHandler delegate;

        private DelegatingIOHandler(ProvidedExtensions.IOHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void handle() throws IOException {
            IOException[] retval = new IOException[1];
            ProvidedExtensionsProxy.runCheckCode(() -> {
                try {
                    this.delegate.handle();
                }
                catch (IOException ex) {
                    retval[0] = ex;
                }
            });
            if (retval[0] != null) {
                throw retval[0];
            }
        }
    }

    private class DelegatingDeleteHandler
    implements ProvidedExtensions.DeleteHandler {
        private final ProvidedExtensions.DeleteHandler delegate;

        private DelegatingDeleteHandler(ProvidedExtensions.DeleteHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean delete(File file) {
            boolean[] retval = new boolean[1];
            ProvidedExtensionsProxy.runCheckCode(() -> {
                retval[0] = this.delegate.delete(file);
            });
            return retval[0];
        }
    }
}

