/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.utils;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleObjCache<K, V> {
    private final int maxSize;
    private final ConcurrentHashMap<K, ValueWrapper> map;

    public SimpleObjCache(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("Cache max size cannot be zero or less");
        }
        this.maxSize = maxSize;
        this.map = new ConcurrentHashMap();
    }

    public V put(K key, V value) {
        this.evictIfFull();
        ValueWrapper existingValue = this.map.put(key, new ValueWrapper(value));
        if (existingValue != null) {
            return existingValue.value;
        }
        return null;
    }

    public V get(K key) {
        ValueWrapper wrapper = this.map.get(key);
        if (wrapper != null) {
            wrapper.lastUsed.set(System.currentTimeMillis());
            return wrapper.value;
        }
        return null;
    }

    public int getCacheSize() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    private synchronized void evictIfFull() {
        K toBeEvicted;
        if (this.map.size() >= this.maxSize && (toBeEvicted = this.findEvictionCandidate()) != null) {
            this.map.remove(toBeEvicted);
        }
    }

    private K findEvictionCandidate() {
        Optional<Map.Entry> minEntry = this.map.entrySet().stream().min(Comparator.comparingLong(e -> ((ValueWrapper)e.getValue()).lastUsed.get()));
        if (minEntry.isPresent()) {
            return minEntry.get().getKey();
        }
        return null;
    }

    private class ValueWrapper {
        private final AtomicLong lastUsed = new AtomicLong(System.currentTimeMillis());
        private final V value;

        public ValueWrapper(V value) {
            this.value = value;
        }
    }
}

