/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.typinghooks;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.web.indent.api.LexUtilities;
import org.netbeans.spi.editor.typinghooks.TypedBreakInterceptor;
import org.openide.util.Exceptions;

public class HtmlTypedBreakInterceptor
implements TypedBreakInterceptor {
    private Position[] reformat;

    public boolean beforeInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void insert(TypedBreakInterceptor.MutableContext context) throws BadLocationException {
        int offset;
        BaseDocument doc = (BaseDocument)context.getDocument();
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)(offset = context.getBreakInsertOffset()), (Language)HTMLTokenId.language());
        if (ts == null) {
            return;
        }
        ts.move(offset);
        String closingTagName = null;
        int end = -1;
        if (ts.moveNext() && ts.token().id() == HTMLTokenId.TAG_OPEN_SYMBOL && ts.token().text().toString().equals("</") && ts.moveNext() && ts.token().id() == HTMLTokenId.TAG_CLOSE) {
            closingTagName = ts.token().text().toString();
            end = ts.offset() + ts.token().text().length();
            ts.movePrevious();
            ts.movePrevious();
        }
        if (closingTagName == null) {
            return;
        }
        boolean foundOpening = false;
        if (ts.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL && ts.token().text().toString().equals(">")) {
            while (ts.movePrevious()) {
                if (ts.token().id() != HTMLTokenId.TAG_OPEN) continue;
                if (!ts.token().text().toString().equals(closingTagName)) break;
                foundOpening = true;
                break;
            }
        }
        if (foundOpening) {
            context.setText("\n\n", 1, 1, new int[0]);
            int from = LineDocumentUtils.getLineStartOffset((LineDocument)doc, (int)offset);
            int to = LineDocumentUtils.getLineEndOffset((LineDocument)doc, (int)offset);
            this.reformat = new Position[]{doc.createPosition(from), doc.createPosition(to)};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
        if (this.reformat != null) {
            final Position[] range = this.reformat;
            this.reformat = null;
            BaseDocument doc = (BaseDocument)context.getDocument();
            final Indent indent = Indent.get((Document)doc);
            indent.lock();
            try {
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            indent.reindent(range[0].getOffset(), range[1].getOffset());
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            finally {
                indent.unlock();
            }
        }
    }

    public void cancelled(TypedBreakInterceptor.Context context) {
    }

    public static final class Factory
    implements TypedBreakInterceptor.Factory {
        public TypedBreakInterceptor createTypedBreakInterceptor(MimePath mimePath) {
            return new HtmlTypedBreakInterceptor();
        }
    }
}

