/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsps.parserapi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ELNode {
    public abstract void accept(Visitor var1);

    public static class Visitor {
        public void visit(Root n) {
            n.getExpression().visit(this);
        }

        public void visit(Function n) {
        }

        public void visit(Text n) {
        }

        public void visit(ELText n) {
        }
    }

    public static class Nodes {
        private String mapName = null;
        private final List<ELNode> list = new ArrayList<ELNode>();

        public void add(ELNode en) {
            this.list.add(en);
        }

        public void visit(Visitor v) {
            for (ELNode n : this.list) {
                n.accept(v);
            }
        }

        public Iterator<ELNode> iterator() {
            return this.list.iterator();
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public boolean containsEL() {
            for (ELNode n : this.list) {
                if (!(n instanceof Root)) continue;
                return true;
            }
            return false;
        }

        public void setMapName(String name) {
            this.mapName = name;
        }

        public String getMapName() {
            return this.mapName;
        }
    }

    public static class Function
    extends ELNode {
        private final String prefix;
        private final String name;
        private String uri;
        private String methodName;
        private String[] parameters;

        Function(String prefix, String name) {
            this.prefix = prefix;
            this.name = name;
        }

        @Override
        public void accept(Visitor v) {
            v.visit(this);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getName() {
            return this.name;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getUri() {
            return this.uri;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setParameters(String[] parameters) {
            this.parameters = parameters;
        }

        public String[] getParameters() {
            return this.parameters;
        }
    }

    public static class ELText
    extends ELNode {
        private final String text;

        public ELText(String text) {
            this.text = text;
        }

        @Override
        public void accept(Visitor v) {
            v.visit(this);
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Text
    extends ELNode {
        private final String text;

        public Text(String text) {
            this.text = text;
        }

        @Override
        public void accept(Visitor v) {
            v.visit(this);
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Root
    extends ELNode {
        private final Nodes expr;

        public Root(Nodes expr) {
            this.expr = expr;
        }

        @Override
        public void accept(Visitor v) {
            v.visit(this);
        }

        public Nodes getExpression() {
            return this.expr;
        }
    }
}

