/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.env;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.languages.env.lexer.EnvTokenId;
import org.netbeans.modules.languages.env.parser.EnvParserResult;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class EnvOccurencesFinder
extends OccurrencesFinder<EnvParserResult> {
    private int caretPosition;
    private boolean cancelled;
    private final Map<OffsetRange, ColoringAttributes> occurrences = new HashMap<OffsetRange, ColoringAttributes>();

    public void setCaretPosition(int position) {
        this.caretPosition = position;
    }

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return Collections.unmodifiableMap(this.occurrences);
    }

    public void run(EnvParserResult result, SchedulerEvent event) {
        this.occurrences.clear();
        if (this.checkAndResetCancel()) {
            return;
        }
        this.computeOccurrences(result);
    }

    public int getPriority() {
        return 200;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isKeepMarks() {
        return true;
    }

    public boolean isMarkOccurrencesEnabled() {
        return true;
    }

    private boolean checkAndResetCancel() {
        if (this.cancelled) {
            this.cancelled = false;
            return true;
        }
        return false;
    }

    private void computeOccurrences(EnvParserResult result) {
        TokenHierarchy tokenHierarchy = result.getSnapshot().getTokenHierarchy();
        TokenSequence ts = tokenHierarchy.tokenSequence();
        ts.move(this.caretPosition);
        if (ts.movePrevious()) {
            Token token = ts.token();
            if (!token.id().equals((Object)EnvTokenId.KEY)) {
                ts.moveNext();
                token = ts.token();
            }
            if (token.id().equals((Object)EnvTokenId.KEY)) {
                String tokenText = token.text().toString();
                for (OffsetRange offsetRange : result.getOccurrences(tokenText)) {
                    this.occurrences.put(offsetRange, ColoringAttributes.MARK_OCCURRENCES);
                }
            }
        }
    }
}

