/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.env.hints;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.languages.env.hints.DuplicateKeyAssignment;
import org.netbeans.modules.languages.env.parser.EnvParserResult;
import org.openide.util.NbBundle;

public class EnvHintsProvider
implements HintsProvider {
    public static final String ENV_HINTS_GROUP_KIND = "env.option.duplicatekey.hints";

    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints) {
        if (!(context.parserResult instanceof EnvParserResult)) {
            return;
        }
        EnvParserResult parserResult = (EnvParserResult)context.parserResult;
        Map allHints = manager.getHints(false, context);
        List hintRules = (List)allHints.get(ENV_HINTS_GROUP_KIND);
        if (hintRules == null) {
            return;
        }
        for (Rule.AstRule astRule : hintRules) {
            if (!manager.isEnabled((Rule.UserConfigurableRule)astRule) || !(astRule instanceof DuplicateKeyAssignment)) continue;
            for (Map.Entry<String, List<OffsetRange>> entry : parserResult.getKeyDefinitions().entrySet()) {
                int listSize = entry.getValue().size();
                if (listSize == 1) continue;
                for (OffsetRange range : entry.getValue().subList(1, listSize)) {
                    hints.add(new Hint((Rule)astRule, NbBundle.getMessage(EnvHintsProvider.class, (String)"DuplicateKeyHintMsg"), context.parserResult.getSnapshot().getSource().getFileObject(), range, this.configHintsFixList(), 10));
                }
            }
        }
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        unhandled.addAll(context.parserResult.getDiagnostics());
    }

    public void cancel() {
    }

    public List<Rule> getBuiltinRules() {
        return null;
    }

    public RuleContext createRuleContext() {
        return new EnvRuleContext();
    }

    private List<HintFix> configHintsFixList() {
        LinkedList<HintFix> fixes = new LinkedList<HintFix>();
        fixes.add(new ConfigHintFix());
        return fixes;
    }

    public class EnvRuleContext
    extends RuleContext {
        public boolean isCancelled() {
            return false;
        }
    }

    private static class ConfigHintFix
    implements HintFix {
        public String getDescription() {
            return "Configure Hints";
        }

        public void implement() throws Exception {
            OptionsDisplayer displayer = OptionsDisplayer.getDefault();
            displayer.open("Editor/Hints/text/x-env");
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

