/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.env.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.languages.env.grammar.antlr4.parser.EnvAntlrLexer;
import org.netbeans.modules.languages.env.grammar.antlr4.parser.EnvAntlrParser;
import org.netbeans.modules.languages.env.grammar.antlr4.parser.EnvAntlrParserBaseListener;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class EnvParserResult
extends ParserResult {
    private final List<DefaultError> errors = new ArrayList<DefaultError>();
    private final Map<String, OffsetRange> definedKeys = new HashMap<String, OffsetRange>();
    private final Map<String, List<OffsetRange>> keyDefintions = new HashMap<String, List<OffsetRange>>();
    private final Map<String, List<OffsetRange>> interpolationOccurences = new HashMap<String, List<OffsetRange>>();
    volatile boolean finished = false;

    public EnvParserResult(Snapshot snapshot) {
        super(snapshot);
    }

    public EnvParserResult get() {
        if (!this.finished) {
            EnvAntlrLexer lexer = new EnvAntlrLexer((CharStream)CharStreams.fromString((String)String.valueOf(this.getSnapshot().getText())));
            EnvAntlrParser parser = new EnvAntlrParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            parser.setBuildParseTree(false);
            parser.addErrorListener(this.createErrorListener());
            parser.addParseListener(new EnvKeyListener());
            parser.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
            parser.envFile();
            this.finished = true;
        }
        return this;
    }

    public List<? extends Error> getDiagnostics() {
        return this.errors;
    }

    protected void invalidate() {
    }

    private ANTLRErrorListener createErrorListener() {
        return new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                int errorPosition = 0;
                if (offendingSymbol instanceof Token) {
                    Token offendingToken = (Token)offendingSymbol;
                    errorPosition = offendingToken.getStartIndex();
                }
                EnvParserResult.this.errors.add(new BadgingDefaultError(null, msg, null, EnvParserResult.this.getFileObject(), errorPosition, errorPosition, Severity.ERROR, true));
            }
        };
    }

    public final List<? extends OffsetRange> getOccurrences(String refName) {
        ArrayList<OffsetRange> ret = new ArrayList<OffsetRange>();
        if (this.keyDefintions.containsKey(refName)) {
            ret.add(this.definedKeys.get(refName));
        }
        if (this.interpolationOccurences.containsKey(refName)) {
            ret.addAll((Collection)this.interpolationOccurences.get(refName));
        }
        return ret;
    }

    public Map<String, OffsetRange> getDefinedKeys() {
        return Collections.unmodifiableMap(this.definedKeys);
    }

    public Map<String, List<OffsetRange>> getInterpolationOccurences() {
        return Collections.unmodifiableMap(this.interpolationOccurences);
    }

    public Map<String, List<OffsetRange>> getKeyDefinitions() {
        return Collections.unmodifiableMap(this.keyDefintions);
    }

    protected final FileObject getFileObject() {
        return this.getSnapshot().getSource().getFileObject();
    }

    private class EnvKeyListener
    extends EnvAntlrParserBaseListener {
        private EnvKeyListener() {
        }

        @Override
        public void exitVarAssign(EnvAntlrParser.VarAssignContext ctx) {
            Token keyToken = ctx.start;
            if (keyToken == null) {
                return;
            }
            String keyName = keyToken.getText();
            OffsetRange range = new OffsetRange(keyToken.getStartIndex(), keyToken.getStopIndex() + 1);
            EnvParserResult.this.definedKeys.putIfAbsent(keyName, range);
            EnvParserResult.this.keyDefintions.computeIfAbsent(keyName, s -> new ArrayList()).add(range);
        }

        @Override
        public void exitInterpolatedKey(EnvAntlrParser.InterpolatedKeyContext ctx) {
            Token keyToken = ctx.keyName;
            if (keyToken == null) {
                return;
            }
            OffsetRange range = new OffsetRange(keyToken.getStartIndex(), keyToken.getStopIndex() + 1);
            EnvParserResult.this.interpolationOccurences.computeIfAbsent(keyToken.getText(), s -> new ArrayList()).add(range);
        }
    }

    private class BadgingDefaultError
    extends DefaultError
    implements Error.Badging {
        private boolean badging;

        public BadgingDefaultError(String key, String displayName, String description, FileObject file, int start, int end, Severity severity, boolean badging) {
            super(key, displayName, description, file, start, end, severity);
            this.badging = badging;
        }

        public boolean showExplorerBadge() {
            return this.badging;
        }
    }
}

