/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.PortForward;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.NotificationUtils;
import org.netbeans.modules.cloud.oracle.assets.k8s.Bundle;
import org.netbeans.modules.cloud.oracle.assets.k8s.KubernetesUtils;
import org.netbeans.modules.cloud.oracle.assets.k8s.PodItem;
import org.netbeans.modules.cloud.oracle.assets.k8s.PortForwardItem;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class PortForwards {
    private static int LIMIT = 10;
    private static final RequestProcessor RP = new RequestProcessor(PortForwards.class.getName(), LIMIT);
    private static PortForwards instance = null;
    private final Map<PodItem, List<PortForwardItem>> activePortForwards = new ConcurrentHashMap<PodItem, List<PortForwardItem>>();
    private final Map<String, CountDownLatch> stopLatches = new ConcurrentHashMap<String, CountDownLatch>();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private PortForwards() {
    }

    public static synchronized PortForwards getDefault() {
        if (instance == null) {
            instance = new PortForwards();
        }
        return instance;
    }

    public void addPropertyChangeListener(PodItem pod, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(pod.getName(), listener);
    }

    public void removePropertyChangeListener(PodItem pod, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(pod.getName(), listener);
    }

    private void firePropertyChange(PodItem pod, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(pod.getName(), oldValue, newValue);
    }

    public void startPortForward(PodItem podItem) {
        if (this.activePortForwards.containsKey(podItem)) {
            NotificationUtils.showMessage(Bundle.AlreadyActive(podItem.getName()));
            return;
        }
        if (this.activePortForwards.size() >= LIMIT) {
            NotificationUtils.showMessage(Bundle.MaxForwards(LIMIT));
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.Forwarding(podItem.getName()), () -> {
            this.closePortForward(podItem);
            return true;
        });
        handle.start();
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> KubernetesUtils.runWithClient(podItem.getCluster(), client -> {
            Pod pod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(podItem.getNamespace())).withName(podItem.getName())).get();
            if (pod == null) {
                NotificationUtils.showMessage(Bundle.PodNotFound(podItem.getName()));
                return;
            }
            List ports = pod.getSpec().getContainers().stream().flatMap(container -> container.getPorts().stream()).map(port -> port.getContainerPort()).collect(Collectors.toList());
            ArrayList<PortForwardItem> forwardItems = new ArrayList<PortForwardItem>();
            if (ports.isEmpty()) {
                NotificationUtils.showMessage(Bundle.NoPorts(podItem.getName()));
                return;
            }
            try {
                for (Integer port2 : ports) {
                    if (!PortForwards.isPortAvailable(port2)) {
                        NotificationUtils.showErrorMessage(Bundle.PortNotFree(port2));
                        break;
                    }
                    LocalPortForward fwd = ((PodResource)((NonNamespaceOperation)client.pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName())).portForward(port2.intValue(), port2.intValue());
                    forwardItems.add(new PortForwardItem(podItem, fwd.getLocalPort(), port2, (PortForward)fwd));
                }
                this.stopLatches.put(podItem.getName(), latch);
                this.activePortForwards.put(podItem, forwardItems);
                this.firePropertyChange(podItem, null, 1);
                latch.await();
            }
            catch (IllegalStateException | InterruptedException ex) {
                NotificationUtils.showErrorMessage(ex.getMessage());
            }
            finally {
                handle.finish();
            }
        }), (Executor)RP);
    }

    public List<PortForwardItem> getActivePortForwards(PodItem pod) {
        return this.activePortForwards.getOrDefault(pod, Collections.emptyList());
    }

    public void closePortForward(PodItem pod) {
        List<PortForwardItem> removed = this.activePortForwards.remove(pod);
        CountDownLatch latch = this.stopLatches.remove(pod.getName());
        if (latch != null) {
            latch.countDown();
        }
        for (PortForwardItem portForwardItem : removed) {
            PortForward fwd = portForwardItem.getForward();
            if (fwd == null || !fwd.isAlive()) continue;
            try {
                fwd.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.firePropertyChange(pod, 1, null);
    }

    private static boolean isPortAvailable(int port) {
        boolean bl;
        ServerSocket serverSocket = new ServerSocket(port);
        try {
            serverSocket.setReuseAddress(true);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        serverSocket.close();
        return bl;
    }
}

