/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor.indent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.smarty.editor.TplSyntax;
import org.netbeans.modules.php.smarty.editor.lexer.TplTokenId;
import org.netbeans.modules.php.smarty.editor.lexer.TplTopTokenId;
import org.netbeans.modules.web.indent.api.LexUtilities;
import org.netbeans.modules.web.indent.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.web.indent.api.support.AbstractIndenter;
import org.netbeans.modules.web.indent.api.support.IndentCommand;
import org.netbeans.modules.web.indent.api.support.IndenterContextData;

public class TplIndenter
extends AbstractIndenter<TplTopTokenId> {
    private static final Logger LOGGER = Logger.getLogger(TplIndenter.class.getName());
    private Stack<TplStackItem> stack = null;
    private int preservedLineIndentation = -1;

    public TplIndenter(Context context) {
        super(TplTopTokenId.language(), context);
    }

    private Stack<TplStackItem> getStack() {
        return this.stack;
    }

    private String getFunctionalTplTokenId(Token<TplTopTokenId> token) {
        TokenHierarchy th = TokenHierarchy.create((CharSequence)token.text(), TplTokenId.language());
        TokenSequence sequence = th.tokenSequence(TplTokenId.language());
        while (sequence.moveNext()) {
            if (sequence.token().id() == TplTokenId.WHITESPACE) continue;
            return CharSequenceUtilities.toString((CharSequence)sequence.token().text());
        }
        return "";
    }

    protected boolean isWhiteSpaceToken(Token<TplTopTokenId> token) {
        return this.getFunctionalTplTokenId(token).equals("");
    }

    private boolean isCommentToken(Token<TplTopTokenId> token) {
        return token.id() == TplTopTokenId.T_COMMENT;
    }

    protected void reset() {
        this.stack = new Stack();
        this.preservedLineIndentation = -1;
    }

    protected int getFormatStableStart(JoinedTokenSequence<TplTopTokenId> ts, int startOffset, int endOffset, AbstractIndenter.OffsetRanges rangesToIgnore) {
        ts.move(endOffset, false);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return LexUtilities.getTokenSequenceStartOffset(ts);
        }
        int balance = 0;
        do {
            Token token;
            TokenId id;
            if ((id = (token = ts.token()).id()) == TplTopTokenId.T_SMARTY && ts.offset() < startOffset && balance == 0) {
                int[] index = ts.index();
                ts.moveNext();
                Token tk = LexUtilities.findNext(ts, Arrays.asList(TplTopTokenId.T_SMARTY));
                ts.moveIndex(index);
                ts.moveNext();
                if (tk == null || tk.id() != TplTopTokenId.T_SMARTY_OPEN_DELIMITER) continue;
                if (ts.movePrevious() && (tk = LexUtilities.findPrevious(ts, Arrays.asList(TplTopTokenId.T_SMARTY))) != null) {
                    ts.moveNext();
                }
                return ts.offset();
            }
            if (id == TplTopTokenId.T_SMARTY_CLOSE_DELIMITER) {
                ++balance;
                continue;
            }
            if (id == TplTopTokenId.T_SMARTY_OPEN_DELIMITER) {
                --balance;
                continue;
            }
            if (id != TplTopTokenId.T_SMARTY || ts.offset() >= startOffset || balance != 0) continue;
            return ts.offset();
        } while (ts.movePrevious());
        return LexUtilities.getTokenSequenceStartOffset(ts);
    }

    private void getIndentFromState(List<IndentCommand> iis, boolean updateState, int lineStartOffset) {
        Stack<TplStackItem> blockStack = this.getStack();
        int lastUnprocessedItem = blockStack.size();
        int i = blockStack.size() - 1;
        while (i >= 0 && !((TplStackItem)blockStack.get((int)i)).processed.booleanValue()) {
            lastUnprocessedItem = i--;
        }
        for (i = lastUnprocessedItem; i < blockStack.size(); ++i) {
            IndentCommand ii;
            TplStackItem item = (TplStackItem)blockStack.get(i);
            assert (!item.processed.booleanValue()) : item;
            if (item.state == StackItemState.IN_BODY) {
                ii = new IndentCommand(IndentCommand.Type.INDENT, lineStartOffset);
                if (item.indent != -1) {
                    ii.setFixedIndentSize(item.indent);
                }
                iis.add(ii);
                if (!updateState) continue;
                item.processed = Boolean.TRUE;
                continue;
            }
            if (item.state != StackItemState.BODY_FINISHED) continue;
            ii = new IndentCommand(IndentCommand.Type.RETURN, lineStartOffset);
            iis.add(ii);
            if (!updateState) continue;
            item.processed = Boolean.TRUE;
            blockStack.remove(i);
            --i;
        }
    }

    protected List<IndentCommand> getLineIndent(IndenterContextData<TplTopTokenId> context, List<IndentCommand> preliminaryNextLineIndent) throws BadLocationException {
        Stack<TplStackItem> blockStack = this.getStack();
        ArrayList<IndentCommand> iis = new ArrayList<IndentCommand>();
        this.getIndentFromState(iis, true, context.getLineStartOffset());
        JoinedTokenSequence ts = context.getJoinedTokenSequences();
        ts.move(context.getLineStartOffset());
        boolean isSmartyBodyCommand = false;
        boolean isSmartyElseCommand = false;
        boolean afterDelimiter = false;
        boolean nonControlCommand = false;
        int embeddingLevel = 0;
        String lastTplCommand = "";
        while (!context.isBlankLine() && ts.moveNext() && (ts.isCurrentTokenSequenceVirtual() && ts.offset() < context.getLineEndOffset() || ts.offset() <= context.getLineEndOffset())) {
            Token token = ts.token();
            if (token == null) continue;
            if (ts.embedded() != null) {
                if (embeddingLevel == 1 && afterDelimiter) {
                    if (token.id() == TplTopTokenId.T_SMARTY && context.isIndentThisLine()) {
                        String tplToken = this.getFunctionalTplTokenId((Token<TplTopTokenId>)token);
                        isSmartyBodyCommand = TplSyntax.isBlockCommand(tplToken);
                        if (!isSmartyBodyCommand) continue;
                        lastTplCommand = tplToken;
                        isSmartyElseCommand = TplSyntax.isElseSmartyCommand(tplToken);
                        continue;
                    }
                    isSmartyBodyCommand = false;
                    isSmartyElseCommand = false;
                    continue;
                }
                if (CharSequenceUtilities.indexOf((CharSequence)token.text(), (CharSequence)"\n") != -1) continue;
                nonControlCommand = true;
                continue;
            }
            if (token.id() == TplTopTokenId.T_SMARTY_OPEN_DELIMITER) {
                afterDelimiter = true;
                ++embeddingLevel;
                TplStackItem state = new TplStackItem(StackItemState.IN_RULE);
                blockStack.push(state);
                continue;
            }
            if (token.id() == TplTopTokenId.T_SMARTY_CLOSE_DELIMITER) {
                afterDelimiter = false;
                if (!this.isInState(blockStack, StackItemState.IN_RULE)) continue;
                TplStackItem item = blockStack.pop();
                if (--embeddingLevel != 0) continue;
                assert (item.state == StackItemState.IN_RULE);
                if (!isSmartyBodyCommand) continue;
                if (!blockStack.isEmpty() && blockStack.peek().getCommand() != null && TplSyntax.isInRelatedCommand(lastTplCommand, blockStack.peek().getCommand())) {
                    if (isSmartyElseCommand) {
                        String command = blockStack.pop().command;
                        blockStack.push(new TplStackItem(StackItemState.IN_BODY, command));
                    } else {
                        blockStack.pop();
                    }
                    if (!nonControlCommand) {
                        iis.add(new IndentCommand(IndentCommand.Type.RETURN, context.getLineStartOffset()));
                    }
                    nonControlCommand = false;
                    continue;
                }
                blockStack.push(new TplStackItem(StackItemState.IN_BODY, lastTplCommand));
                continue;
            }
            if (!this.isCommentToken((Token<TplTopTokenId>)token)) continue;
            int start = context.getLineStartOffset();
            if (start < ts.offset()) {
                start = ts.offset();
            }
            int commentEndOffset = ts.offset() + ts.token().text().toString().trim().length() - 1;
            int end = context.getLineEndOffset();
            if (end > commentEndOffset) {
                end = commentEndOffset;
            }
            if (start > end) continue;
            if (start == ts.offset()) {
                if (end >= commentEndOffset) continue;
                int lineStart = LineDocumentUtils.getLineStartOffset((LineDocument)this.getDocument(), (int)ts.offset());
                this.preservedLineIndentation = start - lineStart;
                continue;
            }
            if (end == commentEndOffset) {
                String text = this.getDocument().getText(start, end - start + 1).trim();
                if (!text.startsWith("*/")) {
                    IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
                    ic.setFixedIndentSize(this.preservedLineIndentation);
                    iis.add(ic);
                }
                this.preservedLineIndentation = -1;
                continue;
            }
            IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
            ic.setFixedIndentSize(this.preservedLineIndentation);
            iis.add(ic);
        }
        if (context.isBlankLine() && iis.isEmpty()) {
            IndentCommand ic = new IndentCommand(IndentCommand.Type.PRESERVE_INDENTATION, context.getLineStartOffset());
            ic.setFixedIndentSize(this.preservedLineIndentation);
            iis.add(ic);
        }
        if (iis.isEmpty()) {
            iis.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, context.getLineStartOffset()));
        }
        if (context.getNextLineStartOffset() != -1) {
            this.getIndentFromState(preliminaryNextLineIndent, false, context.getNextLineStartOffset());
            if (preliminaryNextLineIndent.isEmpty()) {
                preliminaryNextLineIndent.add(new IndentCommand(IndentCommand.Type.NO_CHANGE, context.getNextLineStartOffset()));
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            for (IndentCommand command : iis) {
                LOGGER.log(Level.FINE, command.toString());
            }
        }
        return iis;
    }

    private boolean isInState(Stack<TplStackItem> stack, StackItemState state) {
        for (TplStackItem item : stack) {
            if (item.state != state) continue;
            return true;
        }
        return false;
    }

    private static class TplStackItem {
        private StackItemState state;
        private Boolean processed = false;
        private String command;
        private int indent;

        private TplStackItem(StackItemState state, String command) {
            assert (state != StackItemState.IN_BODY || state == StackItemState.IN_BODY && !command.isEmpty());
            this.command = command;
            this.state = state;
            this.indent = -1;
        }

        private TplStackItem(StackItemState state) {
            this.state = state;
            this.indent = -1;
        }

        public String getCommand() {
            return this.command;
        }

        public String toString() {
            return "TplStackItem[state=" + this.state + ",indent=" + this.indent + ",processed=" + this.processed + ",command=" + this.command + "]";
        }
    }

    private static enum StackItemState {
        IN_BODY,
        IN_RULE,
        IN_VALUE,
        RULE_FINISHED,
        BODY_FINISHED;

    }
}

