/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.LookupListenerList;
import org.openide.util.lookup.WaitableResult;

final class SimpleProxyLookup
extends Lookup {
    private Lookup.Provider provider;
    private Lookup delegate;
    private WeakHashMap<Lookup.Template<?>, Reference<ProxyResult<?>>> results;

    SimpleProxyLookup(Lookup.Provider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup checkLookup() {
        Lookup l = this.provider.getLookup();
        Iterator<Reference<ProxyResult<?>>> toCheck = null;
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            if (l != this.delegate) {
                this.delegate = l;
                if (this.results != null) {
                    toCheck = new ArrayList(this.results.values()).iterator();
                }
            }
        }
        if (toCheck != null) {
            ArrayList<Object> evAndListeners = new ArrayList<Object>();
            Iterator<Reference<ProxyResult<Object>>> it = toCheck;
            while (it.hasNext()) {
                ProxyResult<?> p;
                Reference<ProxyResult<?>> ref = it.next();
                if (ref == null || (p = ref.get()) == null || !p.updateLookup(null, null)) continue;
                p.collectFires(evAndListeners);
            }
            it = evAndListeners.iterator();
            while (it.hasNext()) {
                LookupEvent ev = (LookupEvent)((Object)it.next());
                LookupListener ll = (LookupListener)((Object)it.next());
                ll.resultChanged(ev);
            }
        }
        return l;
    }

    final synchronized Lookup getLookupDelegate() {
        return this.delegate;
    }

    private static <T> ProxyResult<T> cast(ProxyResult<?> p) {
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        ProxyResult<T> newP;
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            Reference<ProxyResult<?>> ref;
            if (this.results == null) {
                this.results = new WeakHashMap();
            } else {
                ProxyResult<?> p;
                ref = this.results.get(template);
                if (ref != null && (p = ref.get()) != null) {
                    return SimpleProxyLookup.cast(p);
                }
            }
            newP = new ProxyResult<T>(template);
            ref = new WeakReference(newP);
            this.results.put(template, ref);
        }
        newP.checkResult();
        return newP;
    }

    @Override
    public <T> T lookup(Class<T> clazz) {
        if (clazz == null) {
            this.checkLookup();
            return null;
        }
        return this.checkLookup().lookup(clazz);
    }

    @Override
    public <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        return this.checkLookup().lookupItem(template);
    }

    private final class ProxyResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        private final Lookup.Template<T> template;
        private Lookup.Result<T> delegate;
        private LookupListenerList listeners;
        private WeakResult<T> lastListener;

        ProxyResult(Lookup.Template<T> template) {
            this.template = template;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Lookup.Result<T> checkResult() {
            Lookup.Result<T> lkp;
            ProxyResult proxyResult = this;
            synchronized (proxyResult) {
                lkp = this.getDelegate();
            }
            SimpleProxyLookup.this.checkLookup();
            Lookup.Result[] used = new Lookup.Result[]{null};
            this.updateLookup(lkp, used);
            return used[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateLookup(Lookup.Result prev, Lookup.Result[] used) {
            WeakResult<T> listenerToAdd;
            Lookup.Result<T> toAdd;
            Collection oldPairs = null;
            while (true) {
                WeakResult<T> prevListener;
                Lookup.Result<T> del;
                Lookup l;
                ProxyResult proxyResult = this;
                synchronized (proxyResult) {
                    l = SimpleProxyLookup.this.getLookupDelegate();
                    del = this.getDelegate();
                    if (del != null && this.getLastListener() != null) {
                        prevListener = this.getLastListener();
                        del.removeLookupListener(this.getLastListener());
                    } else {
                        prevListener = null;
                    }
                }
                if (oldPairs == null) {
                    if (prev != null) {
                        oldPairs = prev.allItems();
                    } else if (used == null && del != null) {
                        oldPairs = del.allItems();
                    }
                }
                toAdd = l.lookup(this.template);
                proxyResult = this;
                synchronized (proxyResult) {
                    WeakResult<T> ll = this.getLastListener();
                    if (prevListener == ll) {
                        listenerToAdd = ll != null && ll.source == toAdd && ll.result.get() == this ? ll : new WeakResult<T>(this, toAdd);
                        this.setLastListener(listenerToAdd);
                        this.setDelegate(toAdd);
                        if (used != null) {
                            used[0] = toAdd;
                        }
                        break;
                    }
                }
            }
            toAdd.addLookupListener(listenerToAdd);
            if (oldPairs == null) {
                return false;
            }
            Collection<Lookup.Item<T>> newPairs = toAdd.allItems();
            if (!(oldPairs instanceof List)) {
                oldPairs = oldPairs == Collections.EMPTY_SET ? Collections.emptyList() : new ArrayList(oldPairs);
            }
            if (!(newPairs instanceof List)) {
                newPairs = new ArrayList<Lookup.Item<T>>(newPairs);
            }
            return !oldPairs.equals(newPairs);
        }

        @Override
        public void addLookupListener(LookupListener l) {
            this.getListeners(l, null);
        }

        @Override
        public void removeLookupListener(LookupListener l) {
            this.getListeners(null, l);
        }

        @Override
        public Collection<? extends T> allInstances() {
            return this.checkResult().allInstances();
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return this.checkResult().allClasses();
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.checkResult().allItems();
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            Lookup.Result<T> r = this.checkResult();
            if (r instanceof WaitableResult) {
                ((WaitableResult)r).beforeLookup(t);
            }
        }

        @Override
        public void resultChanged(LookupEvent anEvent) {
            this.collectFires(null);
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            LookupListenerList l = this.getListeners(null, null);
            if (l == null) {
                return;
            }
            Object[] listeners = l.getListenerList();
            if (listeners.length == 0) {
                return;
            }
            LookupEvent ev = new LookupEvent(this);
            AbstractLookup.notifyListeners(listeners, ev, evAndListeners);
        }

        @Override
        protected Collection<? extends Object> allInstances(boolean callBeforeLookup) {
            return this.allInstances();
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItems(boolean callBeforeLookup) {
            return this.allItems();
        }

        private synchronized LookupListenerList getListeners(LookupListener toAdd, LookupListener toRemove) {
            if (toAdd == null && this.listeners == null) {
                return null;
            }
            if (this.listeners == null) {
                this.listeners = new LookupListenerList();
            }
            if (toAdd != null) {
                this.listeners.add(toAdd);
            }
            if (toRemove != null) {
                this.listeners.remove(toRemove);
            }
            return this.listeners;
        }

        private Lookup.Result<T> getDelegate() {
            assert (Thread.holdsLock(this));
            return this.delegate;
        }

        private void setDelegate(Lookup.Result<T> delegate) {
            assert (Thread.holdsLock(this));
            this.delegate = delegate;
        }

        private WeakResult<T> getLastListener() {
            assert (Thread.holdsLock(this));
            return this.lastListener;
        }

        private void setLastListener(WeakResult<T> lastListener) {
            assert (Thread.holdsLock(this));
            this.lastListener = lastListener;
        }
    }

    private final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        final Lookup.Result source;
        final Reference<ProxyResult<T>> result;

        WeakResult(ProxyResult<T> r, Lookup.Result<T> s) {
            this.result = new WeakReference<ProxyResult<ProxyResult<T>>>(r);
            this.source = s;
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            ProxyResult<T> r = this.result.get();
            if (r != null) {
                r.beforeLookup(t);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            ProxyResult<T> r = this.result.get();
            if (r != null) {
                r.collectFires(evAndListeners);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public void addLookupListener(LookupListener l) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener l) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            ProxyResult<T> r = this.result.get();
            if (r != null) {
                r.resultChanged(ev);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        protected Collection<? extends Lookup.Item<T>> allItems(boolean callBeforeLookup) {
            return this.allItems();
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }

        @Override
        protected Collection<? extends Object> allInstances(boolean callBeforeLookup) {
            return this.allInstances();
        }

        public String toString() {
            return "SimpleProxy$WeakResult[source=" + this.source + "]";
        }
    }
}

