/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;

public final class VerificationUtils {
    private static final Logger LOGGER = Logger.getLogger(VerificationUtils.class.getName());

    private VerificationUtils() {
    }

    public static boolean isBefore(int caret, int margin) {
        return caret <= margin;
    }

    public static OffsetRange createLineBounds(int caretOffset, BaseDocument doc) {
        assert (doc != null);
        OffsetRange result = OffsetRange.NONE;
        if (caretOffset != -1) {
            try {
                int lineEnd;
                int lineBegin = caretOffset >= 0 ? LineDocumentUtils.getLineStartOffset((LineDocument)doc, (int)caretOffset) : -1;
                int n = lineEnd = lineBegin != -1 ? LineDocumentUtils.getLineEndOffset((LineDocument)doc, (int)caretOffset) : -1;
                if (lineBegin > -1 && lineEnd != -1 && lineBegin <= lineEnd) {
                    result = new OffsetRange(lineBegin, lineEnd);
                }
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
        return result;
    }
}

