/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.layoutsupport.griddesigner.AnimationLayer;
import org.netbeans.modules.form.layoutsupport.griddesigner.DesignerContext;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridCustomizer;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridDesigner;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AbstractGridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.DeleteComponentAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridActionPerformer;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridBoundsChange;

public class GlassPane
extends JPanel
implements GridActionPerformer {
    private static final Color GRID_COLOR = new Color(192, 192, 192, 128);
    private static final Color HIGHLIGHT_COLOR = new Color(64, 255, 64, 64);
    static final int HEADER_GAP = 10;
    private GridDesigner designer;
    private Container innerPane;
    private Container componentPane;
    private GridManager gridManager;
    private GridInfoProvider gridInfo;
    private GridCustomizer customizer;
    private Set<Component> selection = new HashSet<Component>();
    private Component focusedComponent;
    private BitSet selectedColumns = new BitSet();
    private BitSet selectedRows = new BitSet();
    private int focusedCellRow;
    private int focusedCellColumn;
    private int headerHeight;
    private int headerWidth;
    private int emphColumnHeader = -1;
    private int emphRowHeader = -1;
    private boolean moving;
    private boolean resizing;
    private boolean selecting;
    private int resizingMode;
    private Point draggingStart;
    private Rectangle draggingRect;
    private int selMinX;
    private int selMaxX;
    private int selMinY;
    private int selMaxY;
    private int selMinWidth;
    private int selMinHeight;
    private int newGridX;
    private int newGridY;
    private int newGridWidth;
    private int newGridHeight;
    private AnimationLayer animLayer = new AnimationLayer();
    boolean animation;
    float animPhase;
    GridBoundsChange animChange;

    public GlassPane(GridDesigner designer) {
        this.designer = designer;
        this.setLayout(null);
        Listener listener = new Listener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.initHeaderWidth();
    }

    public void setPanes(Container innerPane, Container componentPane) {
        this.innerPane = innerPane;
        this.componentPane = componentPane;
    }

    public boolean isUserActionInProgress() {
        return this.animation;
    }

    public void updateLayout() {
        this.performAction(new AbstractGridAction(){

            @Override
            public GridBoundsChange performAction(GridManager gridManager, DesignerContext context) {
                GridInfoProvider info = gridManager.getGridInfo();
                int oldColumns = info.getColumnCount();
                int oldRows = info.getRowCount();
                GridUtils.removePaddingComponents(gridManager);
                gridManager.updateLayout(false);
                GridUtils.revalidateGrid(gridManager);
                gridManager.updateGaps(false);
                int newColumns = info.getColumnCount();
                int newRows = info.getRowCount();
                int columns = Math.max(oldColumns, newColumns);
                int rows = Math.max(oldRows, newRows);
                GridUtils.addPaddingComponents(gridManager, columns, rows);
                GridUtils.revalidateGrid(gridManager);
                return null;
            }
        });
    }

    private void initHeaderWidth() {
        JLabel label = new JLabel("99");
        label.setBorder(BorderFactory.createRaisedBevelBorder());
        this.headerWidth = label.getPreferredSize().width + 10;
    }

    public void setGridManager(GridManager gridManager) {
        this.gridManager = gridManager;
        this.gridInfo = gridManager.getGridInfo();
        this.customizer = gridManager.getCustomizer(this);
        GridUtils.revalidateGrid(gridManager);
        GridUtils.addPaddingComponents(gridManager, this.gridInfo.getColumnCount(), this.gridInfo.getRowCount());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.animation) {
            Point shift = this.fromComponentPane(new Point());
            g.translate(shift.x, shift.y);
            this.animLayer.paint(g);
            g.translate(-shift.x, -shift.y);
            this.animPhase = this.animLayer.getPhase();
            this.emphColumnHeader = -1;
            this.emphRowHeader = -1;
        }
        this.paintGrid(g);
        if (this.resizing) {
            this.paintResizing(g);
        } else if (this.moving) {
            this.paintResizing(g);
        } else {
            if (this.selecting) {
                g.setColor(GridDesigner.SELECTION_COLOR);
                g.drawRect(this.draggingRect.x, this.draggingRect.y, this.draggingRect.width, this.draggingRect.height);
            }
            if (!this.animation) {
                this.paintConstraints(g);
                this.paintSelection(g);
            }
        }
        if (this.animation && this.animPhase == 1.0f) {
            this.animation = false;
            this.animPhase = 0.0f;
            this.repaint();
        }
    }

    private void paintGrid(Graphics g) {
        int i;
        int bound;
        int i2;
        int[] rowBounds;
        int[] columnBounds;
        boolean animReady;
        if (this.gridInfo == null) {
            return;
        }
        Color oldColor = g.getColor();
        g.setColor(GRID_COLOR);
        boolean bl = animReady = this.animation && this.animChange != null;
        if (animReady) {
            int[] animOldColumnBounds = this.animChange.getOldColumnBounds();
            int[] animNewColumnBounds = this.animChange.getNewColumnBounds();
            columnBounds = new int[animOldColumnBounds.length];
            for (int i3 = 0; i3 < animOldColumnBounds.length; ++i3) {
                columnBounds[i3] = Math.round((float)animOldColumnBounds[i3] * (1.0f - this.animPhase) + this.animPhase * (float)animNewColumnBounds[i3]);
            }
        } else {
            columnBounds = this.gridInfo.getColumnBounds();
        }
        int columns = columnBounds.length - 1;
        if (animReady) {
            int[] animOldRowBounds = this.animChange.getOldRowBounds();
            int[] animNewRowBounds = this.animChange.getNewRowBounds();
            rowBounds = new int[animOldRowBounds.length];
            for (int i4 = 0; i4 < animOldRowBounds.length; ++i4) {
                rowBounds[i4] = Math.round((float)animOldRowBounds[i4] * (1.0f - this.animPhase) + this.animPhase * (float)animNewRowBounds[i4]);
            }
        } else {
            rowBounds = this.gridInfo.getRowBounds();
        }
        int rows = rowBounds.length - 1;
        if (this.moving || this.resizing) {
            int deltaX = this.newGridX - this.gridInfo.getGridX(this.focusedComponent);
            int deltaWidth = this.newGridWidth - this.gridInfo.getGridWidth(this.focusedComponent);
            columns = Math.max(columns, this.selMaxX + deltaX + deltaWidth + 1);
            int deltaY = this.newGridY - this.gridInfo.getGridY(this.focusedComponent);
            int deltaHeight = this.newGridHeight - this.gridInfo.getGridHeight(this.focusedComponent);
            rows = Math.max(rows, this.selMaxY + deltaY + deltaHeight + 1);
        }
        Point shift = new Point();
        shift = this.fromComponentPane(shift);
        int x = columnBounds[0] + shift.x;
        int y = rowBounds[0] + shift.y;
        int width = this.extendedColumnBound(columnBounds, columns) - columnBounds[0];
        int height = this.extendedRowBound(rowBounds, rows) - rowBounds[0];
        for (i2 = 0; i2 <= columns; ++i2) {
            bound = this.extendedColumnBound(columnBounds, i2);
            g.drawLine(bound + shift.x, y, bound + shift.x, y + height);
        }
        for (i2 = 0; i2 <= rows; ++i2) {
            bound = this.extendedRowBound(rowBounds, i2);
            g.drawLine(x, bound + shift.y, x + width, bound + shift.y);
        }
        g.setColor(oldColor);
        Color c = new Color(GRID_COLOR.getRGB());
        JLabel header = new JLabel();
        header.setOpaque(true);
        header.setBackground(c);
        header.setHorizontalAlignment(0);
        for (i = 0; i < columns; ++i) {
            if (this.gridInfo.isGapColumn(i)) continue;
            header.setText(Integer.toString(i));
            if (i == this.emphColumnHeader) {
                header.setBorder(BorderFactory.createEtchedBorder(1));
            } else {
                header.setBorder(this.selectedColumns.get(i) ? BorderFactory.createLoweredBevelBorder() : BorderFactory.createRaisedBevelBorder());
            }
            this.headerHeight = header.getPreferredSize().height;
            int start = this.extendedColumnBound(columnBounds, i);
            int end = this.extendedColumnBound(columnBounds, i + 1);
            int w = end - start;
            Graphics gg = g.create(start + shift.x, rowBounds[0] - 10 - this.headerHeight + shift.y, w, this.headerHeight);
            header.setSize(w, this.headerHeight);
            header.paint(gg);
            gg.dispose();
        }
        for (i = 0; i < rows; ++i) {
            if (this.gridInfo.isGapRow(i)) continue;
            header.setText(Integer.toString(i));
            Border border = i == this.emphRowHeader ? BorderFactory.createEtchedBorder(1) : (this.selectedRows.get(i) ? BorderFactory.createLoweredBevelBorder() : BorderFactory.createRaisedBevelBorder());
            header.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            int start = this.extendedRowBound(rowBounds, i);
            int end = this.extendedRowBound(rowBounds, i + 1);
            int h = end - start;
            Graphics gg = g.create(columnBounds[0] - 10 - this.headerWidth + shift.x, start + shift.y, this.headerWidth, h);
            header.setSize(this.headerWidth, h);
            header.paint(gg);
            gg.dispose();
        }
    }

    void updateActiveHeaders(Point cursorLocation) {
        if (cursorLocation == null) {
            this.emphColumnHeader = -1;
            this.emphRowHeader = -1;
        } else {
            int oldColumnHeader = this.emphColumnHeader;
            int oldRowHeader = this.emphRowHeader;
            this.emphColumnHeader = this.findColumnHeader(cursorLocation);
            this.emphRowHeader = this.findRowHeader(cursorLocation);
            if (oldColumnHeader != this.emphColumnHeader || oldRowHeader != this.emphRowHeader) {
                this.repaint();
            }
        }
    }

    private void paintConstraints(Graphics g) {
        Point shift = this.fromComponentPane(new Point());
        Graphics gClip = g.create();
        Rectangle paneRect = this.fromComponentPane(new Rectangle(new Point(), this.componentPane.getSize()));
        gClip.clipRect(paneRect.x, paneRect.y, paneRect.width, paneRect.height);
        gClip.translate(shift.x, shift.y);
        for (Component comp : this.componentPane.getComponents()) {
            if (GridUtils.isPaddingComponent(comp)) continue;
            boolean selected = this.selection.contains(comp);
            this.gridInfo.paintConstraints(gClip, comp, selected);
        }
        gClip.dispose();
    }

    private void paintSelection(Graphics g) {
        Graphics gClip = g.create();
        Rectangle paneRect = this.fromComponentPane(new Rectangle(new Point(), this.componentPane.getSize()));
        gClip.clipRect(paneRect.x, paneRect.y, paneRect.width, paneRect.height);
        for (Component selComp : this.selection) {
            Rectangle rect = this.fromComponentPane(this.selectionResizingBounds(selComp));
            Rectangle inner = this.fromComponentPane(selComp.getBounds());
            gClip.setColor(HIGHLIGHT_COLOR);
            if (inner.width == 0 || inner.height == 0) {
                gClip.fillRect(rect.x, rect.y, rect.width, rect.height);
            } else {
                gClip.fillRect(rect.x, rect.y, rect.width, inner.y - rect.y);
                gClip.fillRect(rect.x, inner.y, inner.x - rect.x, inner.height);
                gClip.fillRect(inner.x + inner.width, inner.y, rect.width - (inner.x + inner.width - rect.x), inner.height);
                gClip.fillRect(rect.x, inner.y + inner.height, rect.width, rect.height - (inner.y + inner.height - rect.y));
            }
            g.setColor(GridDesigner.SELECTION_COLOR);
            int x = rect.x - 1;
            int y = rect.y - 1;
            int w = rect.width / 2 + 1;
            int h = rect.height / 2 + 1;
            g.drawRect(x, y, rect.width + 1, rect.height + 1);
            Icon resizeHandle = GridDesigner.RESIZE_HANDLE;
            int rw = resizeHandle.getIconWidth();
            int rh = resizeHandle.getIconHeight();
            resizeHandle.paintIcon(null, g, x - rw, y - rh);
            resizeHandle.paintIcon(null, g, (x += w) - rw / 2, y - rh);
            resizeHandle.paintIcon(null, g, x += rect.width + 2 - w, y - rh);
            resizeHandle.paintIcon(null, g, x, (y += h) - rh / 2);
            resizeHandle.paintIcon(null, g, x, y += rect.height + 2 - h);
            resizeHandle.paintIcon(null, g, (x -= rect.width + 2 - w) - rw / 2, y);
            resizeHandle.paintIcon(null, g, (x -= w) - rw, y);
            resizeHandle.paintIcon(null, g, x - rw, (y -= rect.height + 2 - h) - rh / 2);
        }
        gClip.dispose();
    }

    private void paintResizing(Graphics g) {
        int xDelta = this.newGridX - this.gridInfo.getGridX(this.focusedComponent);
        int yDelta = this.newGridY - this.gridInfo.getGridY(this.focusedComponent);
        int heightDelta = this.newGridHeight - this.gridInfo.getGridHeight(this.focusedComponent);
        int widthDelta = this.newGridWidth - this.gridInfo.getGridWidth(this.focusedComponent);
        g.setColor(GridDesigner.SELECTION_COLOR);
        g.drawRect(this.draggingRect.x, this.draggingRect.y, this.draggingRect.width, this.draggingRect.height);
        g.setColor(HIGHLIGHT_COLOR);
        int[] columnBounds = this.gridInfo.getColumnBounds();
        int[] rowBounds = this.gridInfo.getRowBounds();
        Point shift = this.fromComponentPane(new Point());
        for (Component selComp : this.selection) {
            int newCompGridX = this.gridInfo.getGridX(selComp) + xDelta;
            int newCompGridWidth = this.gridInfo.getGridWidth(selComp) + widthDelta;
            int newCompGridY = this.gridInfo.getGridY(selComp) + yDelta;
            int newCompGridHeight = this.gridInfo.getGridHeight(selComp) + heightDelta;
            for (int i = newCompGridX; i < newCompGridX + newCompGridWidth; ++i) {
                for (int j = newCompGridY; j < newCompGridY + newCompGridHeight; ++j) {
                    if (this.gridInfo.isGapColumn(i) || this.gridInfo.isGapRow(j)) continue;
                    int x = this.extendedColumnBound(columnBounds, i);
                    int width = this.extendedColumnBound(columnBounds, i + 1) - x;
                    int y = this.extendedRowBound(rowBounds, j);
                    int height = this.extendedRowBound(rowBounds, j + 1) - y;
                    g.fillRect(x + shift.x, y + shift.y, width, height);
                }
            }
        }
    }

    private Rectangle selectionResizingBounds(Component selComp) {
        int[] columnBounds = this.gridInfo.getColumnBounds();
        int[] rowBounds = this.gridInfo.getRowBounds();
        int gridX = this.gridInfo.getGridX(selComp);
        int gridY = this.gridInfo.getGridY(selComp);
        int gridWidth = this.gridInfo.getGridWidth(selComp);
        int gridHeight = this.gridInfo.getGridHeight(selComp);
        int x = columnBounds[gridX];
        int width = columnBounds[gridX + gridWidth] - x;
        int y = rowBounds[gridY];
        int height = rowBounds[gridY + gridHeight] - y;
        return new Rectangle(x, y, width, height);
    }

    private int extendedColumnBound(int[] bounds, int index) {
        int bound;
        if (index < bounds.length) {
            bound = bounds[index];
        } else if (this.gridInfo.hasGaps()) {
            int gapWidth = FormLoaderSettings.getInstance().getGapWidth();
            bound = bounds[bounds.length - 1];
            for (int i = bounds.length; i <= index; ++i) {
                if (this.gridInfo.isGapColumn(i + 1)) {
                    bound += gapWidth;
                    continue;
                }
                bound += 20;
            }
        } else {
            bound = bounds[bounds.length - 1] + (index - bounds.length + 1) * 20;
        }
        return bound;
    }

    private int extendedRowBound(int[] bounds, int index) {
        int bound;
        if (index < bounds.length) {
            bound = bounds[index];
        } else if (this.gridInfo.hasGaps()) {
            int gapWidth = FormLoaderSettings.getInstance().getGapHeight();
            bound = bounds[bounds.length - 1];
            for (int i = bounds.length; i <= index; ++i) {
                if (this.gridInfo.isGapRow(i + 1)) {
                    bound += gapWidth;
                    continue;
                }
                bound += 20;
            }
        } else {
            bound = bounds[bounds.length - 1] + (index - bounds.length + 1) * 20;
        }
        return bound;
    }

    private boolean isResizingEastward() {
        return this.resizingMode == 3 || this.resizingMode == 4 || this.resizingMode == 2;
    }

    private boolean isResizingWestward() {
        return this.resizingMode == 7 || this.resizingMode == 6 || this.resizingMode == 8;
    }

    private boolean isResizingSouthward() {
        return this.resizingMode == 5 || this.resizingMode == 4 || this.resizingMode == 6;
    }

    private boolean isResizingNorthward() {
        return this.resizingMode == 1 || this.resizingMode == 2 || this.resizingMode == 8;
    }

    Rectangle calculateResizingRectangle(Point resizingEnd, Component selComp) {
        Rectangle rect = this.fromComponentPane(this.selectionResizingBounds(selComp));
        int dx = resizingEnd.x - this.draggingStart.x;
        int dy = resizingEnd.y - this.draggingStart.y;
        if (this.isResizingEastward()) {
            rect.width += dx;
            if (rect.width < 0) {
                rect.width = 0;
            }
        }
        if (this.isResizingSouthward()) {
            rect.height += dy;
            if (rect.height < 0) {
                rect.height = 0;
            }
        }
        if (this.isResizingWestward()) {
            rect.width -= dx;
            rect.x += dx;
            if (rect.width < 0) {
                rect.x += rect.width;
                rect.width = 0;
            }
        }
        if (this.isResizingNorthward()) {
            rect.height -= dy;
            rect.y += dy;
            if (rect.height < 0) {
                rect.y += rect.height;
                rect.height = 0;
            }
        }
        return rect;
    }

    void calculateResizingGridLocation() {
        int currentY;
        int currentX;
        Rectangle rect = this.toComponentPane(this.draggingRect);
        int x = this.gridInfo.getGridX(this.focusedComponent);
        int y = this.gridInfo.getGridY(this.focusedComponent);
        int width = this.gridInfo.getGridWidth(this.focusedComponent);
        int height = this.gridInfo.getGridHeight(this.focusedComponent);
        if (this.isResizingEastward() && !this.gridInfo.isGapColumn(currentX = this.gridXLocation(rect.x + rect.width, false))) {
            this.newGridWidth = Math.max(width - this.selMinWidth + 1, currentX - x + 1);
        }
        if (this.isResizingWestward() && !this.gridInfo.isGapColumn(currentX = this.gridXLocation(rect.x, false))) {
            this.newGridX = Math.max(x - this.selMinX, Math.min(x + width - (width - this.selMinWidth + 1), currentX));
            this.newGridWidth = x + width - this.newGridX;
        }
        if (this.isResizingSouthward() && !this.gridInfo.isGapRow(currentY = this.gridYLocation(rect.y + rect.height, false))) {
            this.newGridHeight = Math.max(height - this.selMinHeight + 1, currentY - y + 1);
        }
        if (this.isResizingNorthward() && !this.gridInfo.isGapRow(currentY = this.gridYLocation(rect.y, false))) {
            this.newGridY = Math.max(y - this.selMinY, Math.min(y + height - (height - this.selMinHeight + 1), currentY));
            this.newGridHeight = y + height - this.newGridY;
        }
    }

    Rectangle calculateMovingRectangle(Point movingEnd) {
        Rectangle rect = this.focusedComponent.getBounds();
        rect.x += movingEnd.x - this.draggingStart.x;
        rect.y += movingEnd.y - this.draggingStart.y;
        return this.fromComponentPane(rect);
    }

    void calculateMovingGridLocation(Point cursorLocation) {
        Point start = this.toComponentPane(this.draggingStart);
        Point end = this.toComponentPane(cursorLocation);
        int startX = this.gridXLocation(start.x, true);
        int startY = this.gridYLocation(start.y, true);
        int endX = this.gridXLocation(end.x, false);
        int endY = this.gridYLocation(end.y, false);
        int deltaX = endX - startX;
        int deltaY = endY - startY;
        deltaX = Math.max(deltaX, -this.selMinX);
        deltaY = Math.max(deltaY, -this.selMinY);
        int tempGridX = this.gridInfo.getGridX(this.focusedComponent) + deltaX;
        int tempGridY = this.gridInfo.getGridY(this.focusedComponent) + deltaY;
        if (!this.gridInfo.isGapColumn(tempGridX) && !this.gridInfo.isGapRow(tempGridY)) {
            this.newGridX = tempGridX;
            this.newGridY = tempGridY;
        }
    }

    void updateCursor(Point cursorLocation) {
        Cursor cursor = Cursor.getDefaultCursor();
        if (cursorLocation == null) {
            this.resizingMode = 0;
        } else {
            int x = cursorLocation.x;
            int y = cursorLocation.y;
            Icon resizeHandle = GridDesigner.RESIZE_HANDLE;
            int rw = resizeHandle.getIconWidth();
            int rh = resizeHandle.getIconHeight();
            for (Component selComp : this.selection) {
                boolean right;
                Rectangle rect = this.fromComponentPane(this.selectionResizingBounds(selComp));
                boolean w = rect.x - rw <= x && x <= rect.x + rect.width + rw;
                boolean h = rect.y - rh <= y && y <= rect.y + rect.height + rh;
                boolean top = w && rect.y - rh <= y && y <= rect.y + 2;
                boolean bottom = w && rect.y + rect.height - 2 <= y && y <= rect.y + rect.height + rh;
                boolean left = h && rect.x - rw <= x && x <= rect.x + 2;
                boolean bl = right = h && rect.x + rect.width - 2 <= x && x <= rect.x + rect.width + rw;
                if (top) {
                    if (left) {
                        cursor = Cursor.getPredefinedCursor(6);
                        this.resizingMode = 8;
                    } else if (right) {
                        cursor = Cursor.getPredefinedCursor(7);
                        this.resizingMode = 2;
                    } else {
                        cursor = Cursor.getPredefinedCursor(8);
                        this.resizingMode = 1;
                    }
                } else if (bottom) {
                    if (left) {
                        cursor = Cursor.getPredefinedCursor(4);
                        this.resizingMode = 6;
                    } else if (right) {
                        cursor = Cursor.getPredefinedCursor(5);
                        this.resizingMode = 4;
                    } else {
                        cursor = Cursor.getPredefinedCursor(9);
                        this.resizingMode = 5;
                    }
                } else if (left) {
                    cursor = Cursor.getPredefinedCursor(10);
                    this.resizingMode = 7;
                } else if (right) {
                    cursor = Cursor.getPredefinedCursor(11);
                    this.resizingMode = 3;
                } else {
                    cursor = Cursor.getDefaultCursor();
                    this.resizingMode = 0;
                }
                if (this.resizingMode == 0) continue;
                this.focusedComponent = selComp;
                break;
            }
        }
        this.setCursor(cursor);
    }

    Point toComponentPane(Point point) {
        return SwingUtilities.convertPoint(this.innerPane, point, this.componentPane);
    }

    Rectangle toComponentPane(Rectangle rectangle) {
        return SwingUtilities.convertRectangle(this.innerPane, rectangle, this.componentPane);
    }

    Point fromComponentPane(Point point) {
        return SwingUtilities.convertPoint(this.componentPane, point, this.innerPane);
    }

    Rectangle fromComponentPane(Rectangle rectangle) {
        return SwingUtilities.convertRectangle(this.componentPane, rectangle, this.innerPane);
    }

    private int gridXLocation(int xComponentPaneCoordinate, boolean mustBeInside) {
        int[] bounds = this.gridInfo.getColumnBounds();
        int gridX = -1;
        while (gridX + 1 < bounds.length && bounds[gridX + 1] <= xComponentPaneCoordinate) {
            ++gridX;
        }
        if (mustBeInside) {
            gridX = Math.max(0, Math.min(gridX, bounds.length - 2));
        } else if (gridX == bounds.length - 1) {
            if (this.gridInfo.hasGaps()) {
                int gapWidth = FormLoaderSettings.getInstance().getGapWidth();
                int coordinateX = bounds[bounds.length - 1] + 1;
                while (coordinateX <= xComponentPaneCoordinate) {
                    coordinateX = this.gridInfo.isGapColumn(gridX + 1) ? (coordinateX += gapWidth) : (coordinateX += 20);
                    ++gridX;
                }
            } else {
                gridX = (xComponentPaneCoordinate - bounds[bounds.length - 1] + 1) / 20 + bounds.length - 1;
            }
        }
        return gridX;
    }

    private int gridYLocation(int yComponentPaneCoordinate, boolean mustBeInside) {
        int[] bounds = this.gridInfo.getRowBounds();
        int gridY = -1;
        while (gridY + 1 < bounds.length && bounds[gridY + 1] <= yComponentPaneCoordinate) {
            ++gridY;
        }
        if (mustBeInside) {
            gridY = Math.max(0, Math.min(gridY, bounds.length - 2));
        } else if (gridY == bounds.length - 1) {
            if (this.gridInfo.hasGaps()) {
                int gapHeight = FormLoaderSettings.getInstance().getGapHeight();
                int coordinateY = bounds[bounds.length - 1] + 1;
                while (coordinateY <= yComponentPaneCoordinate) {
                    coordinateY = this.gridInfo.isGapRow(gridY + 1) ? (coordinateY += gapHeight) : (coordinateY += 20);
                    ++gridY;
                }
            } else {
                gridY = (yComponentPaneCoordinate - bounds[bounds.length - 1] + 1) / 20 + bounds.length - 1;
            }
        }
        return gridY;
    }

    Component findComponent(Point innerPanePoint) {
        Rectangle paneRect = this.fromComponentPane(new Rectangle(new Point(), this.componentPane.getSize()));
        if (paneRect.contains(innerPanePoint)) {
            Rectangle rect;
            for (Component comp : this.componentPane.getComponents()) {
                if (GridUtils.isPaddingComponent(comp) || !(rect = this.fromComponentPane(comp.getBounds())).contains(innerPanePoint)) continue;
                return comp;
            }
            for (Component comp : this.componentPane.getComponents()) {
                if (GridUtils.isPaddingComponent(comp) || !(rect = this.fromComponentPane(this.selectionResizingBounds(comp))).contains(innerPanePoint)) continue;
                return comp;
            }
        }
        return null;
    }

    int findColumnHeader(Point innerPanePoint) {
        Point shift = this.fromComponentPane(new Point());
        int y = this.gridInfo.getY() + shift.y - 10;
        if (y - this.headerHeight <= innerPanePoint.y && innerPanePoint.y <= y) {
            int[] bounds = this.gridInfo.getColumnBounds();
            for (int i = 0; i < bounds.length - 1; ++i) {
                int x = innerPanePoint.x - shift.x;
                if (bounds[i] > x || x >= bounds[i + 1]) continue;
                if (this.gridInfo.isGapColumn(i)) {
                    return -1;
                }
                return i;
            }
        }
        return -1;
    }

    int findRowHeader(Point innerPanePoint) {
        Point shift = this.fromComponentPane(new Point());
        int x = this.gridInfo.getX() + shift.x - 10;
        if (x - this.headerWidth <= innerPanePoint.x && innerPanePoint.x <= x) {
            int[] bounds = this.gridInfo.getRowBounds();
            for (int i = 0; i < bounds.length - 1; ++i) {
                int y = innerPanePoint.y - shift.y;
                if (bounds[i] > y || y >= bounds[i + 1]) continue;
                if (this.gridInfo.isGapRow(i)) {
                    return -1;
                }
                return i;
            }
        }
        return -1;
    }

    DesignerContext currentContext() {
        DesignerContext context = new DesignerContext();
        context.setSelectedColumns((BitSet)this.selectedColumns.clone());
        context.setSelectedRows((BitSet)this.selectedRows.clone());
        context.setSelectedComponents(new HashSet<Component>(this.selection));
        context.setGridInfo(this.gridInfo);
        context.setFocusedRow(this.focusedCellRow);
        context.setFocusedColumn(this.focusedCellColumn);
        return context;
    }

    void updateCurrentContext(DesignerContext context) {
        this.setSelection(context.getSelectedComponents());
    }

    void changeLocation() {
        boolean widthChanged;
        int oldX = this.gridInfo.getGridX(this.focusedComponent);
        int oldY = this.gridInfo.getGridY(this.focusedComponent);
        int oldWidth = this.gridInfo.getGridWidth(this.focusedComponent);
        int oldHeight = this.gridInfo.getGridHeight(this.focusedComponent);
        boolean xChanged = oldX != this.newGridX;
        boolean yChanged = oldY != this.newGridY;
        boolean heightChanged = oldHeight != this.newGridHeight;
        boolean bl = widthChanged = oldWidth != this.newGridWidth;
        if (xChanged || yChanged || widthChanged || heightChanged) {
            this.performAction(new ChangeLocationAction());
        }
    }

    @Override
    public void performAction(GridAction action) {
        GridActionWrapper wrapper = new GridActionWrapper(action);
        wrapper.setDesignerContext(this.currentContext());
        wrapper.actionPerformed(null);
    }

    void setSelection(Component selComp) {
        this.setSelection(selComp == null ? Collections.EMPTY_SET : Collections.singleton(selComp));
    }

    void setSelection(Set<Component> selection) {
        assert (!selection.contains(null));
        if (selection == this.selection) {
            return;
        }
        if (selection.isEmpty()) {
            this.updateCursor(null);
        }
        this.selection = selection;
        this.designer.setSelection(selection);
        this.requestFocusInWindow();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 127) {
            if (!this.selection.isEmpty()) {
                this.performAction(new DeleteComponentAction());
            }
        } else if (keyCode == 27 && (this.moving || this.resizing)) {
            this.moving = false;
            this.resizing = false;
            this.repaint();
        } else {
            super.processKeyEvent(e);
        }
    }

    void initSelFields() {
        this.selMinX = Integer.MAX_VALUE;
        this.selMaxX = 0;
        this.selMinY = Integer.MAX_VALUE;
        this.selMaxY = 0;
        this.selMinWidth = Integer.MAX_VALUE;
        this.selMinHeight = Integer.MAX_VALUE;
        for (Component selComp : this.selection) {
            int gridX = this.gridInfo.getGridX(selComp);
            int gridY = this.gridInfo.getGridY(selComp);
            int gridWidth = this.gridInfo.getGridWidth(selComp);
            int gridHeight = this.gridInfo.getGridHeight(selComp);
            this.selMinX = Math.min(this.selMinX, gridX);
            this.selMaxX = Math.max(this.selMaxX, gridX + gridWidth - 1);
            this.selMinY = Math.min(this.selMinY, gridY);
            this.selMaxY = Math.max(this.selMaxY, gridY + gridHeight - 1);
            this.selMinWidth = Math.min(this.selMinWidth, gridWidth);
            this.selMinHeight = Math.min(this.selMinHeight, gridHeight);
        }
    }

    private static boolean ctrlOrCmdModifier(MouseEvent e) {
        if (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4) {
            return (e.getModifiersEx() & 0x100) == 256;
        }
        return (e.getModifiers() & 2) == 2;
    }

    private void showPopupMenu(Point point) {
        List<GridAction> actions = null;
        DesignerContext context = this.currentContext();
        if (!this.selection.isEmpty()) {
            context.setFocusedComponent(this.focusedComponent);
            actions = this.gridManager.designerActions(GridAction.Context.COMPONENT);
        }
        int column = this.findColumnHeader(point);
        context.setFocusedColumn(column);
        if (column != -1) {
            actions = this.gridManager.designerActions(GridAction.Context.COLUMN);
        }
        int row = this.findRowHeader(point);
        context.setFocusedRow(row);
        if (row != -1) {
            actions = this.gridManager.designerActions(GridAction.Context.ROW);
        }
        if (column == -1 && row == -1) {
            int height;
            int width;
            int y;
            Point shift = this.fromComponentPane(new Point());
            int x = this.gridInfo.getX();
            Rectangle rect = new Rectangle(x + shift.x, (y = this.gridInfo.getY()) + shift.y, width = this.gridInfo.getWidth(), height = this.gridInfo.getHeight());
            if (rect.contains(point)) {
                this.focusedCellColumn = this.gridXLocation(point.x - shift.x, true);
                this.focusedCellRow = this.gridYLocation(point.y - shift.y, true);
                if (!this.gridInfo.isGapColumn(this.focusedCellColumn) && !this.gridInfo.isGapRow(this.focusedCellRow)) {
                    context.setFocusedColumn(this.focusedCellColumn);
                    context.setFocusedRow(this.focusedCellRow);
                    List<GridAction> moreActions = this.gridManager.designerActions(GridAction.Context.CELL);
                    if (moreActions != null && !moreActions.isEmpty()) {
                        if (actions == null) {
                            actions = moreActions;
                        } else {
                            ArrayList<GridAction> l = new ArrayList<GridAction>(actions.size() + moreActions.size());
                            l.addAll(actions);
                            l.addAll(moreActions);
                            actions = l;
                        }
                    }
                } else {
                    this.focusedCellColumn = -1;
                    this.focusedCellRow = -1;
                }
            }
        } else {
            this.focusedCellColumn = -1;
            this.focusedCellRow = -1;
        }
        if (actions != null) {
            JPopupMenu menu = new JPopupMenu();
            for (GridAction action : actions) {
                JMenuItem menuItem = action.getPopupPresenter(this);
                if (menuItem == null) {
                    GridActionWrapper wrapper = new GridActionWrapper(action);
                    wrapper.setDesignerContext(context);
                    menu.add(wrapper);
                    continue;
                }
                menu.add(menuItem);
            }
            this.designer.updateContextMenu(context, menu);
            this.draggingStart = null;
            menu.show(this, point.x, point.y);
        }
    }

    class Listener
    extends MouseAdapter {
        Listener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            boolean rightMousePressed;
            Point point;
            GlassPane.this.draggingStart = point = e.getPoint();
            boolean leftMousePressed = e.getButton() == 1;
            boolean bl = rightMousePressed = e.getButton() == 3;
            if (leftMousePressed) {
                if (GlassPane.this.resizingMode == 0) {
                    GlassPane.this.focusedComponent = GlassPane.this.findComponent(point);
                    if (e.isPopupTrigger()) {
                        if (!GlassPane.this.selection.contains(GlassPane.this.focusedComponent)) {
                            GlassPane.this.setSelection(GlassPane.this.focusedComponent);
                        }
                        GlassPane.this.showPopupMenu(point);
                    } else if (!e.isShiftDown()) {
                        if (GlassPane.this.focusedComponent != null && GlassPane.ctrlOrCmdModifier(e)) {
                            HashSet<Component> newSelection = new HashSet<Component>();
                            newSelection.addAll(GlassPane.this.selection);
                            if (GlassPane.this.selection.contains(GlassPane.this.focusedComponent)) {
                                newSelection.remove(GlassPane.this.focusedComponent);
                            } else {
                                newSelection.add(GlassPane.this.focusedComponent);
                            }
                            GlassPane.this.setSelection(newSelection);
                        } else if (!GlassPane.this.selection.contains(GlassPane.this.focusedComponent)) {
                            GlassPane.this.setSelection(GlassPane.this.focusedComponent);
                        }
                    }
                } else {
                    GlassPane.this.resizing = true;
                    GlassPane.this.requestFocusInWindow();
                    GlassPane.this.draggingRect = GlassPane.this.fromComponentPane(GlassPane.this.selectionResizingBounds(GlassPane.this.focusedComponent));
                    GlassPane.this.newGridX = GlassPane.this.gridInfo.getGridX(GlassPane.this.focusedComponent);
                    GlassPane.this.newGridY = GlassPane.this.gridInfo.getGridY(GlassPane.this.focusedComponent);
                    GlassPane.this.newGridHeight = GlassPane.this.gridInfo.getGridHeight(GlassPane.this.focusedComponent);
                    GlassPane.this.newGridWidth = GlassPane.this.gridInfo.getGridWidth(GlassPane.this.focusedComponent);
                    GlassPane.this.initSelFields();
                }
            } else if (rightMousePressed) {
                if (GlassPane.this.moving || GlassPane.this.resizing) {
                    GlassPane.this.moving = false;
                    GlassPane.this.resizing = false;
                    GlassPane.this.draggingStart = null;
                } else {
                    GlassPane.this.focusedComponent = GlassPane.this.findComponent(point);
                    if (!GlassPane.this.selection.contains(GlassPane.this.focusedComponent)) {
                        GlassPane.this.setSelection(GlassPane.this.focusedComponent);
                    }
                    if (e.isPopupTrigger()) {
                        GlassPane.this.showPopupMenu(point);
                    }
                }
            }
            GlassPane.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Point point = e.getPoint();
            if (GlassPane.this.moving) {
                GlassPane.this.moving = false;
                GlassPane.this.changeLocation();
            } else if (GlassPane.this.resizing) {
                GlassPane.this.resizing = false;
                GlassPane.this.changeLocation();
            } else if (GlassPane.this.selecting) {
                GlassPane.this.selecting = false;
                HashSet<Component> newSelection = new HashSet<Component>();
                Rectangle paneRect = GlassPane.this.fromComponentPane(new Rectangle(new Point(), GlassPane.this.componentPane.getSize()));
                for (Component comp : GlassPane.this.componentPane.getComponents()) {
                    if (GridUtils.isPaddingComponent(comp)) continue;
                    Rectangle rect = GlassPane.this.fromComponentPane(comp.getBounds());
                    if (!GlassPane.this.draggingRect.intersects(rect = rect.intersection(paneRect))) continue;
                    if (newSelection.contains(comp)) {
                        newSelection.remove(comp);
                        continue;
                    }
                    newSelection.add(comp);
                }
                GlassPane.this.setSelection(newSelection);
            } else {
                boolean leftMouseReleased = e.getButton() == 1;
                GlassPane.this.focusedComponent = GlassPane.this.findComponent(point);
                if (e.isPopupTrigger()) {
                    if (GlassPane.this.draggingStart != null) {
                        if (!GlassPane.this.selection.contains(GlassPane.this.focusedComponent)) {
                            GlassPane.this.setSelection(GlassPane.this.focusedComponent);
                        }
                        GlassPane.this.showPopupMenu(point);
                    }
                } else if (leftMouseReleased && e.isShiftDown()) {
                    if (GlassPane.this.focusedComponent != null && !GlassPane.this.selection.contains(GlassPane.this.focusedComponent)) {
                        HashSet<Component> newSelection = new HashSet<Component>();
                        newSelection.addAll(GlassPane.this.selection);
                        newSelection.add(GlassPane.this.focusedComponent);
                        GlassPane.this.setSelection(newSelection);
                    }
                } else if (!GlassPane.ctrlOrCmdModifier(e) && GlassPane.this.draggingStart != null) {
                    GlassPane.this.setSelection(GlassPane.this.focusedComponent);
                }
            }
            GlassPane.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!GlassPane.this.selection.isEmpty()) {
                GlassPane.this.updateCursor(e.getPoint());
            }
            GlassPane.this.updateActiveHeaders(e.getPoint());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (GlassPane.this.draggingStart == null) {
                GlassPane.this.draggingStart = e.getPoint();
            }
            if (GlassPane.this.resizing) {
                GlassPane.this.draggingRect = GlassPane.this.calculateResizingRectangle(e.getPoint(), GlassPane.this.focusedComponent);
                GlassPane.this.calculateResizingGridLocation();
            } else if (GlassPane.this.focusedComponent == null || e.isShiftDown()) {
                GlassPane.this.selecting = true;
                GlassPane.this.draggingRect = new Rectangle(GlassPane.this.draggingStart);
                GlassPane.this.draggingRect.add(e.getPoint());
            } else if (!GlassPane.this.selection.isEmpty() && SwingUtilities.isLeftMouseButton(e)) {
                if (!GlassPane.this.moving) {
                    GlassPane.this.newGridHeight = GlassPane.this.gridInfo.getGridHeight(GlassPane.this.focusedComponent);
                    GlassPane.this.newGridWidth = GlassPane.this.gridInfo.getGridWidth(GlassPane.this.focusedComponent);
                    GlassPane.this.initSelFields();
                    GlassPane.this.requestFocusInWindow();
                }
                GlassPane.this.moving = true;
                GlassPane.this.draggingRect = GlassPane.this.calculateMovingRectangle(e.getPoint());
                GlassPane.this.calculateMovingGridLocation(e.getPoint());
            }
            GlassPane.this.repaint();
        }
    }

    class ChangeLocationAction
    extends AbstractGridAction {
        ChangeLocationAction() {
        }

        @Override
        public GridBoundsChange performAction(GridManager gridManager, DesignerContext context) {
            int i;
            GridInfoProvider info = gridManager.getGridInfo();
            int[] originalColumnBounds = info.getColumnBounds();
            int[] originalRowBounds = info.getRowBounds();
            GridUtils.revalidateGrid(gridManager);
            int columns = info.getColumnCount();
            int rows = info.getRowCount();
            int xDelta = GlassPane.this.newGridX - info.getGridX(GlassPane.this.focusedComponent);
            int yDelta = GlassPane.this.newGridY - info.getGridY(GlassPane.this.focusedComponent);
            int heightDelta = GlassPane.this.newGridHeight - info.getGridHeight(GlassPane.this.focusedComponent);
            int widthDelta = GlassPane.this.newGridWidth - info.getGridWidth(GlassPane.this.focusedComponent);
            GridUtils.removePaddingComponents(gridManager);
            if (xDelta != 0 || yDelta != 0 || widthDelta != 0 || heightDelta != 0) {
                for (Component selComp : GlassPane.this.selection) {
                    int gridX = info.getGridX(selComp);
                    int gridY = info.getGridY(selComp);
                    int width = info.getGridWidth(selComp);
                    int height = info.getGridHeight(selComp);
                    gridManager.setGridPosition(selComp, gridX + xDelta, gridY + yDelta, width + widthDelta, height + heightDelta);
                    columns = Math.max(columns, gridX + xDelta + width + widthDelta);
                    rows = Math.max(rows, gridY + yDelta + height + heightDelta);
                }
            }
            gridManager.updateLayout(false);
            GridUtils.revalidateGrid(gridManager);
            gridManager.updateGaps(false);
            GridUtils.addPaddingComponents(gridManager, columns, rows);
            GridUtils.revalidateGrid(gridManager);
            int[] newColumnBounds = GlassPane.this.gridInfo.getColumnBounds();
            int[] newRowBounds = GlassPane.this.gridInfo.getRowBounds();
            if (newColumnBounds.length > originalColumnBounds.length) {
                int[] oldBounds = new int[newColumnBounds.length];
                for (i = 0; i < oldBounds.length; ++i) {
                    oldBounds[i] = GlassPane.this.extendedColumnBound(originalColumnBounds, i);
                }
                originalColumnBounds = oldBounds;
            }
            if (newRowBounds.length > originalRowBounds.length) {
                int[] oldBounds = new int[newRowBounds.length];
                for (i = 0; i < oldBounds.length; ++i) {
                    oldBounds[i] = GlassPane.this.extendedRowBound(originalRowBounds, i);
                }
                originalRowBounds = oldBounds;
            }
            return new GridBoundsChange(originalColumnBounds, originalRowBounds, newColumnBounds, newRowBounds);
        }
    }

    class GridActionWrapper
    extends AbstractAction {
        private GridAction delegate;
        private DesignerContext currentContext;

        GridActionWrapper(GridAction action) {
            this.delegate = action;
        }

        public void setDesignerContext(DesignerContext currentContext) {
            this.currentContext = currentContext;
            this.setEnabled(this.delegate.isEnabled(currentContext));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] animNewRowBounds;
            int[] animNewColumnBounds;
            GlassPane.this.animation = true;
            int[] animOldColumnBounds = GlassPane.this.gridInfo.getColumnBounds();
            int[] animOldRowBounds = GlassPane.this.gridInfo.getRowBounds();
            GlassPane.this.animLayer.setContainer(GlassPane.this.componentPane);
            GlassPane.this.animLayer.setGlassPane(GlassPane.this);
            GlassPane.this.animLayer.setVIPComponents(new ArrayList<Component>(GlassPane.this.selection));
            GlassPane.this.animLayer.loadStart();
            GridBoundsChange change = this.delegate.performAction(GlassPane.this.gridManager, this.currentContext);
            GlassPane.this.updateCurrentContext(this.currentContext);
            GlassPane.this.animLayer.loadEnd();
            if (change == null) {
                animNewColumnBounds = GlassPane.this.gridInfo.getColumnBounds();
                animNewRowBounds = GlassPane.this.gridInfo.getRowBounds();
                if (GlassPane.this.gridInfo.hasGaps()) {
                    if (animNewColumnBounds.length > GlassPane.this.gridInfo.getLastGapColumn() + 3) {
                        animNewColumnBounds = this.resizeArray(animNewColumnBounds, GlassPane.this.gridInfo.getLastGapColumn() + 3);
                    }
                    if (animNewRowBounds.length > GlassPane.this.gridInfo.getLastGapRow() + 3) {
                        animNewRowBounds = this.resizeArray(animNewRowBounds, GlassPane.this.gridInfo.getLastGapRow() + 3);
                    }
                }
            } else {
                animOldColumnBounds = change.getOldColumnBounds();
                animOldRowBounds = change.getOldRowBounds();
                animNewColumnBounds = change.getNewColumnBounds();
                animNewRowBounds = change.getNewRowBounds();
            }
            if (animNewColumnBounds.length != animOldColumnBounds.length) {
                if (animNewColumnBounds.length > animOldColumnBounds.length) {
                    animOldColumnBounds = this.resizeArray(animOldColumnBounds, animNewColumnBounds.length);
                } else {
                    animNewColumnBounds = this.resizeArray(animNewColumnBounds, animOldColumnBounds.length);
                }
            }
            if (animNewRowBounds.length != animOldRowBounds.length) {
                if (animNewRowBounds.length > animOldRowBounds.length) {
                    animOldRowBounds = this.resizeArray(animOldRowBounds, animNewRowBounds.length);
                } else {
                    animNewRowBounds = this.resizeArray(animNewRowBounds, animOldRowBounds.length);
                }
            }
            change = new GridBoundsChange(animOldColumnBounds, animOldRowBounds, animNewColumnBounds, animNewRowBounds);
            if (GlassPane.this.customizer != null) {
                DesignerContext context = GlassPane.this.currentContext();
                GlassPane.this.customizer.setContext(context);
            }
            if (!this.noChange(change)) {
                GlassPane.this.animChange = change;
                GlassPane.this.animLayer.animate();
            }
        }

        public boolean noChange(GridBoundsChange change) {
            return Arrays.equals(change.getNewColumnBounds(), change.getOldColumnBounds()) && Arrays.equals(change.getNewRowBounds(), change.getOldRowBounds());
        }

        private int[] resizeArray(int[] original, int newLength) {
            int[] result = original;
            if (newLength > original.length) {
                result = new int[newLength];
                System.arraycopy(original, 0, result, 0, original.length);
                int last = original[original.length - 1];
                for (int i = original.length; i < newLength; ++i) {
                    result[i] = last;
                }
            }
            if (newLength < original.length) {
                assert (newLength > 0);
                result = new int[newLength];
                System.arraycopy(original, 0, result, 0, newLength);
            }
            return result;
        }

        @Override
        public Object getValue(String key) {
            Object value = this.delegate.getValue(key);
            if (value == null) {
                value = super.getValue(key);
            }
            return value;
        }
    }
}

