/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRepository;
import org.netbeans.libs.git.GitURI;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.ui.history.Bundle;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class DefaultGitHyperlinkProvider
extends VCSHyperlinkProvider {
    private static final Pattern ids = Pattern.compile("#[0-9]+");

    public int[] getSpans(String text) {
        return ids.matcher(text).results().flatMapToInt(r -> IntStream.of(r.start(), r.end())).toArray();
    }

    public String getTooltip(String text, int offsetStart, int offsetEnd) {
        return Bundle.TT_DefaultGitHyperlinkProvider_link(text.substring(offsetStart, offsetEnd));
    }

    public void onClick(File file, String text, int offsetStart, int offsetEnd) {
        Path path = file.toPath();
        while (!Files.isDirectory(path, new LinkOption[0]) || Files.notExists(path.resolve(".git"), new LinkOption[0])) {
            if ((path = path.getParent()) != null) continue;
            return;
        }
        Path repo = path;
        RequestProcessor.getDefault().post(() -> DefaultGitHyperlinkProvider.openIssue(repo, text.substring(offsetStart + 1, offsetEnd)));
    }

    private static void openIssue(Path repo, String id) {
        block20: {
            try (GitClient client = GitRepository.getInstance((File)repo.toFile()).createClient();){
                Map remotes = client.getRemotes((ProgressMonitor)new ProgressMonitor.DefaultProgressMonitor());
                GitRemoteConfig origin = remotes.getOrDefault("origin4nb", remotes.getOrDefault("upstream", remotes.getOrDefault("origin", remotes.getOrDefault("origin/HEAD", null))));
                if (origin == null) {
                    origin = remotes.values().stream().filter(r -> r.getRemoteName().startsWith("origin/")).findFirst().orElse(null);
                }
                if (origin == null) break block20;
                for (String str : origin.getUris()) {
                    String page;
                    GitURI uri = new GitURI(str);
                    String host = uri.getHost();
                    if (host == null) continue;
                    switch (host) {
                        case "github.com": {
                            String string = "/pull/" + id;
                            break;
                        }
                        case "codeberg.org": {
                            String string = "/pulls/" + id;
                            break;
                        }
                        default: {
                            String string = page = host.contains("gitlab") ? "/-/issues/" + id : null;
                        }
                    }
                    if (page == null) continue;
                    Object path = uri.getPath().substring(0, uri.getPath().length() - 4);
                    if (!((String)path).startsWith("/")) {
                        path = "/" + (String)path;
                    }
                    URI link = URI.create("https://" + host + (String)path + page);
                    Desktop.getDesktop().browse(link);
                    return;
                }
            }
            catch (IOException | URISyntaxException | GitException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        StatusDisplayer.getDefault().setStatusText(Bundle.MSG_DefaultGitHyperlinkProvider_link_failed());
    }
}

