# Contributing

Thank you for your interest in contributing to ntfy! There are many ways to help, whether you're a developer,
translator, or just an enthusiastic user.

## Code contributions

If you'd like to contribute code to ntfy:

1. Check out the [development guide](develop.md) to set up your environment
2. Look at [open issues](https://github.com/binwiederhier/ntfy/issues) for ideas, or propose your own
3. For larger features or architectural changes, please reach out on [Discord/Matrix](contact.md) first to discuss 
   before investing significant time
4. Submit a pull request on GitHub

All contributions are welcome, from small bug fixes to major features.

## Translations

Help make ntfy accessible to users around the world! We use Hosted Weblate for translations:

- **Weblate**: [hosted.weblate.org/projects/ntfy](https://hosted.weblate.org/projects/ntfy/)

You can start translating immediately without any coding knowledge.

## Documentation

Found a typo? Want to improve the docs? Documentation contributions are very welcome:

- Edit any page directly on GitHub using the edit button
- Submit a pull request with your improvements

## Bug reports and feature requests

- **GitHub Issues**: [github.com/binwiederhier/ntfy/issues](https://github.com/binwiederhier/ntfy/issues)

Please search existing issues before creating a new one to avoid duplicates.

## Code of Conduct

Please be respectful and constructive in all interactions. See the 
[Code of Conduct](https://github.com/binwiederhier/ntfy/blob/main/CODE_OF_CONDUCT.md) for details.

