/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseFrameDecoder;

public class Pt502FrameDecoder
extends BaseFrameDecoder {
    private static final int BINARY_HEADER = 5;

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.readableBytes() < 10) {
            return null;
        }
        if (buf.getUnsignedByte(buf.readerIndex()) == 191 && buf.toString(buf.readerIndex() + 5, 4, StandardCharsets.US_ASCII).equals("$PHD")) {
            int length = buf.getUnsignedShortLE(buf.readerIndex() + 3);
            if (buf.readableBytes() >= length) {
                buf.skipBytes(5);
                ByteBuf result = buf.readRetainedSlice(length - 5 - 2);
                buf.skipBytes(2);
                return result;
            }
        } else {
            int index;
            if (buf.getUnsignedByte(buf.readerIndex()) == 191) {
                buf.skipBytes(5);
            }
            if ((index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)13)) < 0) {
                index = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)10);
            }
            if (index > 0) {
                ByteBuf result = buf.readRetainedSlice(index - buf.readerIndex());
                while (buf.isReadable() && (buf.getByte(buf.readerIndex()) == 13 || buf.getByte(buf.readerIndex()) == 10)) {
                    buf.skipBytes(1);
                }
                return result;
            }
        }
        return null;
    }
}

