/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.newsclub.net.unix.AFDatagramChannel$$Lambda$1;
import org.newsclub.net.unix.AFDatagramChannel$$Lambda$2;
import org.newsclub.net.unix.AFDatagramChannel$$Lambda$3;
import org.newsclub.net.unix.AFDatagramChannel$$Lambda$4;
import org.newsclub.net.unix.AFDatagramChannel$$Lambda$5;
import org.newsclub.net.unix.AFDatagramChannel$$Lambda$6;
import org.newsclub.net.unix.AFDatagramChannel$$Lambda$7;
import org.newsclub.net.unix.AFDatagramChannel$$Lambda$8;
import org.newsclub.net.unix.AFDatagramSocket;
import org.newsclub.net.unix.AFProtocolFamily;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketCore;
import org.newsclub.net.unix.AFSocketExtensions;
import org.newsclub.net.unix.AFSocketOption;
import org.newsclub.net.unix.AFSomeSocket;
import org.newsclub.net.unix.AFSomeSocketChannel;
import org.newsclub.net.unix.AFUNIXDatagramChannel;
import org.newsclub.net.unix.InterruptibleChannelUtil;
import org.newsclub.net.unix.SocketOptionsMapper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AFDatagramChannel<A extends AFSocketAddress>
extends DatagramChannel
implements AFSomeSocket,
AFSocketExtensions,
AFSomeSocketChannel {
    private final AFDatagramSocket<A> afSocket;

    protected AFDatagramChannel(AFSelectorProvider<A> selectorProvider, AFDatagramSocket<A> socket) {
        super(selectorProvider);
        this.afSocket = socket;
    }

    protected final AFDatagramSocket<A> getAFSocket() {
        return this.afSocket;
    }

    @Override
    public final MembershipKey join(InetAddress group, NetworkInterface interf) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final MembershipKey join(InetAddress group, NetworkInterface interf, InetAddress source) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final AFDatagramChannel<A> bind(SocketAddress local) throws IOException {
        this.afSocket.bind(local);
        return this;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public final AFDatagramSocket<A> socket() {
        return this.afSocket;
    }

    public final boolean isBound() {
        return this.afSocket.isBound();
    }

    @Override
    public final boolean isConnected() {
        return this.afSocket.isConnected();
    }

    @Override
    public final AFDatagramChannel<A> connect(SocketAddress remote) throws IOException {
        this.afSocket.connect(remote);
        return this;
    }

    @Override
    public final AFDatagramChannel<A> disconnect() throws IOException {
        this.afSocket.disconnect();
        return this;
    }

    public final @Nullable A getRemoteAddress() throws IOException {
        return (A)this.getRemoteSocketAddress();
    }

    public final @Nullable A getRemoteSocketAddress() {
        return (A)this.afSocket.getRemoteSocketAddress();
    }

    public final @Nullable A getLocalAddress() throws IOException {
        return (A)this.getLocalSocketAddress();
    }

    public final @Nullable A getLocalSocketAddress() {
        return (A)this.afSocket.getLocalSocketAddress();
    }

    public final A receive(ByteBuffer dst) throws IOException {
        A a;
        boolean complete = false;
        Exception exception = null;
        try {
            this.begin();
            A ret = this.afSocket.getAFImpl().receive(dst);
            complete = true;
            a = ret;
        }
        catch (IOException e) {
            try {
                exception = InterruptibleChannelUtil.handleException(this, e);
                throw InterruptibleChannelUtil.ioExceptionOrThrowRuntimeException(exception);
            }
            catch (Throwable throwable) {
                InterruptibleChannelUtil.endInterruptable(this, AFDatagramChannel$$Lambda$2.lambdaFactory$(this), complete, exception);
                throw throwable;
            }
        }
        InterruptibleChannelUtil.endInterruptable(this, AFDatagramChannel$$Lambda$1.lambdaFactory$(this), complete, exception);
        return a;
    }

    @Override
    public final int send(ByteBuffer src, SocketAddress target) throws IOException {
        int n;
        boolean complete = false;
        Exception exception = null;
        try {
            this.begin();
            int ret = this.afSocket.getAFImpl().send(src, target);
            complete = true;
            n = ret;
        }
        catch (IOException e) {
            try {
                exception = InterruptibleChannelUtil.handleException(this, e);
                throw InterruptibleChannelUtil.ioExceptionOrThrowRuntimeException(exception);
            }
            catch (Throwable throwable) {
                InterruptibleChannelUtil.endInterruptable(this, AFDatagramChannel$$Lambda$4.lambdaFactory$(this), complete, exception);
                throw throwable;
            }
        }
        InterruptibleChannelUtil.endInterruptable(this, AFDatagramChannel$$Lambda$3.lambdaFactory$(this), complete, exception);
        return n;
    }

    @Override
    public final int read(ByteBuffer dst) throws IOException {
        int n;
        boolean complete = false;
        Exception exception = null;
        try {
            this.begin();
            int ret = this.afSocket.getAFImpl().read(dst, null);
            complete = true;
            n = ret;
        }
        catch (IOException e) {
            try {
                exception = InterruptibleChannelUtil.handleException(this, e);
                throw InterruptibleChannelUtil.ioExceptionOrThrowRuntimeException(exception);
            }
            catch (Throwable throwable) {
                InterruptibleChannelUtil.endInterruptable(this, AFDatagramChannel$$Lambda$6.lambdaFactory$(this), complete, exception);
                throw throwable;
            }
        }
        InterruptibleChannelUtil.endInterruptable(this, AFDatagramChannel$$Lambda$5.lambdaFactory$(this), complete, exception);
        return n;
    }

    @Override
    public final long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        return this.read(dsts[offset]);
    }

    @Override
    public final int write(ByteBuffer src) throws IOException {
        int n;
        boolean complete = false;
        Exception exception = null;
        try {
            this.begin();
            int ret = this.afSocket.getAFImpl().write(src);
            complete = true;
            n = ret;
        }
        catch (IOException e) {
            try {
                exception = InterruptibleChannelUtil.handleException(this, e);
                throw InterruptibleChannelUtil.ioExceptionOrThrowRuntimeException(exception);
            }
            catch (Throwable throwable) {
                InterruptibleChannelUtil.endInterruptable(this, AFDatagramChannel$$Lambda$8.lambdaFactory$(this), complete, exception);
                throw throwable;
            }
        }
        InterruptibleChannelUtil.endInterruptable(this, AFDatagramChannel$$Lambda$7.lambdaFactory$(this), complete, exception);
        return n;
    }

    @Override
    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        return this.write(srcs[offset]);
    }

    @Override
    protected final void implCloseSelectableChannel() throws IOException {
        this.getAFSocket().close();
    }

    @Override
    protected final void implConfigureBlocking(boolean block) throws IOException {
        this.getAFCore().implConfigureBlocking(block);
    }

    @Override
    public final int getAncillaryReceiveBufferSize() {
        return this.afSocket.getAncillaryReceiveBufferSize();
    }

    @Override
    public final void setAncillaryReceiveBufferSize(int size) {
        this.afSocket.setAncillaryReceiveBufferSize(size);
    }

    @Override
    public final void ensureAncillaryReceiveBufferSize(int minSize) {
        this.afSocket.ensureAncillaryReceiveBufferSize(minSize);
    }

    @Override
    public final <T> AFDatagramChannel<A> setOption(SocketOption<T> name, T value) throws IOException {
        if (name instanceof AFSocketOption) {
            this.getAFCore().setOption((AFSocketOption)name, value);
            return this;
        }
        Integer optionId = SocketOptionsMapper.resolve(name);
        if (optionId == null) {
            throw new UnsupportedOperationException("unsupported option");
        }
        this.afSocket.getAFImpl().setOption(optionId, value);
        return this;
    }

    @Override
    public final <T> T getOption(SocketOption<T> name) throws IOException {
        if (name instanceof AFSocketOption) {
            return this.getAFCore().getOption((AFSocketOption)name);
        }
        Integer optionId = SocketOptionsMapper.resolve(name);
        if (optionId == null) {
            throw new UnsupportedOperationException("unsupported option");
        }
        return (T)this.afSocket.getAFImpl().getOption(optionId);
    }

    @Override
    public final Set<SocketOption<?>> supportedOptions() {
        return SocketOptionsMapper.SUPPORTED_SOCKET_OPTIONS;
    }

    final AFSocketCore getAFCore() {
        return this.afSocket.getAFImpl().getCore();
    }

    @Override
    public final FileDescriptor getFileDescriptor() throws IOException {
        return this.afSocket.getFileDescriptor();
    }

    public final boolean isDeleteOnClose() {
        return this.afSocket.isDeleteOnClose();
    }

    public final void setDeleteOnClose(boolean b) {
        this.afSocket.setDeleteOnClose(b);
    }

    @Override
    public void setShutdownOnClose(boolean enabled) {
        this.getAFCore().setShutdownOnClose(enabled);
    }

    public static DatagramChannel open(ProtocolFamily family) throws IOException {
        Objects.requireNonNull(family);
        if (family instanceof AFProtocolFamily) {
            return ((AFProtocolFamily)family).openDatagramChannel();
        }
        if ("UNIX".equals(family.name())) {
            return AFUNIXDatagramChannel.open();
        }
        if (family instanceof StandardProtocolFamily) {
            return DatagramChannel.open();
        }
        throw new UnsupportedOperationException("Protocol family not supported");
    }

    static /* synthetic */ void lambda$write$3(AFDatagramChannel rec$, boolean x$0) throws AsynchronousCloseException {
        rec$.end(x$0);
    }

    static /* synthetic */ void lambda$read$2(AFDatagramChannel rec$, boolean x$0) throws AsynchronousCloseException {
        rec$.end(x$0);
    }

    static /* synthetic */ void lambda$send$1(AFDatagramChannel rec$, boolean x$0) throws AsynchronousCloseException {
        rec$.end(x$0);
    }

    static /* synthetic */ void lambda$receive$0(AFDatagramChannel rec$, boolean x$0) throws AsynchronousCloseException {
        rec$.end(x$0);
    }
}

