/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.InternalApi;
import com.google.cloud.firestore.AggregateField;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.pipeline.expressions.AggregateFunction;
import com.google.cloud.firestore.pipeline.expressions.AliasedAggregate;
import com.google.cloud.firestore.pipeline.expressions.AliasedExpression;
import com.google.cloud.firestore.pipeline.expressions.BooleanExpression;
import com.google.cloud.firestore.pipeline.expressions.Expression;
import com.google.cloud.firestore.pipeline.expressions.Field;
import com.google.cloud.firestore.pipeline.expressions.FunctionUtils;
import com.google.cloud.firestore.pipeline.expressions.Selectable;
import com.google.common.collect.Lists;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Value;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@InternalApi
public class PipelineUtils {
    @InternalApi
    public static Value encodeValue(Object value) {
        return UserDataConverter.encodeValue(FieldPath.empty(), value, UserDataConverter.ARGUMENT);
    }

    @InternalApi
    public static Value encodeValue(Expression value) {
        return FunctionUtils.exprToValue(value);
    }

    @InternalApi
    public static Value encodeValue(AggregateFunction value) {
        return FunctionUtils.aggregateFunctionToValue(value);
    }

    @InternalApi
    public static Value encodeValue(String value) {
        return Value.newBuilder().setStringValue(value).build();
    }

    @InternalApi
    public static Value encodeValue(boolean value) {
        return Value.newBuilder().setBooleanValue(value).build();
    }

    @InternalApi
    public static Value encodeValue(long value) {
        return Value.newBuilder().setIntegerValue(value).build();
    }

    @InternalApi
    public static Value encodeValue(double value) {
        return Value.newBuilder().setDoubleValue(value).build();
    }

    @InternalApi
    public static Value encodeValue(Map<String, Value> options) {
        return Value.newBuilder().setMapValue(MapValue.newBuilder().putAllFields(options).build()).build();
    }

    @InternalApi
    static BooleanExpression toPipelineBooleanExpr(Query.FilterInternal f) {
        if (f instanceof Query.ComparisonFilterInternal) {
            Query.ComparisonFilterInternal comparisonFilter = (Query.ComparisonFilterInternal)f;
            Field field = Field.ofServerPath(comparisonFilter.fieldReference.getFieldPath());
            Value value = comparisonFilter.value;
            switch (comparisonFilter.operator) {
                case LESS_THAN: {
                    return Expression.and(field.exists(), field.lessThan(value));
                }
                case LESS_THAN_OR_EQUAL: {
                    return Expression.and(field.exists(), field.lessThanOrEqual(value));
                }
                case GREATER_THAN: {
                    return Expression.and(field.exists(), field.greaterThan(value));
                }
                case GREATER_THAN_OR_EQUAL: {
                    return Expression.and(field.exists(), field.greaterThanOrEqual(value));
                }
                case EQUAL: {
                    return Expression.and(field.exists(), field.equal(value));
                }
                case NOT_EQUAL: {
                    return Expression.and(field.exists(), field.notEqual(value));
                }
                case ARRAY_CONTAINS: {
                    return Expression.and(field.exists(), field.arrayContains(value));
                }
                case IN: {
                    List valuesList = value.getArrayValue().getValuesList();
                    return Expression.and(field.exists(), Expression.equalAny((Expression)field, (List<Object>)Lists.newArrayList((Iterable)valuesList)));
                }
                case ARRAY_CONTAINS_ANY: {
                    List valuesListAny = value.getArrayValue().getValuesList();
                    return Expression.and(field.exists(), Expression.arrayContainsAny((Expression)field, (List<Object>)Lists.newArrayList((Iterable)valuesListAny)));
                }
                case NOT_IN: {
                    List notInValues = value.getArrayValue().getValuesList();
                    return Expression.and(field.exists(), Expression.not(Expression.equalAny((Expression)field, (List<Object>)Lists.newArrayList((Iterable)notInValues))));
                }
            }
            throw new IllegalArgumentException("Unsupported operator: " + comparisonFilter.operator);
        }
        if (f instanceof Query.CompositeFilterInternal) {
            Query.CompositeFilterInternal compositeFilter = (Query.CompositeFilterInternal)f;
            switch (compositeFilter.getOperator()) {
                case AND: {
                    List conditions = compositeFilter.getFilters().stream().map(PipelineUtils::toPipelineBooleanExpr).collect(Collectors.toList());
                    return Expression.and((BooleanExpression)conditions.get(0), conditions.subList(1, conditions.size()).toArray(new BooleanExpression[0]));
                }
                case OR: {
                    List orConditions = compositeFilter.getFilters().stream().map(PipelineUtils::toPipelineBooleanExpr).collect(Collectors.toList());
                    return Expression.or((BooleanExpression)orConditions.get(0), orConditions.subList(1, orConditions.size()).toArray(new BooleanExpression[0]));
                }
            }
            throw new IllegalArgumentException("Unsupported operator: " + compositeFilter.getOperator());
        }
        if (f instanceof Query.UnaryFilterInternal) {
            Query.UnaryFilterInternal unaryFilter = (Query.UnaryFilterInternal)f;
            Field field = Field.ofServerPath(unaryFilter.fieldReference.getFieldPath());
            switch (unaryFilter.getOperator()) {
                case IS_NAN: {
                    return Expression.and(field.exists(), field.equal(Double.NaN));
                }
                case IS_NULL: {
                    return Expression.and(field.exists(), field.equal(Expression.nullValue()));
                }
                case IS_NOT_NAN: {
                    return Expression.and(field.exists(), field.notEqual(Double.NaN));
                }
                case IS_NOT_NULL: {
                    return Expression.and(field.exists(), field.notEqual(Expression.nullValue()));
                }
            }
            throw new IllegalArgumentException("Unsupported operator: " + unaryFilter.getOperator());
        }
        throw new IllegalArgumentException("Unsupported filter type: " + f.getClass().getName());
    }

    @InternalApi
    static AliasedAggregate toPipelineAggregatorTarget(AggregateField f) {
        String operator = f.getOperator();
        String fieldPath = f.getFieldPath();
        switch (operator) {
            case "sum": {
                return Field.ofServerPath(fieldPath).sum().as(f.getAlias());
            }
            case "count": {
                return AggregateFunction.countAll().as(f.getAlias());
            }
            case "average": {
                return Field.ofServerPath(fieldPath).average().as(f.getAlias());
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + operator);
    }

    @InternalApi
    static BooleanExpression toPipelineExistsExpr(AggregateField f) {
        String fieldPath = f.getFieldPath();
        if (fieldPath.isEmpty()) {
            return null;
        }
        return Field.ofServerPath(fieldPath).exists();
    }

    @InternalApi
    public static Map<String, Expression> selectablesToMap(Selectable ... selectables) {
        HashMap<String, Expression> projMap = new HashMap<String, Expression>();
        for (Selectable proj : selectables) {
            if (proj instanceof Field) {
                Field fieldProj = (Field)proj;
                if (projMap.containsKey(fieldProj.getPath().getEncodedPath())) {
                    throw new IllegalArgumentException("Duplicate alias or field name: " + fieldProj.getPath().getEncodedPath());
                }
                projMap.put(fieldProj.getPath().getEncodedPath(), fieldProj);
                continue;
            }
            if (!(proj instanceof AliasedExpression)) continue;
            AliasedExpression aliasedExpr = (AliasedExpression)proj;
            if (projMap.containsKey(aliasedExpr.getAlias())) {
                throw new IllegalArgumentException("Duplicate alias or field name: " + aliasedExpr.getAlias());
            }
            projMap.put(aliasedExpr.getAlias(), aliasedExpr.getExpr());
        }
        return projMap;
    }

    @InternalApi
    public static Map<String, Expression> fieldNamesToMap(String ... fields) {
        HashMap<String, Expression> projMap = new HashMap<String, Expression>();
        for (String field : fields) {
            projMap.put(field, Expression.field(field));
        }
        return projMap;
    }
}

