/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.QuantileMethod;
import com.mongodb.client.model.SimpleExpression;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.assertions.Assertions;
import org.bson.conversions.Bson;

public final class Accumulators {
    public static <TExpression> BsonField sum(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$sum", fieldName, expression);
    }

    public static <TExpression> BsonField avg(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$avg", fieldName, expression);
    }

    public static <InExpression, PExpression> BsonField percentile(String fieldName, InExpression inExpression, PExpression pExpression, QuantileMethod method) {
        Assertions.notNull((String)"fieldName", (Object)fieldName);
        Assertions.notNull((String)"inExpression", inExpression);
        Assertions.notNull((String)"pExpression", inExpression);
        Assertions.notNull((String)"method", (Object)method);
        return Accumulators.quantileAccumulator("$percentile", fieldName, inExpression, pExpression, method);
    }

    public static <InExpression> BsonField median(String fieldName, InExpression inExpression, QuantileMethod method) {
        Assertions.notNull((String)"fieldName", (Object)fieldName);
        Assertions.notNull((String)"inExpression", inExpression);
        Assertions.notNull((String)"method", (Object)method);
        return Accumulators.quantileAccumulator("$median", fieldName, inExpression, null, method);
    }

    public static <TExpression> BsonField first(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$first", fieldName, expression);
    }

    public static <InExpression, NExpression> BsonField firstN(String fieldName, InExpression inExpression, NExpression nExpression) {
        return Accumulators.pickNAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$firstN", Assertions.notNull((String)"inExpression", inExpression), Assertions.notNull((String)"nExpression", nExpression));
    }

    public static <OutExpression> BsonField top(String fieldName, Bson sortBy, OutExpression outExpression) {
        return Accumulators.sortingPickAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$top", (Bson)Assertions.notNull((String)"sortBy", (Object)sortBy), Assertions.notNull((String)"outExpression", outExpression));
    }

    public static <OutExpression, NExpression> BsonField topN(String fieldName, Bson sortBy, OutExpression outExpression, NExpression nExpression) {
        return Accumulators.sortingPickNAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$topN", (Bson)Assertions.notNull((String)"sortBy", (Object)sortBy), Assertions.notNull((String)"outExpression", outExpression), Assertions.notNull((String)"nExpression", nExpression));
    }

    public static <TExpression> BsonField last(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$last", fieldName, expression);
    }

    public static <InExpression, NExpression> BsonField lastN(String fieldName, InExpression inExpression, NExpression nExpression) {
        return Accumulators.pickNAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$lastN", Assertions.notNull((String)"inExpression", inExpression), Assertions.notNull((String)"nExpression", nExpression));
    }

    public static <OutExpression> BsonField bottom(String fieldName, Bson sortBy, OutExpression outExpression) {
        return Accumulators.sortingPickAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$bottom", (Bson)Assertions.notNull((String)"sortBy", (Object)sortBy), Assertions.notNull((String)"outExpression", outExpression));
    }

    public static <OutExpression, NExpression> BsonField bottomN(String fieldName, Bson sortBy, OutExpression outExpression, NExpression nExpression) {
        return Accumulators.sortingPickNAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$bottomN", (Bson)Assertions.notNull((String)"sortBy", (Object)sortBy), Assertions.notNull((String)"outExpression", outExpression), Assertions.notNull((String)"nExpression", nExpression));
    }

    public static <TExpression> BsonField max(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$max", fieldName, expression);
    }

    public static <InExpression, NExpression> BsonField maxN(String fieldName, InExpression inExpression, NExpression nExpression) {
        return Accumulators.pickNAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$maxN", Assertions.notNull((String)"inExpression", inExpression), Assertions.notNull((String)"nExpression", nExpression));
    }

    public static <TExpression> BsonField min(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$min", fieldName, expression);
    }

    public static <InExpression, NExpression> BsonField minN(String fieldName, InExpression inExpression, NExpression nExpression) {
        return Accumulators.pickNAccumulator((String)Assertions.notNull((String)"fieldName", (Object)fieldName), "$minN", Assertions.notNull((String)"inExpression", inExpression), Assertions.notNull((String)"nExpression", nExpression));
    }

    public static <TExpression> BsonField push(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$push", fieldName, expression);
    }

    public static <TExpression> BsonField addToSet(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$addToSet", fieldName, expression);
    }

    public static <TExpression> BsonField mergeObjects(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$mergeObjects", fieldName, expression);
    }

    public static <TExpression> BsonField stdDevPop(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$stdDevPop", fieldName, expression);
    }

    public static <TExpression> BsonField stdDevSamp(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$stdDevSamp", fieldName, expression);
    }

    public static BsonField accumulator(String fieldName, String initFunction, String accumulateFunction, String mergeFunction) {
        return Accumulators.accumulator(fieldName, initFunction, null, accumulateFunction, null, mergeFunction, null, "js");
    }

    public static BsonField accumulator(String fieldName, String initFunction, String accumulateFunction, String mergeFunction, @Nullable String finalizeFunction) {
        return Accumulators.accumulator(fieldName, initFunction, null, accumulateFunction, null, mergeFunction, finalizeFunction, "js");
    }

    public static BsonField accumulator(String fieldName, String initFunction, @Nullable List<String> initArgs, String accumulateFunction, @Nullable List<String> accumulateArgs, String mergeFunction, @Nullable String finalizeFunction) {
        return Accumulators.accumulator(fieldName, initFunction, initArgs, accumulateFunction, accumulateArgs, mergeFunction, finalizeFunction, "js");
    }

    public static BsonField accumulator(String fieldName, String initFunction, String accumulateFunction, String mergeFunction, @Nullable String finalizeFunction, String lang) {
        return Accumulators.accumulator(fieldName, initFunction, null, accumulateFunction, null, mergeFunction, finalizeFunction, lang);
    }

    public static BsonField accumulator(String fieldName, String initFunction, @Nullable List<String> initArgs, String accumulateFunction, @Nullable List<String> accumulateArgs, String mergeFunction, @Nullable String finalizeFunction, String lang) {
        BsonDocument accumulatorStage = new BsonDocument("init", (BsonValue)new BsonString(initFunction)).append("initArgs", (BsonValue)(initArgs != null ? new BsonArray(initArgs.stream().map(initArg -> new BsonString(initArg)).collect(Collectors.toList())) : new BsonArray())).append("accumulate", (BsonValue)new BsonString(accumulateFunction)).append("accumulateArgs", (BsonValue)(accumulateArgs != null ? new BsonArray(accumulateArgs.stream().map(accumulateArg -> new BsonString(accumulateArg)).collect(Collectors.toList())) : new BsonArray())).append("merge", (BsonValue)new BsonString(mergeFunction)).append("lang", (BsonValue)new BsonString(lang));
        if (finalizeFunction != null) {
            accumulatorStage.append("finalize", (BsonValue)new BsonString(finalizeFunction));
        }
        return Accumulators.accumulatorOperator("$accumulator", fieldName, accumulatorStage);
    }

    private static <TExpression> BsonField accumulatorOperator(String name, String fieldName, TExpression expression) {
        return new BsonField(fieldName, new SimpleExpression<TExpression>(name, expression));
    }

    private static <InExpression, NExpression> BsonField pickNAccumulator(String fieldName, String accumulatorName, InExpression inExpression, NExpression nExpression) {
        return new BsonField(fieldName, (Bson)new Document(accumulatorName, (Object)new Document("input", inExpression).append("n", nExpression)));
    }

    private static <OutExpression> BsonField sortingPickAccumulator(String fieldName, String accumulatorName, Bson sort, OutExpression outExpression) {
        return new BsonField(fieldName, (Bson)new Document(accumulatorName, (Object)new Document("sortBy", (Object)sort).append("output", outExpression)));
    }

    private static <OutExpression, NExpression> BsonField sortingPickNAccumulator(String fieldName, String accumulatorName, Bson sort, OutExpression outExpression, NExpression nExpression) {
        return new BsonField(fieldName, (Bson)new Document(accumulatorName, (Object)new Document("sortBy", (Object)sort).append("output", outExpression).append("n", nExpression)));
    }

    private static <InExpression, PExpression> BsonField quantileAccumulator(String quantileAccumulatorName, String fieldName, InExpression inExpression, @Nullable PExpression pExpression, QuantileMethod method) {
        Document document = new Document("input", inExpression).append("method", (Object)method.toBsonValue());
        if (pExpression != null) {
            document.append("p", pExpression);
        }
        return Accumulators.accumulatorOperator(quantileAccumulatorName, fieldName, document);
    }

    private Accumulators() {
    }
}

