/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.object.oriented.network;

import com.ubnt.data.Site;
import com.ubnt.model.api.object.oriented.network.ObjectOrientedNetworkConfigDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.object.oriented.network.ObjectOrientedNetworkConfigValidator;
import com.ubnt.net.v2.object.oriented.network.ObjectOrientedNetworkDocumentConverter;
import com.ubnt.net.v2.object.oriented.network.exception.ObjectOrientedNetworkConfigNotFound;
import com.ubnt.net.v2.object.oriented.network.exception.UnexpectedObjectOrientedNetworkConfigId;
import com.ubnt.service.object.oriented.network.ObjectOrientedNetworkConfigDocument;
import com.ubnt.service.object.oriented.network.oooO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Validated
@V2RestController
@Tag(name="ObjectOrientedNetwork")
public class ObjectOrientedNetworkController {
    private final oooO \u00d200000;
    private final ObjectOrientedNetworkConfigValidator o00000;

    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create an object oriented network config")
    @PostMapping(value={"/api/site/{siteName}/object-oriented-network-config"}, consumes={"application/json"})
    public ObjectOrientedNetworkConfigDto createObjectOrientedNetworkConfig(@PathVariable(value="siteName") Site site, @RequestBody @Valid ObjectOrientedNetworkConfigDto objectOrientedNetworkConfigDto) {
        this.o00000.validate(site.getId(), objectOrientedNetworkConfigDto);
        ObjectOrientedNetworkConfigDocument objectOrientedNetworkConfigDocument = this.\u00d200000.\u00d2O0000(ObjectOrientedNetworkDocumentConverter.toDocument(site.getId(), objectOrientedNetworkConfigDto));
        return ObjectOrientedNetworkDocumentConverter.fromDocument(objectOrientedNetworkConfigDocument);
    }

    @Operation(summary="Update the existing object oriented network config")
    @PutMapping(value={"/api/site/{siteName}/object-oriented-network-config/{id}"}, consumes={"application/json"})
    public ObjectOrientedNetworkConfigDto updateObjectOrientedNetworkConfig(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string, @RequestBody @Valid ObjectOrientedNetworkConfigDto objectOrientedNetworkConfigDto) {
        if (!Objects.equals(objectOrientedNetworkConfigDto.id(), string)) {
            throw new UnexpectedObjectOrientedNetworkConfigId();
        }
        this.o00000.validate(site.getId(), objectOrientedNetworkConfigDto);
        ObjectOrientedNetworkConfigDocument objectOrientedNetworkConfigDocument = this.\u00d200000.public(ObjectOrientedNetworkDocumentConverter.toDocument(site.getId(), objectOrientedNetworkConfigDto));
        return ObjectOrientedNetworkDocumentConverter.fromDocument(objectOrientedNetworkConfigDocument);
    }

    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete the object oriented network config")
    @DeleteMapping(value={"/api/site/{siteName}/object-oriented-network-config/{id}"})
    public void deleteObjectOrientedNetworkConfig(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        ObjectOrientedNetworkConfigDocument objectOrientedNetworkConfigDocument = this.\u00d200000.Object(site.getId(), string).orElseThrow(() -> new ObjectOrientedNetworkConfigNotFound(string));
        this.\u00d200000.\u00f6O0000(objectOrientedNetworkConfigDocument);
    }

    @Operation(summary="Get all object oriented network configs")
    @GetMapping(value={"/api/site/{siteName}/object-oriented-network-configs"})
    public List<ObjectOrientedNetworkConfigDto> getObjectOrientedNetworkConfigs(@PathVariable(value="siteName") Site site) {
        return this.\u00d200000.float(site.getId()).stream().map(ObjectOrientedNetworkDocumentConverter::fromDocument).toList();
    }

    @Operation(summary="Get a object oriented network config")
    @GetMapping(value={"/api/site/{siteName}/object-oriented-network-config/{id}"})
    public ObjectOrientedNetworkConfigDto getObjectOrientedNetworkConfig(@PathVariable(value="siteName") Site site, @PathVariable(value="id") String string) {
        return this.\u00d200000.Object(site.getId(), string).map(ObjectOrientedNetworkDocumentConverter::fromDocument).orElseThrow(() -> new ObjectOrientedNetworkConfigNotFound(string));
    }

    @ConstructorProperties(value={"objectOrientedNetworkService", "objectOrientedNetworkConfigValidator"})
    @Generated
    public ObjectOrientedNetworkController(oooO oooO2, ObjectOrientedNetworkConfigValidator objectOrientedNetworkConfigValidator) {
        this.\u00d200000 = oooO2;
        this.o00000 = objectOrientedNetworkConfigValidator;
    }
}

