/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.site.overview;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.ubnt.model.api.site.overview.SiteOverviewDto;
import com.ubnt.model.api.site.overview.SiteOverviewListDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Generated(from="SiteOverviewListDto", generator="Immutables")
public final class ImmutableSiteOverviewListDto
implements SiteOverviewListDto {
    private final List<SiteOverviewDto> data;
    private final long totalElementCount;
    private final int totalPageCount;
    private final int pageNumber;
    @Nullable
    private final Boolean orMore;
    @Nullable
    private final Boolean hasNext;

    private ImmutableSiteOverviewListDto(Builder builder) {
        this.data = ImmutableSiteOverviewListDto.whilesuper(true, builder.data);
        this.totalElementCount = builder.totalElementCount;
        this.totalPageCount = builder.totalPageCount;
        this.pageNumber = builder.pageNumber;
        this.orMore = builder.orMore;
        this.hasNext = builder.hasNext;
    }

    @Override
    public List<SiteOverviewDto> data() {
        return this.data;
    }

    @Override
    @Schema(description="Number of total matched elements searching by the given criteria", example="1")
    public long totalElementCount() {
        return this.totalElementCount;
    }

    @Override
    public int totalPageCount() {
        return this.totalPageCount;
    }

    @Override
    public int pageNumber() {
        return this.pageNumber;
    }

    @Override
    @Schema(description="True if there can be more elements than based on the total number of page")
    public Optional<Boolean> orMore() {
        return Optional.ofNullable(this.orMore);
    }

    @Override
    public Optional<Boolean> hasNext() {
        return Optional.ofNullable(this.hasNext);
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableSiteOverviewListDto && this.\u00f6o0000(0, (ImmutableSiteOverviewListDto)object);
    }

    private boolean \u00f6o0000(int n2, ImmutableSiteOverviewListDto immutableSiteOverviewListDto) {
        return this.data.equals(immutableSiteOverviewListDto.data) && this.totalElementCount == immutableSiteOverviewListDto.totalElementCount && this.totalPageCount == immutableSiteOverviewListDto.totalPageCount && this.pageNumber == immutableSiteOverviewListDto.pageNumber && Objects.equals(this.orMore, immutableSiteOverviewListDto.orMore) && Objects.equals(this.hasNext, immutableSiteOverviewListDto.hasNext);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + this.data.hashCode();
        n2 += (n2 << 5) + Long.hashCode(this.totalElementCount);
        n2 += (n2 << 5) + this.totalPageCount;
        n2 += (n2 << 5) + this.pageNumber;
        n2 += (n2 << 5) + Objects.hashCode(this.orMore);
        n2 += (n2 << 5) + Objects.hashCode(this.hasNext);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SiteOverviewListDto{");
        stringBuilder.append("data=").append(this.data);
        stringBuilder.append(", ");
        stringBuilder.append("totalElementCount=").append(this.totalElementCount);
        stringBuilder.append(", ");
        stringBuilder.append("totalPageCount=").append(this.totalPageCount);
        stringBuilder.append(", ");
        stringBuilder.append("pageNumber=").append(this.pageNumber);
        if (this.orMore != null) {
            stringBuilder.append(", ");
            stringBuilder.append("orMore=").append(this.orMore);
        }
        if (this.hasNext != null) {
            stringBuilder.append(", ");
            stringBuilder.append("hasNext=").append(this.hasNext);
        }
        return stringBuilder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> \u00f5o0000(Iterable<? extends T> iterable, boolean bl, boolean bl2) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n2);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t2 : iterable) {
            if (bl2 && t2 == null) continue;
            if (bl) {
                Objects.requireNonNull(t2, "element");
            }
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static <T> List<T> whilesuper(boolean bl, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SiteOverviewListDto", generator="Immutables")
    public static final class Builder {
        private List<SiteOverviewDto> data = new ArrayList<SiteOverviewDto>();
        private long totalElementCount;
        private int totalPageCount;
        private int pageNumber;
        @Nullable
        private Boolean orMore;
        @Nullable
        private Boolean hasNext;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SiteOverviewListDto siteOverviewListDto) {
            Optional<Boolean> optional;
            Objects.requireNonNull(siteOverviewListDto, "instance");
            this.addAllData(siteOverviewListDto.data());
            this.totalElementCount(siteOverviewListDto.totalElementCount());
            this.totalPageCount(siteOverviewListDto.totalPageCount());
            this.pageNumber(siteOverviewListDto.pageNumber());
            Optional<Boolean> optional2 = siteOverviewListDto.orMore();
            if (optional2.isPresent()) {
                this.orMore(optional2);
            }
            if ((optional = siteOverviewListDto.hasNext()).isPresent()) {
                this.hasNext(optional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addData(@Nullable SiteOverviewDto siteOverviewDto) {
            this.data.add(siteOverviewDto);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addData(SiteOverviewDto ... siteOverviewDtoArray) {
            for (SiteOverviewDto siteOverviewDto : siteOverviewDtoArray) {
                this.data.add(siteOverviewDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder data(Iterable<? extends SiteOverviewDto> iterable) {
            this.data.clear();
            return this.addAllData(iterable);
        }

        @CanIgnoreReturnValue
        public final Builder addAllData(Iterable<? extends SiteOverviewDto> iterable) {
            for (SiteOverviewDto siteOverviewDto : iterable) {
                this.data.add(siteOverviewDto);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalElementCount(long l2) {
            this.totalElementCount = l2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalPageCount(int n2) {
            this.totalPageCount = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pageNumber(int n2) {
            this.pageNumber = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder orMore(@Nullable Boolean bl) {
            this.orMore = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder orMore(Optional<Boolean> optional) {
            this.orMore = optional.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasNext(@Nullable Boolean bl) {
            this.hasNext = bl;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasNext(Optional<Boolean> optional) {
            this.hasNext = optional.orElse(null);
            return this;
        }

        public ImmutableSiteOverviewListDto build() {
            return new ImmutableSiteOverviewListDto(this);
        }
    }
}

