/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.wifi;

import com.ubnt.data.Site;
import com.ubnt.model.api.report.IncorrectWifiExperience;
import com.ubnt.model.api.wlan.WifiExperienceScoreDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.RequireUCoreLocal;
import com.ubnt.net.v2.validation.RequestPathResourceValidator;
import com.ubnt.net.v2.validation.constraints.Ip;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import com.ubnt.service.trace.M;
import com.ubnt.service.trace.api.wfiexperience.WifiScoreFeedbackEvent;
import com.ubnt.service.trace.class;
import com.ubnt.service.wifi.experience.void;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="WiFi Experience")
public class WifiExperienceController {
    private final RequestPathResourceValidator \u00d300000;
    private final class \u00d400000;
    private final M o00000;
    private final void new;

    public WifiExperienceController(RequestPathResourceValidator requestPathResourceValidator, class clazz, M m2, void void_) {
        this.\u00d300000 = requestPathResourceValidator;
        this.\u00d400000 = clazz;
        this.o00000 = m2;
        this.new = void_;
    }

    @RequireUCoreLocal
    @GetMapping(value={"/api/site/{siteName}/client/{clientIp}/wifi_experience"})
    @Operation(summary="Get WiFi Experience Score for client by clients local IP")
    public WifiExperienceScoreDto getStationScoreByClientIp(@PathVariable(value="siteName") Site site, @PathVariable(value="clientIp") @Ip String string) {
        int n2 = this.new.\u00d400000(site.getId(), string);
        return WifiExperienceScoreDto.of(n2);
    }

    @RequireUCoreLocal
    @GetMapping(value={"/api/site/{siteName}/client/{clientMac}/experience"})
    @Operation(summary="Get Client experience by MAC")
    public WifiExperienceScoreDto getStationScoreByClientMac(@PathVariable(value="siteName") Site site, @PathVariable(value="clientMac") @MacAddress String string) {
        int n2 = this.new.\u00d300000(site.getId(), string);
        return WifiExperienceScoreDto.of(n2);
    }

    @RequireUCoreLocal
    @PostMapping(value={"/api/site/{siteName}/client/{clientIp}/wifi_experience/incorrect"})
    @Operation(summary="Report wifi issues for client by clients local IP")
    public IncorrectWifiExperience incorrectStationScoreByClientIp(@PathVariable(value="siteName") Site site, @PathVariable(value="clientIp") @Ip String string, @RequestBody @Valid IncorrectWifiExperience incorrectWifiExperience) {
        this.new.\u00d200000(site.getId(), string, incorrectWifiExperience);
        return incorrectWifiExperience;
    }

    @RequireUCoreLocal
    @PostMapping(value={"/api/site/{siteName}/client/{clientMac}/experience/incorrect"})
    @Operation(summary="Report wifi issues for client by MAC")
    public IncorrectWifiExperience incorrectStationScoreByClientMac(@PathVariable(value="siteName") Site site, @PathVariable(value="clientMac") @MacAddress String string, @RequestBody @Valid IncorrectWifiExperience incorrectWifiExperience) {
        this.new.super(site.getId(), string, incorrectWifiExperience);
        return incorrectWifiExperience;
    }

    @PostMapping(value={"/api/site/{siteName}/station/{mac}/wifi_experience/incorrect"})
    @Operation(summary="Report wifi issues for client")
    public IncorrectWifiExperience incorrectStationScore(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string, @RequestBody IncorrectWifiExperience incorrectWifiExperience) {
        this.\u00d300000.siteContainsStation(site.getId(), string);
        WifiScoreFeedbackEvent wifiScoreFeedbackEvent = WifiScoreFeedbackEvent.ofClient(site.getId(), string, incorrectWifiExperience);
        this.o00000.o00000(() -> this.\u00d400000.\u00d400000(wifiScoreFeedbackEvent));
        return incorrectWifiExperience;
    }

    @PostMapping(value={"/api/site/{siteName}/device/{mac}/wifi_experience/incorrect"})
    @Operation(summary="Report wifi issues for Access Point")
    public IncorrectWifiExperience incorrectDeviceScore(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string, @RequestBody IncorrectWifiExperience incorrectWifiExperience) {
        this.\u00d300000.siteContainsDevice(site.getId(), string);
        WifiScoreFeedbackEvent wifiScoreFeedbackEvent = WifiScoreFeedbackEvent.ofDevice(site.getId(), string, incorrectWifiExperience);
        this.o00000.o00000(() -> this.\u00d400000.\u00d400000(wifiScoreFeedbackEvent));
        return incorrectWifiExperience;
    }
}

