/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.gridfs.model;

import com.mongodb.MongoGridFSException;
import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Date;
import java.util.Objects;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.types.ObjectId;

public final class GridFSFile {
    private final BsonValue id;
    private final String filename;
    private final long length;
    private final int chunkSize;
    private final Date uploadDate;
    private final Document metadata;

    public GridFSFile(BsonValue id, String filename, long length, int chunkSize, Date uploadDate, @Nullable Document metadata) {
        this.id = Assertions.notNull("id", id);
        this.filename = Assertions.notNull("filename", filename);
        this.length = Assertions.notNull("length", length);
        this.chunkSize = Assertions.notNull("chunkSize", chunkSize);
        this.uploadDate = Assertions.notNull("uploadDate", uploadDate);
        this.metadata = metadata != null && metadata.isEmpty() ? null : metadata;
    }

    public ObjectId getObjectId() {
        if (!this.id.isObjectId()) {
            throw new MongoGridFSException("Custom id type used for this GridFS file");
        }
        return this.id.asObjectId().getValue();
    }

    public BsonValue getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getLength() {
        return this.length;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public Date getUploadDate() {
        return this.uploadDate;
    }

    @Nullable
    public Document getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridFSFile that = (GridFSFile)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!this.filename.equals(that.filename)) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        if (this.chunkSize != that.chunkSize) {
            return false;
        }
        if (!this.uploadDate.equals(that.uploadDate)) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.filename.hashCode();
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + this.chunkSize;
        result = 31 * result + this.uploadDate.hashCode();
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GridFSFile{id=" + this.id + ", filename='" + this.filename + '\'' + ", length=" + this.length + ", chunkSize=" + this.chunkSize + ", uploadDate=" + this.uploadDate + ", metadata=" + this.metadata + '}';
    }
}

