/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.code.CodeConstants;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ClasspathHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExprUtil;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SFormsConstructor;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.VarMapHolder;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.CodeType;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.TypeFamily;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.Pair;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;
import org.jetbrains.java.decompiler.util.collections.ListStack;
import org.jetbrains.java.decompiler.util.collections.NullableConcurrentHashMap;

public class InvocationExprent
extends Exprent {
    private static final BitSet EMPTY_BIT_SET = new BitSet(0);
    private static final VarType JAVA_NIO_BUFFER = new VarType(CodeType.OBJECT, 0, "java/nio/Buffer");
    private String name;
    private String classname;
    private boolean isStatic;
    private boolean canIgnoreBoxing = true;
    private Type functype = Type.GENERAL;
    private Exprent instance;
    private StructMethod desc = null;
    private MethodDescriptor descriptor;
    private String stringDescriptor;
    private String invokeDynamicClassSuffix;
    private InvocationType invocationType = InvocationType.VIRTUAL;
    private List<Exprent> lstParameters = new ArrayList<Exprent>();
    private LinkConstant bootstrapMethod;
    private List<PooledConstant> bootstrapArguments;
    private final List<VarType> genericArgs = new ArrayList<VarType>();
    private VarType remappedInstType = null;
    public boolean forceGenericQualfication = false;
    private final NullableConcurrentHashMap<VarType, VarType> genericsMap = new NullableConcurrentHashMap();
    private boolean isInvocationInstance = false;
    private boolean isQualifier = false;
    private final BoxState boxing = new BoxState();
    private boolean isSyntheticNullCheck = false;
    private boolean wasLazyCondy = false;
    private static final Map<String, String> UNBOXING_METHODS = new HashMap<String, String>();

    public InvocationExprent() {
        super(Exprent.Type.INVOCATION);
    }

    public InvocationExprent(int opcode, LinkConstant cn, LinkConstant bootstrapMethod, List<PooledConstant> bootstrapArguments, ListStack<? extends Exprent> stack, BitSet bytecodeOffsets) {
        this();
        this.name = cn.elementname;
        this.classname = cn.classname;
        this.bootstrapMethod = bootstrapMethod;
        this.bootstrapArguments = bootstrapArguments;
        switch (opcode) {
            case 184: {
                this.invocationType = InvocationType.STATIC;
                break;
            }
            case 183: {
                this.invocationType = InvocationType.SPECIAL;
                break;
            }
            case 182: {
                this.invocationType = InvocationType.VIRTUAL;
                break;
            }
            case 185: {
                this.invocationType = InvocationType.INTERFACE;
                break;
            }
            case 186: {
                this.invocationType = InvocationType.DYNAMIC;
                this.classname = bootstrapMethod.classname;
                this.invokeDynamicClassSuffix = "##Lambda_" + cn.index1 + "_" + cn.index2;
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                this.invocationType = InvocationType.CONSTANT_DYNAMIC;
                this.classname = bootstrapMethod.classname;
                this.invokeDynamicClassSuffix = "##Condy_" + cn.index1 + "_" + cn.index2;
            }
        }
        if ("<init>".equals(this.name)) {
            this.functype = Type.INIT;
        } else if ("<clinit>".equals(this.name)) {
            this.functype = Type.CLINIT;
        }
        this.stringDescriptor = cn.descriptor;
        if (this.invocationType == InvocationType.CONSTANT_DYNAMIC) {
            this.stringDescriptor = "()" + this.stringDescriptor;
        }
        this.descriptor = MethodDescriptor.parseDescriptor(this.stringDescriptor);
        for (VarType ignored : this.descriptor.params) {
            this.lstParameters.add(0, stack.pop());
        }
        if (opcode == 186 || this.invocationType == InvocationType.CONSTANT_DYNAMIC) {
            PooledConstant link;
            int dynamicInvocationType = bootstrapMethod.index1;
            if (bootstrapArguments != null && bootstrapArguments.size() > 1 && (link = bootstrapArguments.get(1)) instanceof LinkConstant) {
                dynamicInvocationType = ((LinkConstant)link).index1;
            }
            if (dynamicInvocationType == 6) {
                this.isStatic = true;
            } else if (!this.lstParameters.isEmpty()) {
                this.instance = this.lstParameters.get(0);
            }
        } else if (opcode == 184) {
            this.isStatic = true;
        } else {
            this.instance = stack.pop();
        }
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    protected InvocationExprent(InvocationExprent expr) {
        this();
        this.name = expr.getName();
        this.classname = expr.getClassname();
        this.isStatic = expr.isStatic();
        this.canIgnoreBoxing = expr.canIgnoreBoxing;
        this.functype = expr.getFunctype();
        this.instance = expr.getInstance();
        if (this.instance != null) {
            this.instance = this.instance.copy();
        }
        this.invocationType = expr.getInvocationType();
        this.invokeDynamicClassSuffix = expr.getInvokeDynamicClassSuffix();
        this.stringDescriptor = expr.getStringDescriptor();
        this.descriptor = expr.getDescriptor();
        this.lstParameters = new ArrayList<Exprent>(expr.getLstParameters());
        ExprProcessor.copyEntries(this.lstParameters);
        this.addBytecodeOffsets(expr.bytecode);
        this.bootstrapMethod = expr.getBootstrapMethod();
        this.bootstrapArguments = expr.getBootstrapArguments();
        this.isSyntheticNullCheck = expr.isSyntheticNullCheck();
        this.wasLazyCondy = expr.wasLazyCondy;
        if (this.invocationType == InvocationType.DYNAMIC && !this.isStatic && this.instance != null && !this.lstParameters.isEmpty()) {
            this.instance = this.lstParameters.get(0);
        }
    }

    @Override
    public VarType getExprType() {
        return this.descriptor.ret;
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        VarType inferred;
        VarType unboxed;
        FunctionExprent func;
        if (this.desc == null) {
            StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
            this.desc = cl != null ? cl.getMethodRecursive(this.name, this.stringDescriptor) : null;
        }
        this.genericArgs.clear();
        this.genericsMap.clear();
        this.remappedInstType = null;
        StructClass mthCls = DecompilerContext.getStructContext().getClass(this.classname);
        if (this.isUnboxingCall() && upperBound != null && this.instance instanceof FunctionExprent && (func = (FunctionExprent)this.instance).getFuncType() == FunctionExprent.FunctionType.CAST && ((unboxed = VarType.UNBOXING_TYPES.get(inferred = func.getLstOperands().get(0).getInferredExprType(upperBound))) == null || !unboxed.equals(upperBound)) && (inferred.typeFamily == TypeFamily.OBJECT || inferred.isGeneric())) {
            this.boxing.keepCast = true;
        }
        if (this.desc != null && mthCls != null) {
            boolean isGenNew;
            boolean isNew = this.functype == Type.INIT;
            boolean bl = isGenNew = isNew && mthCls.getSignature() != null;
            if (this.desc.getSignature() != null || isGenNew) {
                ClassesProcessor.ClassNode currentCls;
                StructClass cls;
                Map<String, Map<VarType, VarType>> hierarchy;
                Map<VarType, List<VarType>> named = this.getNamedGenerics();
                Map<VarType, List<VarType>> bounds = this.getGenericBounds(mthCls);
                List<String> fparams = isGenNew ? mthCls.getSignature().fparameters : this.desc.getSignature().typeParameters;
                VarType ret = isGenNew ? mthCls.getSignature().genericType : this.desc.getSignature().returnType;
                HashMap<VarType, VarType> tempMap = new HashMap<VarType, VarType>();
                HashMap<VarType, VarType> upperBoundsMap = new HashMap<VarType, VarType>();
                Map<Object, Object> hierarchyMap = new HashMap();
                if (!this.classname.equals(this.desc.getClassQualifiedName()) && (hierarchy = mthCls.getAllGenerics()).containsKey(this.desc.getClassQualifiedName())) {
                    hierarchyMap = hierarchy.get(this.desc.getClassQualifiedName());
                    hierarchyMap.forEach((from, to) -> {
                        if (to.type == CodeType.GENVAR) {
                            if (bounds.containsKey(to) && !bounds.containsKey(from)) {
                                bounds.put((VarType)from, (List)bounds.get(to));
                            }
                        } else if (!bounds.containsKey(from)) {
                            this.genericsMap.put((VarType)from, (VarType)to);
                        }
                    });
                }
                if (upperBound != null && !upperBound.equals(VarType.VARTYPE_OBJECT) && (upperBound.type != CodeType.GENVAR || named.containsKey(upperBound))) {
                    VarType ub = upperBound;
                    VarType r = ret;
                    if (ub.type != CodeType.GENVAR && r.type != CodeType.GENVAR && !ub.value.equals(r.value)) {
                        if (DecompilerContext.getStructContext().instanceOf(ub.value, r.value)) {
                            ub = GenericType.getGenericSuperType(ub, r);
                        } else {
                            r = GenericType.getGenericSuperType(r, ub);
                        }
                    }
                    if (r.type == CodeType.GENVAR && (upperBound.typeFamily == TypeFamily.OBJECT || upperBound.isGeneric())) {
                        upperBoundsMap.put(r.resizeArrayDim(0), upperBound.resizeArrayDim(upperBound.arrayDim - r.arrayDim));
                    } else {
                        this.gatherGenerics(ub, r, tempMap);
                        tempMap.forEach((from, to) -> {
                            if (!this.genericsMap.containsKey(from) && to != null && (to.type != CodeType.GENVAR || named.containsKey(to))) {
                                boolean ok = true;
                                if (to.type == CodeType.GENVAR && named.containsKey(from) && bounds.containsKey(from) && ((List)bounds.get(from)).contains(VarType.VARTYPE_OBJECT) && !bounds.containsKey(to) && !((List)named.get(to)).contains(from)) {
                                    ok = false;
                                }
                                if (ok && this.isMappingInBounds((VarType)from, (VarType)to, named, bounds, (Set<Pair<VarType, VarType>>)new HashSet<Pair<VarType, VarType>>())) {
                                    upperBoundsMap.put((VarType)from, (VarType)to);
                                }
                            }
                        });
                        tempMap.clear();
                    }
                }
                fparams.stream().map(p -> "T" + p + ";").map(GenericType::parse).filter(t -> !upperBoundsMap.containsKey(t)).forEach(t -> upperBoundsMap.put((VarType)t, GenericType.DUMMY_VAR));
                if (mthCls.getSignature() != null) {
                    mthCls.getSignature().fparameters.stream().map(p -> "T" + p + ";").map(GenericType::parse).filter(t -> !upperBoundsMap.containsKey(t)).forEach(t -> upperBoundsMap.put((VarType)t, GenericType.DUMMY_VAR));
                }
                VarType instType = null;
                if (this.instance != null && !isNew) {
                    this.instance.setInvocationInstance();
                    VarType instUB = mthCls.getSignature() != null ? mthCls.getSignature().genericType.remap(upperBoundsMap) : upperBound;
                    instType = this.instance instanceof FunctionExprent && ((FunctionExprent)this.instance).getFuncType() == FunctionExprent.FunctionType.CAST ? ((FunctionExprent)this.instance).getLstOperands().get(0).getInferredExprType(instUB) : this.instance.getInferredExprType(instUB);
                    if (instType.type == CodeType.GENVAR && named.containsKey(instType)) {
                        instType = named.get(instType).get(0);
                    }
                    if (instType.isGeneric() && instType.type != CodeType.GENVAR) {
                        GenericType ginstance = (GenericType)instType;
                        cls = DecompilerContext.getStructContext().getClass(instType.value);
                        if (cls != null && cls.getSignature() != null) {
                            cls.getSignature().genericType.mapGenVarsTo(ginstance, tempMap);
                            tempMap.forEach((from, to) -> {
                                if (!fparams.contains(from.value)) {
                                    this.processGenericMapping((VarType)from, (VarType)to, named, bounds);
                                }
                            });
                            tempMap.clear();
                        }
                    }
                }
                if (upperBound == null && isGenNew && (currentCls = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_NODE)) != null) {
                    if (mthCls.equals(currentCls.classStruct)) {
                        mthCls.getSignature().genericType.getAllGenericVars().forEach(var -> this.genericsMap.put((VarType)var, (VarType)var));
                    } else {
                        Map<String, Map<VarType, VarType>> hierarchy2 = currentCls.classStruct.getAllGenerics();
                        if (hierarchy2.containsKey(mthCls.qualifiedName)) {
                            hierarchy2.get(mthCls.qualifiedName).forEach(this.genericsMap::put);
                        }
                    }
                }
                if (!this.isInvocationInstance) {
                    upperBoundsMap.forEach((k, v) -> {
                        if (fparams.contains(k.value) && !GenericType.DUMMY_VAR.equals(v) && !this.genericsMap.containsKey(k)) {
                            this.genericsMap.put((VarType)k, (VarType)v);
                        }
                    });
                }
                HashSet<VarType> paramGenerics = new HashSet<VarType>();
                if (!this.lstParameters.isEmpty() && this.desc.getSignature() != null) {
                    List<VarVersionPair> mask = null;
                    int start = 0;
                    ClassesProcessor.ClassNode newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.classname);
                    if (newNode != null) {
                        if (isNew) {
                            mask = ExprUtil.getSyntheticParametersMask(newNode, this.stringDescriptor, this.lstParameters.size());
                            start = newNode.classStruct.hasModifier(16384) ? 2 : 0;
                        } else if (!newNode.enclosingClasses.isEmpty()) {
                            start = (newNode.access & 8) == 0 ? 1 : 0;
                        }
                    }
                    HashSet<VarType> hashSet = new HashSet<VarType>();
                    ClassesProcessor.ClassNode currentNode = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_NODE);
                    MethodWrapper methodWrapper = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_METHOD_WRAPPER);
                    if (methodWrapper != null) {
                        StructMethod currentMethod = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_METHOD_WRAPPER).methodStruct;
                        if (newNode != null && currentNode != null && !this.desc.hasModifier(8) && !currentMethod.hasModifier(8)) {
                            ArrayList<ClassesProcessor.ClassNode> parents = new ArrayList<ClassesProcessor.ClassNode>();
                            Object search = currentNode;
                            while (search != null) {
                                parents.add((ClassesProcessor.ClassNode)search);
                                search = (((ClassesProcessor.ClassNode)search).access & 8) == 0 ? ((ClassesProcessor.ClassNode)search).parent : null;
                            }
                            search = newNode;
                            while (search != null) {
                                if (parents.contains(search) && ((ClassesProcessor.ClassNode)search).classStruct.getSignature() != null) {
                                    hashSet.addAll(((ClassesProcessor.ClassNode)search).classStruct.getSignature().fparameters.stream().map(generic -> GenericType.parse("T" + generic + ";")).collect(Collectors.toList()));
                                }
                                search = (((ClassesProcessor.ClassNode)search).access & 8) == 0 ? ((ClassesProcessor.ClassNode)search).parent : null;
                            }
                        }
                    }
                    int j = 0;
                    for (int i = start; i < this.lstParameters.size(); ++i) {
                        NewExprent newExprent;
                        VarType paramType;
                        if (mask != null && mask.get(i) != null || this.desc.getSignature().parameterTypes.size() <= j || !(paramType = this.desc.getSignature().parameterTypes.get(j++)).isGeneric()) continue;
                        Exprent parameter = this.lstParameters.get(i);
                        HashSet excluded = new HashSet();
                        if (parameter.type == Exprent.Type.NEW && (newExprent = (NewExprent)parameter).isLambda()) {
                            StructClass base;
                            StructClass content;
                            ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(newExprent.getNewType().value);
                            int potentialMethodCount = Integer.MAX_VALUE;
                            if (node.lambdaInformation.is_method_reference && (content = DecompilerContext.getStructContext().getClass(node.lambdaInformation.content_class_name)) != null) {
                                StructClass currentCls2 = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS);
                                potentialMethodCount = (int)content.getMethods().stream().filter(method -> this.canAccess(currentCls2, (StructMethod)method)).map(StructMethod::getName).filter(node.lambdaInformation.content_method_name::equals).count();
                            }
                            if (potentialMethodCount > 1 && (base = DecompilerContext.getStructContext().getClass(newExprent.getExprType().value)) != null) {
                                StructMethod found = null;
                                for (StructMethod method2 : base.getMethods()) {
                                    if (method2.hasModifier(8) || method2.getInstructionSequence() != null) continue;
                                    found = method2;
                                    break;
                                }
                                if (found != null) {
                                    HashMap<VarType, VarType> genvars = new HashMap<VarType, VarType>();
                                    if (base.getSignature() != null && found.getSignature() != null) {
                                        base.getSignature().genericType.mapGenVarsTo((GenericType)paramType, genvars);
                                        excluded.addAll(found.getSignature().parameterTypes.stream().filter(VarType::isGeneric).map(GenericType.class::cast).map(GenericType::getAllGenericVars).flatMap(Collection::stream).map(genvars::get).filter(Objects::nonNull).filter(VarType::isGeneric).map(GenericType.class::cast).map(GenericType::getAllGenericVars).flatMap(Collection::stream).collect(Collectors.toList()));
                                    }
                                }
                            }
                        }
                        HashMap<VarType, VarType> combined = new HashMap<VarType, VarType>(this.genericsMap);
                        upperBoundsMap.forEach((k, v) -> {
                            if (!combined.containsKey(k)) {
                                combined.put((VarType)k, (VarType)v);
                            }
                        });
                        VarType paramUB = paramType.remap(hierarchyMap).remap(combined);
                        VarType argtype = parameter instanceof FunctionExprent && ((FunctionExprent)parameter).getFuncType() == FunctionExprent.FunctionType.CAST ? ((FunctionExprent)parameter).getLstOperands().get(0).getInferredExprType(paramUB) : parameter.getInferredExprType(paramUB);
                        if (paramUB == null && argtype != null && instType instanceof GenericType && combined.containsKey(paramType) && combined.get(paramType) == null && !VarType.VARTYPE_NULL.equals(argtype)) {
                            combined.put(paramType, argtype);
                            GenericType baseType = ((GenericType)instType).findBaseType();
                            if (baseType != null) {
                                this.remappedInstType = baseType.remap(hierarchyMap).remap(combined);
                            }
                        }
                        StructClass paramCls = DecompilerContext.getStructContext().getClass(paramType.value);
                        StructClass structClass = cls = argtype.type != CodeType.GENVAR ? DecompilerContext.getStructContext().getClass(argtype.value) : null;
                        if (cls != null && paramCls != null) {
                            if (paramType.isGeneric() && !paramType.value.equals(argtype.value)) {
                                argtype = GenericType.getGenericSuperType(argtype, paramType);
                            }
                            if (!paramType.isGeneric() || !argtype.isGeneric()) continue;
                            GenericType genParamType = (GenericType)paramType;
                            GenericType genArgType = (GenericType)argtype;
                            genParamType.mapGenVarsTo(genArgType, tempMap);
                            GenericType.cleanLoweredGenericTypes(tempMap, genParamType, genArgType, hashSet);
                            tempMap.forEach((from, to) -> {
                                if (!excluded.contains(from)) {
                                    paramGenerics.add((VarType)from);
                                }
                                if (!this.processGenericMapping((VarType)from, (VarType)to, named, bounds)) {
                                    VarType current = this.genericsMap.get(from);
                                    if (to != null && current != null && !current.isGeneric() && !to.isGeneric()) {
                                        this.putGenericMapping((VarType)from, (VarType)to, named, bounds);
                                    }
                                }
                            });
                            tempMap.clear();
                            continue;
                        }
                        if (paramType.type != CodeType.GENVAR || paramType.equals(argtype) || argtype.arrayDim < paramType.arrayDim) continue;
                        if (paramType.arrayDim > 0) {
                            argtype = argtype.resizeArrayDim(argtype.arrayDim - paramType.arrayDim);
                            paramType = paramType.resizeArrayDim(0);
                        }
                        if (!excluded.contains(paramType)) {
                            paramGenerics.add(paramType);
                        }
                        this.processGenericMapping(paramType, argtype, named, bounds);
                    }
                }
                upperBoundsMap.forEach((k, v) -> {
                    if (fparams.contains(k.value) && !GenericType.DUMMY_VAR.equals(v)) {
                        VarType current = this.genericsMap.get(k);
                        if (!(current == null || v == null || current.isGeneric() || v.isGeneric() || DecompilerContext.getStructContext().instanceOf(current.value, v.value))) {
                            return;
                        }
                        this.processGenericMapping((VarType)k, (VarType)v, named, bounds);
                    }
                });
                if (!this.genericsMap.isEmpty()) {
                    VarType newRet = ret.remap(hierarchyMap);
                    boolean skipArgs = true;
                    if (!fparams.isEmpty() && newRet.isGeneric()) {
                        for (VarType varType : ((GenericType)newRet).getAllGenericVars()) {
                            if (!fparams.contains(varType.value)) continue;
                            skipArgs = false;
                            break;
                        }
                    }
                    if ((newRet = newRet.remap(this.genericsMap)) == null && bounds.get(ret) != null && bounds.get(ret).size() > 0) {
                        newRet = bounds.get(ret).get(0).remap(this.genericsMap);
                    }
                    if (!(skipArgs || isNew && !isGenNew)) {
                        boolean bl2;
                        boolean bl3;
                        boolean missing = paramGenerics.isEmpty();
                        if (!missing) {
                            for (String param : fparams) {
                                if (paramGenerics.contains(GenericType.parse("T" + param + ";"))) continue;
                                missing = true;
                                break;
                            }
                        }
                        boolean bl4 = bl3 = !(missing && this.isInvocationInstance || newRet == null || upperBound != null && newRet.isGeneric() && !DecompilerContext.getStructContext().instanceOf(newRet.value, upperBound.value));
                        if (this.forceGenericQualfication) {
                            bl2 = false;
                        }
                        if (!bl2 || DecompilerContext.getOption("explicit-generics")) {
                            this.getGenericArgs(fparams, this.genericsMap, this.genericArgs);
                        } else if (isGenNew) {
                            this.genericArgs.add(GenericType.DUMMY_VAR);
                        }
                    }
                    if (!(newRet == ret || newRet == null || newRet.isGeneric() && ((GenericType)newRet).hasUnknownGenericType(named.keySet()))) {
                        return newRet;
                    }
                }
                if (ret.isGeneric() && ((GenericType)ret).getAllGenericVars().isEmpty()) {
                    return ret;
                }
            }
        }
        return this.getExprType();
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        if (this.instance != null) {
            result.addMinTypeExprent(this.instance, VarType.getMinTypeInFamily(this.instance.getExprType().typeFamily));
            result.addMaxTypeExprent(this.instance, this.instance.getExprType());
        }
        for (int i = 0; i < this.lstParameters.size(); ++i) {
            Exprent parameter = this.lstParameters.get(i);
            VarType leftType = this.descriptor.params[i];
            result.addMinTypeExprent(parameter, VarType.getMinTypeInFamily(leftType.typeFamily));
            result.addMaxTypeExprent(parameter, leftType);
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        if (this.instance != null) {
            lst.add(this.instance);
        }
        lst.addAll(this.lstParameters);
        return lst;
    }

    @Override
    public Exprent copy() {
        return new InvocationExprent(this);
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buf = new TextBuffer();
        if (this.wasLazyCondy) {
            buf.append("/* $VF: constant dynamic replaced with non-lazy method call */ ");
        }
        String super_qualifier = null;
        boolean isInstanceThis = false;
        if (this.instance instanceof InvocationExprent) {
            ((InvocationExprent)this.instance).markUsingBoxingResult();
        }
        boolean pushedCallChainGroup = false;
        if (this.isStatic || this.invocationType == InvocationType.DYNAMIC || this.invocationType == InvocationType.CONSTANT_DYNAMIC) {
            ClassesProcessor.ClassNode node;
            if (this.isBoxingCall() && this.canIgnoreBoxing && !this.boxing.forceBoxing) {
                ExprProcessor.getCastedExprent(this.lstParameters.get(0), this.descriptor.params[0], buf, indent, ExprProcessor.NullCastType.DONT_CAST, false, true, false);
                buf.addBytecodeMapping(this.bytecode);
                return buf;
            }
            if (this.invocationType == InvocationType.CONSTANT_DYNAMIC) {
                buf.append('(').appendCastTypeName(this.descriptor.ret).append(')');
            }
            if ((node = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_NODE)) == null || !this.classname.equals(node.classStruct.qualifiedName)) {
                buf.appendAllClasses(DecompilerContext.getImportCollector().getShortNameInClassContext(ExprProcessor.buildJavaClassName(this.classname)), this.classname);
            }
        } else {
            if (this.instance instanceof VarExprent) {
                MethodWrapper currentMethod;
                VarExprent instVar = (VarExprent)this.instance;
                VarVersionPair varPair = new VarVersionPair(instVar);
                VarProcessor varProc = instVar.getProcessor();
                if (varProc == null && (currentMethod = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_METHOD_WRAPPER)) != null) {
                    varProc = currentMethod.varproc;
                }
                String this_classname = null;
                if (varProc != null) {
                    this_classname = varProc.getThisVars().get(varPair);
                }
                if (this_classname != null) {
                    isInstanceThis = true;
                    if (this.invocationType == InvocationType.SPECIAL && !this.classname.equals(this_classname)) {
                        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
                        boolean isInterface = cl != null && cl.hasModifier(512);
                        String string = super_qualifier = !isInterface ? this_classname : this.classname;
                    }
                }
            }
            if (CodeConstants.isReturnPolymorphic(this.classname, this.name) && !this.descriptor.ret.equals(VarType.VARTYPE_VOID)) {
                buf.append('(').appendCastTypeName(this.descriptor.ret).append(')');
            }
            if (this.functype == Type.GENERAL) {
                if (super_qualifier != null) {
                    TextUtil.writeQualifiedSuper(buf, super_qualifier);
                } else if (this.instance != null) {
                    VarType _new;
                    StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
                    VarType leftType = new VarType(CodeType.OBJECT, 0, this.classname);
                    if (!this.genericsMap.isEmpty() && cl != null && cl.getSignature() != null && (_new = cl.getSignature().genericType.remap(this.genericsMap)) != cl.getSignature().genericType) {
                        leftType = _new;
                    }
                    this.instance.setInvocationInstance();
                    VarType rightType = this.instance.getInferredExprType(leftType);
                    if (this.isUnboxingCall() && !this.boxing.forceUnboxing) {
                        FunctionExprent func;
                        buf.addBytecodeMapping(this.bytecode);
                        if (this.instance instanceof FunctionExprent && (func = (FunctionExprent)this.instance).getFuncType() == FunctionExprent.FunctionType.CAST && func.getLstOperands().get(1) instanceof ConstExprent && !this.boxing.keepCast) {
                            ConstExprent constexpr = (ConstExprent)func.getLstOperands().get(1);
                            boolean skipCast = false;
                            Exprent firstParam = func.getLstOperands().get(0);
                            if (firstParam instanceof VarExprent || firstParam instanceof FieldExprent) {
                                VarType inferred = firstParam.getInferredExprType(leftType);
                                skipCast = inferred.type != CodeType.OBJECT && inferred.type != CodeType.GENVAR || DecompilerContext.getStructContext().instanceOf(inferred.value, this.classname);
                            } else if (this.classname.equals(constexpr.getConstType().value)) {
                                skipCast = true;
                            }
                            if (skipCast) {
                                buf.append(firstParam.toJava(indent));
                                return buf;
                            }
                        }
                        buf.append(this.instance.toJava(indent));
                        return buf;
                    }
                    this.instance.setIsQualifier();
                    if (!this.isQualifier) {
                        buf.pushNewlineGroup(indent, 1);
                        pushedCallChainGroup = true;
                    }
                    TextBuffer res = this.instance.toJava(indent);
                    ClassesProcessor.ClassNode instNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.classname);
                    if (rightType.equals(VarType.VARTYPE_OBJECT) && !leftType.equals(rightType) && instNode != null && instNode.type != ClassesProcessor.ClassNode.Type.ANONYMOUS) {
                        this.appendInstCast(buf, leftType, res);
                    } else if (this.remappedInstType != null) {
                        this.appendInstCast(buf, this.remappedInstType, res);
                    } else if (this.instance.getPrecedence() > this.getPrecedence() && !this.canSkipParenEnclose(this.instance)) {
                        buf.append("(").append(res).append(")");
                    } else if (JAVA_NIO_BUFFER.equals(this.descriptor.ret) && !JAVA_NIO_BUFFER.equals(rightType) && DecompilerContext.getStructContext().instanceOf(rightType.value, InvocationExprent.JAVA_NIO_BUFFER.value)) {
                        buf.append("((").appendCastTypeName(JAVA_NIO_BUFFER).append(")").append(res).append(")");
                    } else {
                        buf.append(res);
                    }
                    if (this.instance.allowNewlineAfterQualifier()) {
                        buf.appendPossibleNewline();
                    }
                }
            }
        }
        switch (this.functype) {
            case GENERAL: {
                if (buf.contentEquals("<VAR_NAMELESS_ENCLOSURE>")) {
                    buf.setLength(0);
                }
                if (buf.length() > 0) {
                    buf.append(".");
                    this.appendParameters(buf, this.genericArgs);
                }
                buf.addBytecodeMapping(this.bytecode);
                if (this.invocationType == InvocationType.DYNAMIC || this.invocationType == InvocationType.CONSTANT_DYNAMIC) {
                    if (this.bootstrapMethod == null) {
                        buf.append("<").appendMethod(this.name, false, this.classname, this.name, this.descriptor);
                        if (this.invocationType == InvocationType.DYNAMIC) {
                            buf.append(">invokedynamic");
                        } else {
                            buf.append(">ldc");
                        }
                    } else {
                        buf.append(this.bootstrapMethod.elementname);
                        buf.append("<\"").appendMethod(this.name, false, this.classname, this.name, this.descriptor).append('\"');
                        for (PooledConstant arg : this.bootstrapArguments) {
                            buf.append(',');
                            InvocationExprent.appendBootstrapArgument(buf, arg);
                        }
                        buf.append('>');
                    }
                } else {
                    buf.appendMethod(this.name, false, this.classname, this.name, this.descriptor);
                }
                buf.append("(");
                break;
            }
            case CLINIT: {
                throw new RuntimeException("Explicit invocation of <clinit>");
            }
            case INIT: {
                buf.addBytecodeMapping(this.bytecode);
                if (super_qualifier != null) {
                    buf.append("super(");
                    break;
                }
                if (isInstanceThis) {
                    buf.append("this(");
                    break;
                }
                if (this.instance != null) {
                    Object s = ".";
                    if (DecompilerContext.getOption("decompiler-comments")) {
                        s = (String)s + "/* $VF: Unable to resugar constructor */";
                    }
                    s = (String)s + "<init>(";
                    buf.append(this.instance.toJava(indent)).append((String)s);
                    break;
                }
                throw new RuntimeException("Unrecognized invocation of <init>");
            }
        }
        buf.append(this.appendParamList(indent)).append(')');
        if (pushedCallChainGroup) {
            buf.popNewlineGroup();
        }
        return buf;
    }

    private void appendInstCast(TextBuffer buf, VarType leftType, TextBuffer res) {
        buf.append("((").appendCastTypeName(leftType).append(")");
        if (this.instance.getPrecedence() >= FunctionExprent.FunctionType.CAST.precedence) {
            res.encloseWithParens();
        }
        buf.append(res).append(")");
    }

    private boolean canSkipParenEnclose(Exprent instance) {
        if (!(instance instanceof NewExprent)) {
            return false;
        }
        NewExprent newExpr = (NewExprent)instance;
        if (!(newExpr.isAnonymous() || newExpr.isLambda() || newExpr.isMethodReference())) {
            return this.functype == Type.GENERAL;
        }
        return false;
    }

    private static void appendBootstrapArgument(TextBuffer buf, PooledConstant arg) {
        if (arg instanceof PrimitiveConstant) {
            PrimitiveConstant prim = (PrimitiveConstant)arg;
            Object value = prim.value;
            String stringValue = String.valueOf(value);
            if (prim.type == 7) {
                buf.appendCastTypeName(new VarType(stringValue));
            } else if (prim.type == 8) {
                buf.append('\"').append(ConstExprent.convertStringToJava(stringValue, false)).append('\"');
            } else {
                buf.append(stringValue);
            }
        } else if (arg instanceof LinkConstant) {
            VarType cls = new VarType(((LinkConstant)arg).classname);
            buf.appendCastTypeName(cls).append("::").append(((LinkConstant)arg).elementname);
        }
    }

    public TextBuffer appendParamList(int indent) {
        Exprent lastParam;
        ClassesProcessor.ClassNode newNode;
        List<VarVersionPair> mask = null;
        boolean isEnum = false;
        if (this.functype == Type.INIT && (newNode = DecompilerContext.getClassProcessor().getMapRootClasses().get(this.classname)) != null) {
            mask = ExprUtil.getSyntheticParametersMask(newNode, this.stringDescriptor, this.lstParameters.size());
            isEnum = newNode.classStruct.hasModifier(16384) && DecompilerContext.getOption("decompile-enums");
        }
        ClassesProcessor.ClassNode currCls = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_NODE);
        List<StructMethod> matches = this.getMatchedDescriptors();
        BitSet setAmbiguousParameters = this.getAmbiguousParameters(matches);
        if (this.lstParameters.size() == this.descriptor.params.length && this.isVarArgCall() && !this.lstParameters.isEmpty() && (lastParam = this.lstParameters.get(this.lstParameters.size() - 1)) instanceof NewExprent && lastParam.getExprType().arrayDim >= 1) {
            ((NewExprent)lastParam).setVarArgParam(true);
        }
        int start = isEnum ? 2 : 0;
        ArrayList<Exprent> parameters = new ArrayList<Exprent>(this.lstParameters);
        VarType[] types = Arrays.copyOf(this.descriptor.params, this.descriptor.params.length);
        block0: for (int i = start; i < parameters.size(); ++i) {
            StructClass stClass;
            Exprent par = (Exprent)parameters.get(i);
            if (!(par instanceof InvocationExprent)) continue;
            InvocationExprent inv = (InvocationExprent)par;
            if (inv.isBoxingCall()) {
                Exprent value = inv.lstParameters.get(0);
                types[i] = value.getExprType();
                if (types[i].typeFamily == TypeFamily.INTEGER) {
                    types[i] = "java/lang/Short".equals(inv.classname) ? VarType.VARTYPE_SHORT : ("java/lang/Byte".equals(inv.classname) ? VarType.VARTYPE_BYTE : ("java/lang/Integer".equals(inv.classname) ? VarType.VARTYPE_INT : VarType.VARTYPE_CHAR));
                }
                int count = 0;
                StructClass stClass2 = DecompilerContext.getStructContext().getClass(this.classname);
                if (stClass2 != null) {
                    List<StructMethod> customMatchedDescriptors = this.getMatchedDescriptors(md -> {
                        if (md.params.length == this.descriptor.params.length) {
                            for (int x = 0; x < md.params.length; ++x) {
                                if (md.params[x].typeFamily != this.descriptor.params[x].typeFamily && md.params[x].typeFamily != types[x].typeFamily) {
                                    return false;
                                }
                                if (md.params[x].arrayDim == this.descriptor.params[x].arrayDim || md.params[x].arrayDim == types[x].arrayDim) continue;
                                return false;
                            }
                            return true;
                        }
                        return false;
                    });
                    count = customMatchedDescriptors.size();
                }
                if (count != matches.size()) {
                    types[i] = this.descriptor.params[i];
                    inv.boxing.forceBoxing = true;
                    continue;
                }
                value.addBytecodeOffsets(inv.bytecode);
                parameters.set(i, value);
                continue;
            }
            if (!inv.isUnboxingCall() || inv.shouldForceUnboxing() || (stClass = DecompilerContext.getStructContext().getClass(this.classname)) == null) continue;
            for (StructMethod mt : stClass.getMethods()) {
                if (!this.name.equals(mt.getName()) || currCls != null && !this.canAccess(currCls.classStruct, mt) || this.stringDescriptor.equals(mt.getDescriptor())) continue;
                MethodDescriptor md2 = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                if (md2.params.length != this.descriptor.params.length || md2.params[i].type != CodeType.OBJECT || !DecompilerContext.getStructContext().instanceOf(inv.getInstance().getExprType().value, md2.params[i].value)) continue;
                inv.forceUnboxing(true);
                continue block0;
            }
        }
        if (this.desc == null) {
            VarType instType;
            this.getInferredExprType(null);
            if (this.genericsMap.isEmpty() && this.instance != null && this.functype != Type.INIT && (instType = this.instance.getInferredExprType(null)).isGeneric() && instType.type != CodeType.GENVAR) {
                GenericType ginstance = (GenericType)instType;
                StructClass cls = DecompilerContext.getStructContext().getClass(instType.value);
                if (cls != null && cls.getSignature() != null) {
                    cls.getSignature().genericType.mapGenVarsTo(ginstance, this.genericsMap);
                }
            }
        }
        if (this.desc != null && this.desc.getSignature() != null) {
            Map<String, Map<VarType, VarType>> hierarchy;
            StructClass mthCls;
            HashMap<VarType, VarType> hierarchyMap = new HashMap();
            if (!this.classname.equals(this.desc.getClassQualifiedName()) && (mthCls = DecompilerContext.getStructContext().getClass(this.classname)) != null && (hierarchy = mthCls.getAllGenerics()).containsKey(this.desc.getClassQualifiedName())) {
                hierarchyMap = hierarchy.get(this.desc.getClassQualifiedName());
            }
            Set<VarType> namedGens = this.getNamedGenerics().keySet();
            int y = 0;
            for (int x = start; x < types.length; ++x) {
                VarType type;
                if (mask != null && mask.get(x) != null || this.desc.getSignature().parameterTypes.size() <= y || (type = this.desc.getSignature().parameterTypes.get(y++).remap(hierarchyMap).remap(this.genericsMap)) == null || type.isGeneric() && ((GenericType)type).hasUnknownGenericType(namedGens)) continue;
                types[x] = type;
            }
        }
        TextBuffer buf = new TextBuffer();
        boolean firstParameter = true;
        if (!this.lstParameters.isEmpty()) {
            buf.pushNewlineGroup(indent, 1);
            buf.appendPossibleNewline();
            buf.pushNewlineGroup(indent, 0);
        }
        for (int i = start; i < this.lstParameters.size(); ++i) {
            if (mask != null && mask.get(i) != null) continue;
            TextBuffer buff = new TextBuffer();
            boolean ambiguous = setAmbiguousParameters.get(i);
            if (i == parameters.size() - 1 && this.lstParameters.get(i).getExprType() == VarType.VARTYPE_NULL && NewExprent.probablySyntheticParameter(this.descriptor.params[i].value)) break;
            ExprProcessor.getCastedExprent(this.lstParameters.get(i), types[i], buff, indent, ambiguous ? ExprProcessor.NullCastType.CAST : ExprProcessor.NullCastType.DONT_CAST_AT_ALL, ambiguous, true, true);
            if (buff.length() > 0) {
                if (!firstParameter) {
                    buf.append(",").appendPossibleNewline(" ");
                }
                buf.append(buff);
            }
            firstParameter = false;
        }
        if (!this.lstParameters.isEmpty()) {
            buf.popNewlineGroup();
            buf.appendPossibleNewline("", true);
            buf.popNewlineGroup();
        }
        return buf;
    }

    private boolean isVarArgCall() {
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        if (cl != null) {
            StructMethod mt = cl.getMethod(InterpreterUtil.makeUniqueKey(this.name, this.stringDescriptor));
            if (mt == null) {
                mt = cl.getMethodRecursive(this.name, this.stringDescriptor);
            }
            if (mt != null) {
                return mt.hasModifier(128);
            }
        } else {
            Method mtd = ClasspathHelper.findMethod(this.classname, this.name, this.descriptor);
            return mtd != null && mtd.isVarArgs();
        }
        return false;
    }

    public boolean isBoxingCall() {
        if (this.isStatic && "valueOf".equals(this.name) && this.lstParameters.size() == 1) {
            CodeType paramType = this.lstParameters.get((int)0).getExprType().type;
            if (this.lstParameters.get(0) instanceof ConstExprent) {
                if (this.lstParameters.get((int)0).getExprType().typeFamily == TypeFamily.INTEGER && this.classname.equals("java/lang/Integer")) {
                    return true;
                }
                if ((paramType == CodeType.BYTECHAR || paramType == CodeType.SHORTCHAR) && (this.classname.equals("java/lang/Character") || this.classname.equals("java/lang/Short"))) {
                    return true;
                }
            }
            return this.classname.equals(InvocationExprent.getClassNameForPrimitiveType(paramType));
        }
        return false;
    }

    public void markUsingBoxingResult() {
        this.canIgnoreBoxing = false;
    }

    @Override
    public void setIsQualifier() {
        this.isQualifier = true;
    }

    private static String getClassNameForPrimitiveType(CodeType type) {
        switch (type) {
            case BOOLEAN: {
                return "java/lang/Boolean";
            }
            case BYTE: 
            case BYTECHAR: {
                return "java/lang/Byte";
            }
            case CHAR: {
                return "java/lang/Character";
            }
            case SHORT: 
            case SHORTCHAR: {
                return "java/lang/Short";
            }
            case INT: {
                return "java/lang/Integer";
            }
            case LONG: {
                return "java/lang/Long";
            }
            case FLOAT: {
                return "java/lang/Float";
            }
            case DOUBLE: {
                return "java/lang/Double";
            }
        }
        return null;
    }

    public boolean isUnboxingCall() {
        return !this.isStatic && this.lstParameters.isEmpty() && this.classname.equals(UNBOXING_METHODS.get(this.name));
    }

    public void forceBoxing(boolean value) {
        this.boxing.forceBoxing = value;
    }

    public boolean shouldForceBoxing() {
        return this.boxing.forceBoxing;
    }

    public void forceUnboxing(boolean value) {
        this.boxing.forceUnboxing = value;
    }

    public boolean shouldForceUnboxing() {
        return this.boxing.forceUnboxing;
    }

    private List<StructMethod> getMatchedDescriptors() {
        return this.getMatchedDescriptors(null);
    }

    private List<StructMethod> getMatchedDescriptors(@Nullable Predicate<MethodDescriptor> customParamMatcher) {
        ArrayList<StructMethod> matches = new ArrayList<StructMethod>();
        ClassesProcessor.ClassNode currCls = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_NODE);
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        if (cl == null) {
            return matches;
        }
        HashSet<String> visited = new HashSet<String>();
        ArrayDeque<StructClass> que = new ArrayDeque<StructClass>();
        que.add(cl);
        while (!que.isEmpty()) {
            StructClass tmp;
            StructClass cls = (StructClass)que.poll();
            if (cls == null) continue;
            for (StructMethod mt : cls.getMethods()) {
                if (!this.name.equals(mt.getName())) continue;
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                boolean matchedParams = customParamMatcher == null ? this.matches(md.params, this.descriptor.params) : customParamMatcher.test(md);
                if (!matchedParams || currCls != null && !this.canAccess(currCls.classStruct, mt)) continue;
                matches.add(mt);
            }
            if (cls == cl && !matches.isEmpty()) {
                return matches;
            }
            visited.add(cls.qualifiedName);
            if (cls.superClass != null && !visited.contains(cls.superClass.value) && (tmp = DecompilerContext.getStructContext().getClass((String)cls.superClass.value)) != null) {
                que.add(tmp);
            }
            for (String intf : cls.getInterfaceNames()) {
                StructClass tmp2;
                if (visited.contains(intf) || (tmp2 = DecompilerContext.getStructContext().getClass(intf)) == null) continue;
                que.add(tmp2);
            }
        }
        return matches;
    }

    private boolean matches(VarType[] left, VarType[] right) {
        if (left.length == right.length) {
            for (int i = 0; i < left.length; ++i) {
                TypeFamily leftFamily = left[i].typeFamily;
                TypeFamily rightFamily = right[i].typeFamily;
                if (!(leftFamily == rightFamily || leftFamily.isNumeric() && rightFamily.isNumeric())) {
                    return false;
                }
                if (left[i].arrayDim == right[i].arrayDim) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean canAccess(StructClass currCls, StructMethod mt) {
        if (mt.hasModifier(1)) {
            return true;
        }
        if (mt.hasModifier(2)) {
            return mt.getClassQualifiedName().equals(currCls.qualifiedName);
        }
        if (mt.hasModifier(4)) {
            boolean samePackage = this.isInSamePackage(currCls.qualifiedName, mt.getClassQualifiedName());
            return samePackage || DecompilerContext.getStructContext().instanceOf(currCls.qualifiedName, mt.getClassQualifiedName());
        }
        return this.isInSamePackage(currCls.qualifiedName, mt.getClassQualifiedName());
    }

    private boolean isInSamePackage(String class1, String class2) {
        int pos2;
        int pos1 = class1.lastIndexOf(47);
        if (pos1 != (pos2 = class2.lastIndexOf(47))) {
            return false;
        }
        if (pos1 == -1) {
            return true;
        }
        String pkg1 = class1.substring(0, pos1);
        String pkg2 = class2.substring(0, pos2);
        return pkg1.equals(pkg2);
    }

    private BitSet getAmbiguousParameters(List<StructMethod> matches) {
        int i;
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        if (cl == null || matches.size() == 1) {
            return EMPTY_BIT_SET;
        }
        BitSet missed = new BitSet(this.lstParameters.size());
        if (CodeConstants.areParametersPolymorphic(this.classname, this.name)) {
            missed.set(0, this.lstParameters.size());
            return missed;
        }
        StructMethod mt = cl.getMethod(InterpreterUtil.makeUniqueKey(this.name, this.stringDescriptor));
        if (mt != null) {
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            if (md.params.length == this.lstParameters.size()) {
                boolean exact = true;
                for (i = 0; i < md.params.length; ++i) {
                    Exprent exp = this.lstParameters.get(i);
                    if (exp instanceof FunctionExprent && ((FunctionExprent)exp).getSimpleCastType() != null) {
                        ((FunctionExprent)exp).setNeedsCast(true);
                    }
                    if (i == md.params.length - 1 && mt.hasModifier(128) && exp instanceof NewExprent) {
                        NewExprent newE = (NewExprent)exp;
                        if (newE.getExprType().arrayDim > 0) {
                            for (Exprent entry : newE.getLstArrayElements()) {
                                FunctionExprent func;
                                if (!(entry instanceof FunctionExprent) || (func = (FunctionExprent)entry).getSimpleCastType() == null) continue;
                                func.setNeedsCast(true);
                            }
                        }
                    }
                    if ((md.params[i].equals(exp.getExprType()) || this.isSuperset(md, i, exp)) && (!(exp instanceof NewExprent) || !((NewExprent)exp).isLambda() || ((NewExprent)exp).isMethodReference())) continue;
                    exact = false;
                    missed.set(i);
                }
                if (exact) {
                    return EMPTY_BIT_SET;
                }
            }
        }
        ArrayList<StructMethod> mtds = new ArrayList<StructMethod>();
        for (StructMethod mtt : matches) {
            boolean failed = false;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mtt.getDescriptor());
            for (int i2 = 0; i2 < this.lstParameters.size(); ++i2) {
                NewExprent newExp;
                Exprent exp = this.lstParameters.get(i2);
                VarType ptype = exp.getExprType();
                if (!missed.get(i2)) {
                    if (md.params[i2].equals(ptype)) continue;
                    failed = true;
                    break;
                }
                if (exp instanceof NewExprent && (newExp = (NewExprent)exp).isLambda() && !newExp.isMethodReference() && !DecompilerContext.getStructContext().instanceOf(md.params[i2].value, exp.getExprType().value)) {
                    StructClass pcls = DecompilerContext.getStructContext().getClass(md.params[i2].value);
                    if (pcls == null || pcls.getMethod(newExp.getLambdaMethodKey()) != null) continue;
                    failed = true;
                    break;
                }
                if (md.params[i2].type != CodeType.OBJECT || ptype.type == CodeType.NULL || DecompilerContext.getStructContext().instanceOf(ptype.value, md.params[i2].value)) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            mtds.add(mtt);
        }
        BitSet ambiguous = new BitSet(this.descriptor.params.length);
        block4: for (i = 0; i < this.descriptor.params.length; ++i) {
            Exprent exp;
            StructMethod mtt;
            GenericMethodDescriptor gen;
            VarType paramType = this.descriptor.params[i];
            Iterator iterator = mtds.iterator();
            while (iterator.hasNext() && ((gen = (mtt = (StructMethod)iterator.next()).getSignature()) == null || gen.parameterTypes.size() <= i || !gen.parameterTypes.get(i).isGeneric() || (exp = this.lstParameters.get(i)) instanceof NewExprent && ((NewExprent)exp).isLambda() && !((NewExprent)exp).isMethodReference())) {
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mtt.getDescriptor());
                if (paramType.equals(md.params[i])) continue;
                ambiguous.set(i);
                continue block4;
            }
        }
        return ambiguous;
    }

    private boolean isSuperset(MethodDescriptor md, int i, Exprent exp) {
        if (this.shouldBeAmbiguous(md.params[i], exp)) {
            return false;
        }
        return md.params[i].isSuperset(exp.getExprType());
    }

    private boolean shouldBeAmbiguous(VarType param, Exprent exp) {
        if (exp instanceof VarExprent) {
            if (exp.getExprType().typeFamily == TypeFamily.INTEGER && param.typeFamily == TypeFamily.INTEGER) {
                return !param.equals(exp.getExprType());
            }
            if (param.equals(VarType.VARTYPE_OBJECT) && param.arrayDim == 0 && exp.getExprType().typeFamily == TypeFamily.OBJECT) {
                return true;
            }
        }
        return false;
    }

    private boolean processGenericMapping(VarType from, VarType to, Map<VarType, List<VarType>> named, Map<VarType, List<VarType>> bounds) {
        if (VarType.VARTYPE_NULL.equals(to) || to != null && to.type == CodeType.GENVAR && !named.containsKey(to)) {
            return false;
        }
        VarType current = this.genericsMap.get(from);
        if (!this.genericsMap.containsKey(from)) {
            this.putGenericMapping(from, to, named, bounds);
            return true;
        }
        if (to != null && current != null && !to.equals(current)) {
            VarType bound;
            if (named.containsKey(current)) {
                return false;
            }
            if (current.type != CodeType.GENVAR && to.type == CodeType.GENVAR && named.containsKey(to) && !(bound = named.get(to).get(0)).equals(VarType.VARTYPE_OBJECT) && DecompilerContext.getStructContext().instanceOf(bound.value, current.value)) {
                return false;
            }
            if (to.isGeneric() && current.isGeneric() && GenericType.isAssignable(to, current, named)) {
                this.putGenericMapping(from, to, named, bounds);
                return true;
            }
        }
        return false;
    }

    private void putGenericMapping(VarType from, VarType to, Map<VarType, List<VarType>> named, Map<VarType, List<VarType>> bounds) {
        if (this.isMappingInBounds(from, to, named, bounds, new HashSet<Pair<VarType, VarType>>())) {
            this.genericsMap.put(from, to);
        }
    }

    private boolean isMappingInBounds(VarType from, VarType to, Map<VarType, List<VarType>> named, Map<VarType, List<VarType>> bounds, Set<Pair<VarType, VarType>> recursivelySeen) {
        if (!bounds.containsKey(from)) {
            return false;
        }
        if (to == null || to.type == CodeType.GENVAR && !named.containsKey(to)) {
            return true;
        }
        BiFunction<VarType, VarType, Boolean> verifier = (newTo, bound) -> {
            if (bound.type == CodeType.GENVAR) {
                Pair<VarType, VarType> pair;
                Function<VarType, VarType> map = e -> {
                    VarType mapped = this.genericsMap.get(e);
                    if (mapped == null) {
                        mapped = named.containsKey(e) ? (VarType)((List)named.get(e)).get(0) : null;
                    }
                    return mapped;
                };
                VarType mapped = map.apply((VarType)bound);
                if (mapped != null && !mapped.equals(bound)) {
                    VarType last = bound;
                    while (bound != null && !(last = bound).equals(bound = map.apply((VarType)bound))) {
                    }
                    bound = last;
                    if (bound.type != CodeType.GENVAR) {
                        return DecompilerContext.getStructContext().instanceOf(newTo.value, bound.value);
                    }
                }
                if (!recursivelySeen.contains(pair = Pair.of(bound, newTo))) {
                    recursivelySeen.add(pair);
                    return this.isMappingInBounds((VarType)bound, (VarType)newTo, named, bounds, recursivelySeen);
                }
            }
            if (newTo.type.ordinal() < CodeType.OBJECT.ordinal()) {
                return bound.equals(VarType.VARTYPE_OBJECT) || bound.equals(newTo);
            }
            if (newTo.type != CodeType.GENVAR && !DecompilerContext.getStructContext().instanceOf(newTo.value, bound.value)) {
                return false;
            }
            if (bound.isGeneric() && !((GenericType)bound).getArguments().isEmpty()) {
                GenericType genbound = (GenericType)bound;
                VarType _new = newTo;
                if (!newTo.value.equals(bound.value)) {
                    _new = GenericType.getGenericSuperType(newTo, bound);
                }
                if (!_new.isGeneric() || ((GenericType)_new).getArguments().size() != genbound.getArguments().size()) {
                    return false;
                }
                HashMap<VarType, VarType> toAdd = new HashMap<VarType, VarType>();
                GenericType genNew = (GenericType)_new;
                for (int i = 0; i < genbound.getArguments().size(); ++i) {
                    Pair<VarType, VarType> pair;
                    VarType boundArg = genbound.getArguments().get(i);
                    VarType newArg = genNew.getArguments().get(i);
                    if (boundArg == null || boundArg.equals(newArg) || from.equals(boundArg) && to.equals(newArg)) continue;
                    if (bounds.containsKey(boundArg) && !recursivelySeen.contains(pair = Pair.of(bound, newTo))) {
                        recursivelySeen.add(pair);
                        if (this.isMappingInBounds(boundArg, newArg, named, bounds, recursivelySeen)) {
                            toAdd.put(boundArg, newArg);
                            continue;
                        }
                    }
                    return false;
                }
                toAdd.forEach((k, v) -> this.processGenericMapping((VarType)k, (VarType)v, named, bounds));
            }
            return true;
        };
        List<VarType> toVerify = to.type == CodeType.GENVAR ? named.get(to) : Collections.singletonList(to);
        return bounds.get(from).stream().allMatch(bound -> toVerify.stream().anyMatch(v -> (Boolean)verifier.apply((VarType)v, (VarType)bound)));
    }

    private Map<VarType, List<VarType>> getGenericBounds(StructClass mthCls) {
        ClassesProcessor.ClassNode cn;
        int x;
        HashMap<VarType, List<VarType>> bounds = new HashMap<VarType, List<VarType>>();
        if (this.desc.getSignature() != null) {
            for (x = 0; x < this.desc.getSignature().typeParameters.size(); ++x) {
                bounds.putIfAbsent(GenericType.parse("T" + this.desc.getSignature().typeParameters.get(x) + ";"), this.desc.getSignature().typeParameterBounds.get(x));
            }
        }
        if (mthCls.getSignature() != null) {
            for (x = 0; x < mthCls.getSignature().fparameters.size(); ++x) {
                bounds.putIfAbsent(GenericType.parse("T" + mthCls.getSignature().fparameters.get(x) + ";"), mthCls.getSignature().fbounds.get(x));
            }
        }
        ClassesProcessor.ClassNode classNode = cn = (cn = DecompilerContext.getClassProcessor().getMapRootClasses().get(mthCls.qualifiedName)) != null ? cn.parent : null;
        while (cn != null) {
            if (cn.classStruct.getSignature() != null) {
                for (int x2 = 0; x2 < cn.classStruct.getSignature().fparameters.size(); ++x2) {
                    bounds.putIfAbsent(GenericType.parse("T" + cn.classStruct.getSignature().fparameters.get(x2) + ";"), cn.classStruct.getSignature().fbounds.get(x2));
                }
            }
            cn = cn.parent;
        }
        return bounds;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.instance) {
            this.instance = newExpr;
        }
        for (int i = 0; i < this.lstParameters.size(); ++i) {
            if (oldExpr != this.lstParameters.get(i)) continue;
            this.lstParameters.set(i, newExpr);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvocationExprent)) {
            return false;
        }
        InvocationExprent it = (InvocationExprent)o;
        return InterpreterUtil.equalObjects(this.name, it.getName()) && InterpreterUtil.equalObjects(this.classname, it.getClassname()) && this.isStatic == it.isStatic() && InterpreterUtil.equalObjects(this.instance, it.getInstance()) && InterpreterUtil.equalObjects(this.descriptor, it.getDescriptor()) && this.functype == it.getFunctype() && InterpreterUtil.equalLists(this.lstParameters, it.getLstParameters());
    }

    public List<Exprent> getLstParameters() {
        return this.lstParameters;
    }

    public void setLstParameters(List<Exprent> lstParameters) {
        this.lstParameters = lstParameters;
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(MethodDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public Type getFunctype() {
        return this.functype;
    }

    public void setFunctype(Type functype) {
        this.functype = functype;
    }

    public Exprent getInstance() {
        return this.instance;
    }

    public void setInstance(Exprent instance) {
        this.instance = instance;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStringDescriptor() {
        return this.stringDescriptor;
    }

    public void setStringDescriptor(String stringDescriptor) {
        this.stringDescriptor = stringDescriptor;
    }

    public InvocationType getInvocationType() {
        return this.invocationType;
    }

    public String getInvokeDynamicClassSuffix() {
        return this.invokeDynamicClassSuffix;
    }

    public LinkConstant getBootstrapMethod() {
        return this.bootstrapMethod;
    }

    public List<PooledConstant> getBootstrapArguments() {
        return this.bootstrapArguments;
    }

    public void setSyntheticNullCheck() {
        this.isSyntheticNullCheck = true;
    }

    public boolean isSyntheticNullCheck() {
        return this.isSyntheticNullCheck;
    }

    public List<VarType> getGenericArgs() {
        return this.genericArgs;
    }

    public Map<VarType, VarType> getGenericsMap() {
        return this.genericsMap;
    }

    public StructMethod getDesc() {
        if (this.desc == null) {
            StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
            this.desc = cl != null ? cl.getMethodRecursive(this.name, this.stringDescriptor) : null;
        }
        return this.desc;
    }

    @Override
    public void setInvocationInstance() {
        this.isInvocationInstance = true;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        InvocationExprent.measureBytecode(values, this.lstParameters);
        InvocationExprent.measureBytecode(values, this.instance);
        this.measureBytecode(values);
    }

    public InvocationExprent markWasLazyCondy() {
        this.wasLazyCondy = true;
        return this;
    }

    @Override
    public void processSforms(SFormsConstructor sFormsConstructor, VarMapHolder varMaps, Statement stat, boolean calcLiveVars) {
        super.processSforms(sFormsConstructor, varMaps, stat, calcLiveVars);
        if (sFormsConstructor.trackFieldVars) {
            varMaps.getNormal().removeAllFields();
        }
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        return matchNode.iterateRules((key, value) -> {
            if (key == IMatchable.MatchProperties.EXPRENT_PARAMETER) {
                return !value.isVariable() || value.parameter < this.lstParameters.size() && engine.checkAndSetVariableValue(value.value.toString(), this.lstParameters.get(value.parameter));
            }
            if (key == IMatchable.MatchProperties.EXPRENT_INVOCATION_CLASS) {
                return value.value.equals(this.classname);
            }
            if (key == IMatchable.MatchProperties.EXPRENT_INVOCATION_SIGNATURE) {
                return value.value.equals(this.name + this.stringDescriptor);
            }
            if (key == IMatchable.MatchProperties.EXPRENT_NAME) {
                return value.value.equals(this.name);
            }
            return true;
        });
    }

    static {
        UNBOXING_METHODS.put("booleanValue", "java/lang/Boolean");
        UNBOXING_METHODS.put("byteValue", "java/lang/Byte");
        UNBOXING_METHODS.put("shortValue", "java/lang/Short");
        UNBOXING_METHODS.put("intValue", "java/lang/Integer");
        UNBOXING_METHODS.put("longValue", "java/lang/Long");
        UNBOXING_METHODS.put("floatValue", "java/lang/Float");
        UNBOXING_METHODS.put("doubleValue", "java/lang/Double");
        UNBOXING_METHODS.put("charValue", "java/lang/Character");
    }

    public static enum Type {
        GENERAL,
        INIT,
        CLINIT;

    }

    public static enum InvocationType {
        SPECIAL,
        VIRTUAL,
        STATIC,
        INTERFACE,
        DYNAMIC,
        CONSTANT_DYNAMIC;

    }

    protected static class BoxState {
        private boolean forceBoxing = false;
        private boolean forceUnboxing = false;
        private boolean keepCast = false;

        protected BoxState() {
        }
    }
}

