/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.startup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.graalvm.visualvm.modules.startup.LicensePanel;
import org.graalvm.visualvm.modules.startup.Utils;
import org.graalvm.visualvm.modules.startup.VisualVMStartup;
import org.graalvm.visualvm.modules.startup.dialogs.StartupDialog;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public final class AcceptLicense {
    private static final String YES_AC = "yes";
    private static final String NO_AC = "no";
    private static JDialog d;
    private static String command;

    public static void showLicensePanel() throws Exception {
        Utils.setSystemLaF();
        if (!VisualVMStartup.checkEnv()) {
            throw new UserCancelException();
        }
        URL url = AcceptLicense.class.getResource("LICENSE.txt");
        LicensePanel licensePanel = new LicensePanel(url);
        ResourceBundle bundle = NbBundle.getBundle(AcceptLicense.class);
        String yesLabel = bundle.getString("MSG_LicenseYesButton");
        String noLabel = bundle.getString("MSG_LicenseNoButton");
        JButton yesButton = new JButton();
        JButton noButton = new JButton();
        Utils.setLocalizedText(yesButton, yesLabel);
        Utils.setLocalizedText(noButton, noLabel);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                command = e.getActionCommand();
                d.setVisible(false);
                d.dispose();
                d = null;
            }
        };
        yesButton.addActionListener(listener);
        noButton.addActionListener(listener);
        yesButton.setActionCommand(YES_AC);
        noButton.setActionCommand(NO_AC);
        yesButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_AcceptButton"));
        yesButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSD_AcceptButton"));
        noButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_RejectButton"));
        noButton.getAccessibleContext().setAccessibleName(bundle.getString("ACSD_RejectButton"));
        Dimension yesPF = yesButton.getPreferredSize();
        Dimension noPF = noButton.getPreferredSize();
        int maxWidth = Math.max(yesPF.width, noPF.width);
        int maxHeight = Math.max(yesPF.height, noPF.height);
        yesButton.setPreferredSize(new Dimension(maxWidth, maxHeight));
        noButton.setPreferredSize(new Dimension(maxWidth, maxHeight));
        d = StartupDialog.create(bundle.getString("MSG_LicenseDlgTitle"), null, -1);
        d.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_LicenseDlg"));
        d.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_LicenseDlg"));
        d.getContentPane().add((Component)licensePanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(17, 12, 11, 11));
        buttonPanel.add(yesButton);
        buttonPanel.add(noButton);
        d.getContentPane().add((Component)buttonPanel, "South");
        d.setSize(new Dimension(600, 600));
        d.setResizable(true);
        d.setLocationRelativeTo(null);
        d.setVisible(true);
        if (!YES_AC.equals(command)) {
            throw new UserCancelException();
        }
    }
}

