/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SemVer
implements Comparable<SemVer> {
    public final int major;
    public final int minor;
    public final int patch;
    public final List<Object> preRelease;

    public SemVer(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = Collections.emptyList();
    }

    public SemVer(String version) {
        int buildSep;
        String value = version;
        String preRel = null;
        int sep = value.indexOf(45);
        if (sep != -1) {
            preRel = value.substring(sep + 1);
            value = value.substring(0, sep);
        }
        String build = null;
        if (preRel != null && (buildSep = preRel.indexOf(43)) != -1) {
            build = preRel.substring(buildSep + 1);
            preRel = preRel.substring(0, buildSep);
        }
        String[] tokens = value.split("\\.");
        this.major = Integer.parseInt(tokens[0]);
        this.minor = tokens.length >= 2 ? Integer.parseInt(tokens[1]) : 0;
        this.patch = tokens.length >= 3 ? Integer.parseInt(tokens[2]) : 0;
        this.preRelease = preRel != null ? Stream.of(preRel.split("\\.")).map(token -> {
            try {
                return Integer.valueOf(token);
            }
            catch (NumberFormatException e) {
                return token;
            }
        }).collect(Collectors.toList()) : Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemVer semVer = (SemVer)o;
        return this.major == semVer.major && this.minor == semVer.minor && this.patch == semVer.patch;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    @Override
    public int compareTo(SemVer o) {
        if (o.major == this.major && o.minor == this.minor && o.patch == this.patch) {
            return 0;
        }
        if (o.major > this.major) {
            return -1;
        }
        if (o.major < this.major) {
            return 1;
        }
        if (o.minor > this.minor) {
            return -1;
        }
        if (o.minor < this.minor) {
            return 1;
        }
        if (o.patch > this.patch) {
            return -1;
        }
        if (o.patch < this.patch) {
            return 1;
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }
}

