/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.utils;

import com.eclipsesource.v8.ReferenceHandler;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Value;
import java.util.ArrayList;
import java.util.Iterator;

public class MemoryManager {
    private MemoryManagerReferenceHandler memoryManagerReferenceHandler;
    private V8 v8;
    private ArrayList<V8Value> references = new ArrayList();
    private boolean releasing = false;
    private boolean released = false;

    public MemoryManager(V8 v8) {
        this.v8 = v8;
        this.memoryManagerReferenceHandler = new MemoryManagerReferenceHandler();
        v8.addReferenceHandler(this.memoryManagerReferenceHandler);
    }

    public int getObjectReferenceCount() {
        this.checkReleased();
        return this.references.size();
    }

    public void persist(V8Value object) {
        this.v8.getLocker().checkThread();
        this.checkReleased();
        this.references.remove(object);
    }

    public boolean isReleased() {
        return this.released;
    }

    public void release() {
        this.v8.getLocker().checkThread();
        if (this.released) {
            return;
        }
        this.releasing = true;
        try {
            for (V8Value reference : this.references) {
                reference.release();
            }
            this.v8.removeReferenceHandler(this.memoryManagerReferenceHandler);
            this.references.clear();
        }
        finally {
            this.releasing = false;
        }
        this.released = true;
    }

    private void checkReleased() {
        if (this.released) {
            throw new IllegalStateException("Memory manager released");
        }
    }

    private class MemoryManagerReferenceHandler
    implements ReferenceHandler {
        private MemoryManagerReferenceHandler() {
        }

        @Override
        public void v8HandleCreated(V8Value object) {
            MemoryManager.this.references.add(object);
        }

        @Override
        public void v8HandleDisposed(V8Value object) {
            if (!MemoryManager.this.releasing) {
                Iterator iterator = MemoryManager.this.references.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != object) continue;
                    iterator.remove();
                    return;
                }
            }
        }
    }
}

