/*
 * Decompiled with CFR 0.152.
 */
package coursier.util;

import coursier.cache.CacheDefaults$;
import coursier.cache.CacheUrl$;
import coursier.cache.ConnectionBuilder$;
import coursier.cache.FileCache;
import coursier.core.Dependency;
import coursier.core.Module;
import coursier.util.InMemoryRepository;
import coursier.version.Version;
import coursier.version.Version$;
import coursier.version.VersionInterval;
import coursier.version.VersionInterval$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.sys.package$;

public final class InMemoryRepository$
implements Serializable {
    public static final InMemoryRepository$ MODULE$ = new InMemoryRepository$();

    public InMemoryRepository forDependencies(Seq<Tuple2<Dependency, String>> dependencies) {
        return this.apply(((IterableOnceOps)dependencies.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2;
            block2: {
                String url;
                Dependency dep;
                block4: {
                    block3: {
                        tuple2 = x0$1;
                        if (tuple2 == null) break block2;
                        dep = (Dependency)tuple2._1();
                        url = (String)tuple2._2();
                        if (dep.versionConstraint().latest().nonEmpty()) break block3;
                        VersionInterval versionInterval = dep.versionConstraint().interval();
                        VersionInterval versionInterval2 = VersionInterval$.MODULE$.zero();
                        if (!(versionInterval != null ? !((Object)versionInterval).equals(versionInterval2) : versionInterval2 != null) && !dep.versionConstraint().preferred().isEmpty()) break block4;
                    }
                    throw package$.MODULE$.error(new StringBuilder(72).append("InMemoryRepository dependencies should have an exact version (got ").append(dep.versionConstraint().asString()).append(" for ").append(dep.module().repr()).append(")").toString());
                }
                Version version = dep.versionConstraint().preferred().get();
                return new Tuple2<Tuple2<Module, Version>, Tuple2<URL, Boolean>>(new Tuple2<Module, Version>(dep.module(), version), new Tuple2<URL, Boolean>(new URL(url), BoxesRunTime.boxToBoolean(version.repr().endsWith("SNAPSHOT"))));
            }
            throw new MatchError(tuple2);
        })).toMap($less$colon$less$.MODULE$.refl()), None$.MODULE$, false);
    }

    public boolean exists(URL url, boolean localArtifactsShouldBeCached) {
        return this.exists(url, localArtifactsShouldBeCached, None$.MODULE$);
    }

    public boolean exists(URL url, boolean localArtifactsShouldBeCached, Option<FileCache<Nothing$>> cacheOpt) {
        Option option;
        block8: {
            block7: {
                String string = url.getProtocol();
                switch (string == null ? 0 : string.hashCode()) {
                    case 3143036: {
                        if (!"file".equals(string)) break block7;
                        option = InMemoryRepository$.ifFile$1(localArtifactsShouldBeCached, url, cacheOpt);
                        break block8;
                    }
                    case 3213448: {
                        if ("http".equals(string)) {
                            break;
                        }
                        break block7;
                    }
                    case 99617003: {
                        if ("https".equals(string)) {
                            break;
                        }
                        break block7;
                    }
                    default: {
                        break block7;
                    }
                }
                option = InMemoryRepository$.ifHttp$1(url, cacheOpt);
                break block8;
            }
            option = None$.MODULE$;
        }
        None$ protocolSpecificAttemptOpt = option;
        return BoxesRunTime.unboxToBoolean(protocolSpecificAttemptOpt.getOrElse(() -> InMemoryRepository$.genericAttempt$1(url)));
    }

    public InMemoryRepository apply(Map<Tuple2<Module, String>, Tuple2<URL, Object>> fallbacks) {
        return this.privateApply((Map)fallbacks.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Module m = (Module)tuple22._1();
                    String v = (String)tuple22._2();
                    if (tuple23 != null) {
                        URL url = (URL)tuple23._1();
                        boolean thing = tuple23._2$mcZ$sp();
                        return new Tuple2<Tuple2<Module, Version>, Tuple2<URL, Boolean>>(new Tuple2<Module, Version>(m, Version$.MODULE$.apply(v)), new Tuple2<URL, Boolean>(url, BoxesRunTime.boxToBoolean(thing)));
                    }
                }
            }
            throw new MatchError(tuple2);
        }));
    }

    public InMemoryRepository privateApply(Map<Tuple2<Module, Version>, Tuple2<URL, Object>> fallbacks) {
        return new InMemoryRepository(fallbacks, None$.MODULE$, false);
    }

    public InMemoryRepository apply(Map<Tuple2<Module, String>, Tuple2<URL, Object>> fallbacks, boolean localArtifactsShouldBeCached) {
        return this.privateApply((Map)fallbacks.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Module m = (Module)tuple22._1();
                    String v = (String)tuple22._2();
                    if (tuple23 != null) {
                        URL url = (URL)tuple23._1();
                        boolean thing = tuple23._2$mcZ$sp();
                        return new Tuple2<Tuple2<Module, Version>, Tuple2<URL, Boolean>>(new Tuple2<Module, Version>(m, Version$.MODULE$.apply(v)), new Tuple2<URL, Boolean>(url, BoxesRunTime.boxToBoolean(thing)));
                    }
                }
            }
            throw new MatchError(tuple2);
        }), localArtifactsShouldBeCached);
    }

    public InMemoryRepository privateApply(Map<Tuple2<Module, Version>, Tuple2<URL, Object>> fallbacks, boolean localArtifactsShouldBeCached) {
        return new InMemoryRepository(fallbacks, None$.MODULE$, localArtifactsShouldBeCached);
    }

    public <F> InMemoryRepository create(Map<Tuple2<Module, Version>, Tuple2<URL, Object>> fallbacks, FileCache<F> cache) {
        return new InMemoryRepository(fallbacks, new Some<FileCache<Nothing$>>(cache), cache.localArtifactsShouldBeCached());
    }

    public <F> InMemoryRepository apply(Map<Tuple2<Module, String>, Tuple2<URL, Object>> fallbacks, FileCache<F> cache) {
        return this.create((Map)fallbacks.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 value = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Module mod = (Module)tuple22._1();
                    String ver = (String)tuple22._2();
                    return new Tuple2<Tuple2<Module, Version>, Tuple2>(new Tuple2<Module, Version>(mod, Version$.MODULE$.apply(ver)), value);
                }
            }
            throw new MatchError(tuple2);
        }), cache);
    }

    public InMemoryRepository apply(Map<Tuple2<Module, String>, Tuple2<URL, Object>> fallbacks0, boolean localArtifactsShouldBeCached, Option<FileCache<Nothing$>> cacheOpt) {
        return this.apply((Map)fallbacks0.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 value = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Module mod = (Module)tuple22._1();
                    String ver = (String)tuple22._2();
                    return new Tuple2<Tuple2<Module, Version>, Tuple2>(new Tuple2<Module, Version>(mod, Version$.MODULE$.apply(ver)), value);
                }
            }
            throw new MatchError(tuple2);
        }), cacheOpt, localArtifactsShouldBeCached);
    }

    public InMemoryRepository apply(Map<Tuple2<Module, Version>, Tuple2<URL, Object>> fallbacks0, Option<FileCache<Nothing$>> cacheOpt, boolean localArtifactsShouldBeCached) {
        return new InMemoryRepository(fallbacks0, cacheOpt, localArtifactsShouldBeCached);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(InMemoryRepository$.class);
    }

    private static final Option ifFile$1(boolean localArtifactsShouldBeCached$1, URL url$1, Option cacheOpt$1) {
        if (localArtifactsShouldBeCached$1 && !new File(url$1.toURI()).exists()) {
            File cachePath = (File)cacheOpt$1.fold((Function0<File> & Serializable)() -> CacheDefaults$.MODULE$.location(), (Function1<FileCache, File> & Serializable)x$1 -> x$1.location());
            return new Some<Boolean>(BoxesRunTime.boxToBoolean(new File(cachePath, new StringBuilder(5).append("file/").append(url$1.getPath()).toString()).exists()));
        }
        return new Some<Boolean>(BoxesRunTime.boxToBoolean(new File(url$1.toURI()).exists()));
    }

    private static final Option ifHttp$1(URL url$1, Option cacheOpt$1) {
        Option option;
        URLConnection conn = null;
        try {
            try {
                conn = ConnectionBuilder$.MODULE$.apply(url$1.toString()).withFollowHttpToHttpsRedirections(BoxesRunTime.unboxToBoolean(cacheOpt$1.fold(() -> false, (Function1<FileCache, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.followHttpToHttpsRedirections())))).withFollowHttpsToHttpRedirections(BoxesRunTime.unboxToBoolean(cacheOpt$1.fold(() -> false, (Function1<FileCache, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.followHttpsToHttpRedirections())))).withSslSocketFactoryOpt(cacheOpt$1.flatMap((Function1<FileCache, Option> & Serializable)x$4 -> x$4.sslSocketFactoryOpt())).withHostnameVerifierOpt(cacheOpt$1.flatMap((Function1<FileCache, Option> & Serializable)x$5 -> x$5.hostnameVerifierOpt())).withMethod("HEAD").withMaxRedirectionsOpt(cacheOpt$1.flatMap((Function1<FileCache, Option> & Serializable)x$6 -> x$6.maxRedirections())).connection();
                conn.getInputStream().close();
                option = new Some<Boolean>(BoxesRunTime.boxToBoolean(true));
            }
            catch (FileNotFoundException fileNotFoundException) {
                option = new Some<Boolean>(BoxesRunTime.boxToBoolean(false));
            }
            catch (IOException iOException) {
                option = None$.MODULE$;
            }
        }
        finally {
            if (conn != null) {
                CacheUrl$.MODULE$.closeConn(conn);
            }
        }
        return option;
    }

    private static final boolean genericAttempt$1(URL url$1) {
        boolean bl;
        URLConnection conn = null;
        try {
            try {
                conn = url$1.openConnection();
                conn.getInputStream().close();
                bl = true;
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        finally {
            if (conn != null) {
                CacheUrl$.MODULE$.closeConn(conn);
            }
        }
        return bl;
    }

    private InMemoryRepository$() {
    }
}

