/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.model.SvgElementFinder;
import guru.nidi.graphviz.model.SvgSizeAnalyzer;
import java.awt.Rectangle;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SvgShapeAnalyzer
extends SvgElementFinder {
    private static final Logger LOG = LoggerFactory.getLogger(SvgShapeAnalyzer.class);
    private final double xFactor;
    private final double yFactor;
    private final SvgSizeAnalyzer transform;

    public SvgShapeAnalyzer(SvgElementFinder finder, int width, int height) {
        super(finder);
        String viewBox = finder.doc.getDocumentElement().getAttribute("viewBox");
        String[] viewBoxParts = viewBox.split(" ");
        this.xFactor = (double)width / Double.parseDouble(viewBoxParts[2]);
        this.yFactor = (double)height / Double.parseDouble(viewBoxParts[3]);
        Element g = (Element)finder.doc.getDocumentElement().getElementsByTagName("g").item(0);
        this.transform = SvgSizeAnalyzer.transform(g.getAttribute("transform"));
    }

    @Nullable
    public Rectangle getBoundingBox(Element e) {
        if (!e.getAttribute("class").contains("node")) {
            LOG.error("Currently only nodes are supported.");
            return null;
        }
        NodeList ellipses = e.getElementsByTagName("ellipse");
        if (ellipses.getLength() == 0) {
            LOG.error("Currently only nodes with shape ellipse supported.");
            return null;
        }
        Element ellipse = (Element)ellipses.item(0);
        double cx = this.xFactor * (this.numAttr(ellipse, "cx") + this.transform.getTranslateX());
        double cy = this.yFactor * (this.numAttr(ellipse, "cy") + this.transform.getTranslateY());
        double rx = this.xFactor * this.numAttr(ellipse, "rx");
        double ry = this.yFactor * this.numAttr(ellipse, "ry");
        return new Rectangle((int)Math.round(cx - rx), (int)Math.round(cy - ry), (int)Math.round(2.0 * rx), (int)Math.round(2.0 * ry));
    }

    private double numAttr(Element e, String attr) {
        return Double.parseDouble(e.getAttribute(attr));
    }
}

