/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependents.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.model.internal.type.ModelTypes;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentSpecContainer;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;

public class DependentComponentsUtils {
    public static String getBuildScopedTerseName(ComponentSpecIdentifier id) {
        return DependentComponentsUtils.getProjectPrefix(id.getProjectPath()) + id.getProjectScopedName();
    }

    public static String getBuildScopedTerseName(LibraryBinaryIdentifier id) {
        return DependentComponentsUtils.getProjectPrefix(id.getProjectPath()) + id.getLibraryName() + ":" + id.getVariant();
    }

    private static String getProjectPrefix(String projectPath) {
        if (":".equals(projectPath)) {
            return "";
        }
        return projectPath + ":";
    }

    public static Set<ComponentSpec> getAllComponents(ModelRegistry registry) {
        LinkedHashSet<ComponentSpec> components = new LinkedHashSet<ComponentSpec>();
        ComponentSpecContainer componentSpecs = DependentComponentsUtils.modelElement(registry, "components", ComponentSpecContainer.class);
        if (componentSpecs != null) {
            components.addAll(componentSpecs.values());
        }
        return components;
    }

    public static Set<ComponentSpec> getAllTestSuites(ModelRegistry registry) {
        LinkedHashSet<ComponentSpec> components = new LinkedHashSet<ComponentSpec>();
        ModelMap testSuites = (ModelMap)DependentComponentsUtils.modelElement(registry, "testSuites", ModelTypes.modelMap(ComponentSpec.class));
        if (testSuites != null) {
            components.addAll(testSuites.values());
        }
        return components;
    }

    @Nullable
    private static <T> T modelElement(ModelRegistry registry, String path, Class<T> clazz) {
        return (T)registry.find(path, clazz);
    }

    @Nullable
    private static <T> T modelElement(ModelRegistry registry, String path, ModelType<T> modelType) {
        return (T)registry.find(path, modelType);
    }
}

