/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.windows;

import java.util.Map;
import java.util.Random;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.exceptions.NativeException;

public class WindowsRegistry {
    private int mode;
    private Boolean wow64process;
    public static final int HKEY_CLASSES_ROOT = 0;
    public static final int HKEY_CURRENT_USER = 1;
    public static final int HKEY_LOCAL_MACHINE = 2;
    public static final int HKEY_USERS = 3;
    public static final int HKEY_CURRENT_CONFIG = 4;
    public static final int HKEY_DYN_DATA = 5;
    public static final int HKEY_PERFORMANCE_DATA = 6;
    public static final int HKEY_PERFORMANCE_NLSTEXT = 7;
    public static final int HKEY_PERFORMANCE_TEXT = 8;
    public static final int HKCR = 0;
    public static final int HKCU = 1;
    public static final int HKLM = 2;
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD_LITTLE_ENDIAN = 4;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_BIG_ENDIAN = 5;
    public static final int REG_LINK = 6;
    public static final int REG_MULTI_SZ = 7;
    public static final int REG_RESOURCE_LIST = 8;
    public static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    public static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    public static final int REG_QWORD_LITTLE_ENDIAN = 11;
    public static final int REG_QWORD = 11;
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_32BIT = 1;
    public static final int MODE_64BIT = 2;
    public static final String SEPARATOR = "\\";
    private static int KEY_READ_LEVEL = 0;
    private static int KEY_MODIFY_LEVEL = 1;
    private static final String ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING = ResourceUtils.getString(WindowsRegistry.class, "WR.error.cannot.access.native");

    public WindowsRegistry() {
        this.setMode(0);
    }

    public boolean keyExists(int section, String key) throws NativeException {
        this.validateSection(section);
        this.validateKey(key);
        try {
            return this.checkKeyAccess0(this.mode, section, key, KEY_READ_LEVEL);
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
        }
    }

    public boolean keyExists(int section, String parent, String child) throws NativeException {
        this.validateKey(parent);
        this.validateKeyName(child);
        this.validateParenthood(parent, child);
        try {
            return this.keyExists(section, parent + SEPARATOR + child);
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
        }
    }

    public boolean valueExists(int section, String key, String name) throws NativeException {
        this.validateValueName(name);
        if (this.keyExists(section, key)) {
            try {
                return this.valueExists0(this.mode, section, key, name);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        }
        throw new NativeException("Cannot check for value existance - key does not exist");
    }

    public boolean keyEmpty(int section, String key) throws NativeException {
        if (this.keyExists(section, key)) {
            try {
                return this.keyEmpty0(this.mode, section, key);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        }
        throw new NativeException("Cannot check -- key does not exist");
    }

    public int countSubKeys(int section, String key) throws NativeException {
        if (this.keyExists(section, key)) {
            try {
                return this.countSubKeys0(this.mode, section, key);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        }
        throw new NativeException("Cannot count subkeys -- key does not exist");
    }

    public int countValues(int section, String key) throws NativeException {
        if (this.keyExists(section, key)) {
            try {
                return this.countValues0(this.mode, section, key);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        }
        throw new NativeException("Cannot count values -- key does not exist");
    }

    public String[] getSubKeys(int section, String key) throws NativeException {
        String[] names = this.getSubKeyNames(section, key);
        String[] subkeys = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            subkeys[i] = this.constructKey(key, names[i]);
        }
        return subkeys;
    }

    public String[] getSubKeyNames(int section, String key) throws NativeException {
        if (this.keyExists(section, key)) {
            try {
                return this.getSubkeyNames0(this.mode, section, key);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        }
        throw new NativeException("Cannot get subkey names -- key does not exist");
    }

    public String[] getValueNames(int section, String key) throws NativeException {
        if (this.keyExists(section, key)) {
            try {
                return this.getValueNames0(this.mode, section, key);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        }
        throw new NativeException("Cannot list value names -- key does not exist");
    }

    public int getValueType(int section, String key, String name) throws NativeException {
        if (this.keyExists(section, key)) {
            if (this.valueExists(section, key, name)) {
                try {
                    return this.getValueType0(this.mode, section, key, name);
                }
                catch (UnsatisfiedLinkError e) {
                    throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
                }
            }
            throw new NativeException("Cannot get value type -- value does not exist");
        }
        throw new NativeException("Cannot get value type -- key does not exist");
    }

    public void createKey(int section, String key) throws NativeException {
        this.createKey(section, this.getKeyParent(key), this.getKeyName(key));
    }

    public void createKey(int section, String parent, String child) throws NativeException {
        if (!this.keyExists(section, parent, child)) {
            if (!this.keyExists(section, parent)) {
                this.createKey(section, this.getKeyParent(parent), this.getKeyName(parent));
            }
            try {
                this.createKey0(this.mode, section, parent, child);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        }
    }

    public void deleteKey(int section, String key) throws NativeException {
        this.deleteKey(section, this.getKeyParent(key), this.getKeyName(key));
    }

    public void deleteKey(int section, String parent, String child) throws NativeException {
        if (this.keyExists(section, parent, child)) {
            try {
                this.deleteKey0(this.mode, section, parent, child);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        }
    }

    public void deleteValue(int section, String key, String name) throws NativeException {
        if (this.keyExists(section, key)) {
            if (this.valueExists(section, key, name)) {
                try {
                    this.deleteValue0(this.mode, section, key, name);
                }
                catch (UnsatisfiedLinkError e) {
                    throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
                }
            }
        } else {
            throw new NativeException("Cannot delete value -- key does not exist");
        }
    }

    public String getStringValue(int section, String key, String name) throws NativeException {
        return this.getStringValue(section, key, name, false);
    }

    public String getStringValue(int section, String key, String name, boolean expand) throws NativeException {
        if (this.keyExists(section, key)) {
            if (this.valueExists(section, key, name)) {
                try {
                    return this.getStringValue0(this.mode, section, key, name, expand);
                }
                catch (UnsatisfiedLinkError e) {
                    throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
                }
            }
            throw new NativeException("Cannot get string value -- value does not exist");
        }
        throw new NativeException("Cannot get string value -- key does not exist");
    }

    public void setStringValue(int section, String key, String name, Object value) throws NativeException {
        this.setStringValue(section, key, name, value.toString());
    }

    public void setStringValue(int section, String key, String name, String value) throws NativeException {
        this.setStringValue(section, key, name, value, false);
    }

    public void setStringValue(int section, String key, String name, String value, boolean expandable) throws NativeException {
        this.validateValueName(name);
        this.validateStringValue(value);
        if (this.keyExists(section, key)) {
            try {
                this.setStringValue0(this.mode, section, key, name, value, expandable);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        } else {
            throw new NativeException("Cannot set string value -- key does not exist");
        }
    }

    public int get32BitValue(int section, String key, String name) throws NativeException {
        if (this.keyExists(section, key)) {
            if (this.valueExists(section, key, name)) {
                try {
                    return this.get32BitValue0(this.mode, section, key, name);
                }
                catch (UnsatisfiedLinkError e) {
                    throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
                }
            }
            throw new NativeException("Cannot get 32-bit value -- value does not exist");
        }
        throw new NativeException("Cannot get 32-bit value -- key does not exist");
    }

    public void set32BitValue(int section, String key, String name, int value) throws NativeException {
        this.validateValueName(name);
        this.validate32BitValue(value);
        if (this.keyExists(section, key)) {
            try {
                this.set32BitValue0(this.mode, section, key, name, value);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        } else {
            throw new NativeException("Cannot set 32-bit value -- key does not exist");
        }
    }

    public String[] getMultiStringValue(int section, String key, String name) throws NativeException {
        if (this.keyExists(section, key)) {
            if (this.valueExists(section, key, name)) {
                try {
                    return this.getMultiStringValue0(this.mode, section, key, name);
                }
                catch (UnsatisfiedLinkError e) {
                    throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
                }
            }
            throw new NativeException("Cannot get multistring value -- value does not exist");
        }
        throw new NativeException("Cannot get multistring value -- key does not exist");
    }

    public void setMultiStringValue(int section, String key, String name, String[] value) throws NativeException {
        this.validateValueName(name);
        this.validateMultiStringValue(value);
        if (this.keyExists(section, key)) {
            try {
                this.setMultiStringValue0(this.mode, section, key, name, value);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        } else {
            throw new NativeException("Cannot set multistring value -- key does not exist");
        }
    }

    public byte[] getBinaryValue(int section, String key, String name) throws NativeException {
        if (this.keyExists(section, key)) {
            if (this.valueExists(section, key, name)) {
                try {
                    return this.getBinaryValue0(this.mode, section, key, name);
                }
                catch (UnsatisfiedLinkError e) {
                    throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
                }
            }
            throw new NativeException("Cannot get binary value -- value does not exist");
        }
        throw new NativeException("Cannot get binary value -- key does not exist");
    }

    public void setBinaryValue(int section, String key, String name, byte[] value) throws NativeException {
        this.validateValueName(name);
        this.validateBinaryValue(value);
        if (this.keyExists(section, key)) {
            try {
                this.setBinaryValue0(this.mode, section, key, name, value);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        } else {
            throw new NativeException("Cannot set binary value -- key does not exist");
        }
    }

    public void setNoneValue(int section, String key, String name, byte ... bytes) throws NativeException {
        this.validateValueName(name);
        if (this.keyExists(section, key)) {
            try {
                this.setNoneValue0(this.mode, section, key, name, bytes);
            }
            catch (UnsatisfiedLinkError e) {
                throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
            }
        } else {
            throw new NativeException("Cannot access value -- key does not exist");
        }
    }

    public void setAdditionalValues(int section, String key, Map<String, Object> values) throws NativeException {
        LogManager.log("setting " + values.size() + " values");
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Object value = entry.getValue();
            String name = entry.getKey();
            LogManager.log(name + " = " + value.toString());
            if (value instanceof Short) {
                LogManager.log("Type is short. Set REG_DWORD value");
                this.set32BitValue(section, key, name, ((Short)value).intValue());
                continue;
            }
            if (value instanceof Integer) {
                LogManager.log("Type is integer. Set REG_DWORD value");
                this.set32BitValue(section, key, name, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                LogManager.log("Type is long. Set REG_DWORD value");
                this.set32BitValue(section, key, name, ((Long)value).intValue());
                continue;
            }
            if (value instanceof byte[]) {
                LogManager.log("Type is byte[]. Set REG_BINARY value");
                this.setBinaryValue(section, key, name, (byte[])value);
                continue;
            }
            if (value instanceof String[]) {
                LogManager.log("Type is String[]. Set REG_MULTI_SZ value");
                this.setMultiStringValue(section, key, name, (String[])value);
                continue;
            }
            if (value instanceof String) {
                LogManager.log("Type is String. Set REG_SZ value");
                this.setStringValue(section, key, name, (String)value, false);
                continue;
            }
            LogManager.log("Type can't be determined. Set REG_SZ value");
            this.setStringValue(section, key, name, value.toString(), false);
        }
    }

    public boolean canModifyKey(int section, String key) throws NativeException {
        try {
            if (this.keyExists(section, key)) {
                boolean check = this.checkKeyAccess0(this.mode, section, key, KEY_MODIFY_LEVEL);
                if (check) {
                    String randomKey = "rndkey" + new Random().nextLong();
                    try {
                        this.createKey0(this.mode, section, key, randomKey);
                        this.deleteKey0(this.mode, section, key, randomKey);
                    }
                    catch (NativeException ex) {
                        check = false;
                    }
                }
                return check;
            }
            return this.canModifyKey(section, this.getKeyParent(key));
        }
        catch (UnsatisfiedLinkError e) {
            throw new NativeException(ERROR_CANNOT_ACCESS_NATIVE_METHOD_STRING, e);
        }
    }

    public String constructKey(String parent, String child) {
        return parent + SEPARATOR + child;
    }

    public String getKeyParent(String key) {
        String temp = key;
        while (temp.endsWith(SEPARATOR)) {
            temp = temp.substring(0, temp.length() - 1);
        }
        int index = temp.lastIndexOf(SEPARATOR);
        if (index != -1) {
            return temp.substring(0, index);
        }
        return "";
    }

    public String getKeyName(String key) {
        String temp = key;
        while (temp.endsWith(SEPARATOR)) {
            temp = temp.substring(0, temp.length() - 1);
        }
        int index = temp.lastIndexOf(SEPARATOR);
        if (index != -1) {
            return temp.substring(index + 1);
        }
        return temp;
    }

    public void setMode(int m) {
        if (this.isModeSupported(m)) {
            this.mode = m;
        }
    }

    public boolean isAlternativeModeSupported() {
        return this.IsWow64Process() || System.getProperty("os.arch").equals("amd64");
    }

    public void setMode(Boolean modeChange) {
        this.setMode(this.modeBooleanToInteger(modeChange));
    }

    public boolean isModeSupported(int mode) {
        switch (mode) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                return this.isAlternativeModeSupported();
            }
        }
        return false;
    }

    public int getMode() {
        return this.mode;
    }

    public Boolean isAlternativeMode() {
        return this.modeIntegerToBoolean(this.mode);
    }

    public boolean IsWow64Process() {
        if (this.wow64process == null) {
            this.wow64process = this.IsWow64Process0();
        }
        return this.wow64process;
    }

    private Boolean modeIntegerToBoolean(int im) {
        if (im == 0) {
            return null;
        }
        if (im == 1) {
            return System.getProperty("os.arch").equals("amd64");
        }
        if (im == 2) {
            return this.IsWow64Process();
        }
        return null;
    }

    private int modeBooleanToInteger(Boolean bm) {
        if (bm == null) {
            return 0;
        }
        if (this.IsWow64Process()) {
            return bm != false ? 2 : 1;
        }
        if (System.getProperty("os.arch").equals("amd64")) {
            return bm == false ? 2 : 1;
        }
        return 0;
    }

    private void validateSection(int section) throws NativeException {
        if (section < 0 || section > 8) {
            throw new NativeException("Section \"" + section + "\" is invalid, should be between " + 0 + " and " + 8);
        }
    }

    private void validateKey(String key) throws NativeException {
        if (key == null) {
            throw new NativeException("Key cannot be null");
        }
    }

    private void validateKeyName(String name) throws NativeException {
        if (name == null) {
            throw new NativeException("Key name cannot be null");
        }
    }

    private void validateParenthood(String parent, String child) throws NativeException {
        if (parent.equals(child)) {
            throw new NativeException("Parent cannot be equal to child");
        }
    }

    private void validateValueName(String name) throws NativeException {
        if (name == null) {
            throw new NativeException("Value name cannot be null");
        }
    }

    private void validateStringValue(String value) throws NativeException {
        if (value == null) {
            throw new NativeException("String value cannot be null");
        }
    }

    private void validate32BitValue(int value) throws NativeException {
    }

    private void validateMultiStringValue(String[] value) throws NativeException {
        if (value == null) {
            throw new NativeException("Multistring value cannot be null");
        }
    }

    private void validateBinaryValue(byte[] value) throws NativeException {
        if (value == null) {
            throw new NativeException("Binary value cannot be null");
        }
    }

    private native boolean keyExists0(int var1, int var2, String var3) throws NativeException;

    private native boolean valueExists0(int var1, int var2, String var3, String var4) throws NativeException;

    private native boolean keyEmpty0(int var1, int var2, String var3) throws NativeException;

    private native int countSubKeys0(int var1, int var2, String var3) throws NativeException;

    private native int countValues0(int var1, int var2, String var3) throws NativeException;

    private native String[] getSubkeyNames0(int var1, int var2, String var3) throws NativeException;

    private native String[] getValueNames0(int var1, int var2, String var3) throws NativeException;

    private native int getValueType0(int var1, int var2, String var3, String var4) throws NativeException;

    private native void createKey0(int var1, int var2, String var3, String var4) throws NativeException;

    private native void deleteKey0(int var1, int var2, String var3, String var4) throws NativeException;

    private native void deleteValue0(int var1, int var2, String var3, String var4) throws NativeException;

    private native String getStringValue0(int var1, int var2, String var3, String var4, boolean var5) throws NativeException;

    private native void setStringValue0(int var1, int var2, String var3, String var4, String var5, boolean var6);

    private native int get32BitValue0(int var1, int var2, String var3, String var4) throws NativeException;

    private native void set32BitValue0(int var1, int var2, String var3, String var4, int var5) throws NativeException;

    private native String[] getMultiStringValue0(int var1, int var2, String var3, String var4) throws NativeException;

    private native void setMultiStringValue0(int var1, int var2, String var3, String var4, String[] var5) throws NativeException;

    private native byte[] getBinaryValue0(int var1, int var2, String var3, String var4) throws NativeException;

    private native void setBinaryValue0(int var1, int var2, String var3, String var4, byte[] var5) throws NativeException;

    private native void setNoneValue0(int var1, int var2, String var3, String var4, Object var5) throws NativeException;

    private native boolean checkKeyAccess0(int var1, int var2, String var3, int var4) throws NativeException;

    private native boolean IsWow64Process0();
}

