// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2020 Konrad Twardowski

#pragma once

#include "../kshutdown.h"

#include <QComboBox>

class FileMonitor final: public Trigger {
public:
	enum class Rule { Exists, NotExists };

	explicit FileMonitor();
	virtual bool canActivateAction() override;
	void initContainerWidget() override;
	virtual void readConfig() override;
	virtual void writeConfig() override;
private:
	Q_DISABLE_COPY(FileMonitor)
	QComboBox *m_ruleComboBox = nullptr;
	QLineEdit *m_fileEdit = nullptr;
	QString m_recentFile = "";
	Rule m_recentRule = Rule::Exists;
	UPath m_path;
	bool exists() { return std::filesystem::exists(m_path); }
	void updateStatus();
};
