//autogenerated:yes
//nolint:revive,govet,errcheck
package ardupilotmega

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestEnum_GOPRO_PHOTO_RESOLUTION(t *testing.T) {
	t.Run("zero", func(t *testing.T) {
		var e GOPRO_PHOTO_RESOLUTION
		e.UnmarshalText([]byte{})
		e.MarshalText()
		e.String()
	})

	t.Run("first entry", func(t *testing.T) {
		enc, err := GOPRO_PHOTO_RESOLUTION_5MP_MEDIUM.MarshalText()
		require.NoError(t, err)

		var dec GOPRO_PHOTO_RESOLUTION
		err = dec.UnmarshalText(enc)
		require.NoError(t, err)

		require.Equal(t, GOPRO_PHOTO_RESOLUTION_5MP_MEDIUM, dec)
	})
}
