//autogenerated:yes
//nolint:revive,misspell,govet,lll
package asluav

// Battery pack monitoring data for Li-Ion batteries
type MessageSensBatmon struct {
	// Time since system start
	BatmonTimestamp uint64
	// Battery pack temperature
	Temperature float32
	// Battery pack voltage
	Voltage uint16
	// Battery pack current
	Current int16
	// Battery pack state-of-charge
	Soc uint8 `mavname:"SoC"`
	// Battery monitor status report bits in Hex
	Batterystatus uint16
	// Battery monitor serial number in Hex
	Serialnumber uint16
	// Battery monitor safetystatus report bits in Hex
	Safetystatus uint32
	// Battery monitor operation status report bits in Hex
	Operationstatus uint32
	// Battery pack cell 1 voltage
	Cellvoltage1 uint16
	// Battery pack cell 2 voltage
	Cellvoltage2 uint16
	// Battery pack cell 3 voltage
	Cellvoltage3 uint16
	// Battery pack cell 4 voltage
	Cellvoltage4 uint16
	// Battery pack cell 5 voltage
	Cellvoltage5 uint16
	// Battery pack cell 6 voltage
	Cellvoltage6 uint16
}

// GetID implements the message.Message interface.
func (*MessageSensBatmon) GetID() uint32 {
	return 8010
}
