//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Video stream types
type VIDEO_STREAM_TYPE uint64

const (
	// Stream is RTSP
	VIDEO_STREAM_TYPE_RTSP VIDEO_STREAM_TYPE = 0
	// Stream is RTP UDP (URI gives the port number)
	VIDEO_STREAM_TYPE_RTPUDP VIDEO_STREAM_TYPE = 1
	// Stream is MPEG on TCP
	VIDEO_STREAM_TYPE_TCP_MPEG VIDEO_STREAM_TYPE = 2
	// Stream is MPEG TS (URI gives the port number)
	VIDEO_STREAM_TYPE_MPEG_TS VIDEO_STREAM_TYPE = 3
)

var value_to_label_VIDEO_STREAM_TYPE = map[VIDEO_STREAM_TYPE]string{
	VIDEO_STREAM_TYPE_RTSP:     "VIDEO_STREAM_TYPE_RTSP",
	VIDEO_STREAM_TYPE_RTPUDP:   "VIDEO_STREAM_TYPE_RTPUDP",
	VIDEO_STREAM_TYPE_TCP_MPEG: "VIDEO_STREAM_TYPE_TCP_MPEG",
	VIDEO_STREAM_TYPE_MPEG_TS:  "VIDEO_STREAM_TYPE_MPEG_TS",
}

var label_to_value_VIDEO_STREAM_TYPE = map[string]VIDEO_STREAM_TYPE{
	"VIDEO_STREAM_TYPE_RTSP":     VIDEO_STREAM_TYPE_RTSP,
	"VIDEO_STREAM_TYPE_RTPUDP":   VIDEO_STREAM_TYPE_RTPUDP,
	"VIDEO_STREAM_TYPE_TCP_MPEG": VIDEO_STREAM_TYPE_TCP_MPEG,
	"VIDEO_STREAM_TYPE_MPEG_TS":  VIDEO_STREAM_TYPE_MPEG_TS,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e VIDEO_STREAM_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_VIDEO_STREAM_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *VIDEO_STREAM_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_VIDEO_STREAM_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = VIDEO_STREAM_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e VIDEO_STREAM_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
