//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package storm32

import (
	"fmt"
	"strconv"
	"strings"
)

// RADIO_LINK_STATS flags (bitmask).
// The RX_RECEIVE and TX_RECEIVE flags indicate from which antenna the received data are taken for processing.
// If a flag is set then the data received on antenna2 is processed, else the data received on antenna1 is used.
// The RX_TRANSMIT and TX_TRANSMIT flags specify which antenna are transmitting data.
// Both antenna 1 and antenna 2 transmit flags can be set simultaneously, e.g., in case of dual-band or dual-frequency systems.
// If neither flag is set then antenna 1 should be assumed.
type MLRS_RADIO_LINK_STATS_FLAGS uint64

const (
	// Rssi values are in negative dBm. Values 1..254 corresponds to -1..-254 dBm. 0: no reception, UINT8_MAX: unknown.
	MLRS_RADIO_LINK_STATS_FLAGS_RSSI_DBM MLRS_RADIO_LINK_STATS_FLAGS = 1
	// Rx receive antenna. When set the data received on antenna 2 are taken, else the data stems from antenna 1.
	MLRS_RADIO_LINK_STATS_FLAGS_RX_RECEIVE_ANTENNA2 MLRS_RADIO_LINK_STATS_FLAGS = 2
	// Rx transmit antenna. Data are transmitted on antenna 1.
	MLRS_RADIO_LINK_STATS_FLAGS_RX_TRANSMIT_ANTENNA1 MLRS_RADIO_LINK_STATS_FLAGS = 4
	// Rx transmit antenna. Data are transmitted on antenna 2.
	MLRS_RADIO_LINK_STATS_FLAGS_RX_TRANSMIT_ANTENNA2 MLRS_RADIO_LINK_STATS_FLAGS = 8
	// Tx receive antenna. When set the data received on antenna 2 are taken, else the data stems from antenna 1.
	MLRS_RADIO_LINK_STATS_FLAGS_TX_RECEIVE_ANTENNA2 MLRS_RADIO_LINK_STATS_FLAGS = 16
	// Tx transmit antenna. Data are transmitted on antenna 1.
	MLRS_RADIO_LINK_STATS_FLAGS_TX_TRANSMIT_ANTENNA1 MLRS_RADIO_LINK_STATS_FLAGS = 32
	// Tx transmit antenna. Data are transmitted on antenna 2.
	MLRS_RADIO_LINK_STATS_FLAGS_TX_TRANSMIT_ANTENNA2 MLRS_RADIO_LINK_STATS_FLAGS = 64
)

var values_MLRS_RADIO_LINK_STATS_FLAGS = []MLRS_RADIO_LINK_STATS_FLAGS{
	MLRS_RADIO_LINK_STATS_FLAGS_RSSI_DBM,
	MLRS_RADIO_LINK_STATS_FLAGS_RX_RECEIVE_ANTENNA2,
	MLRS_RADIO_LINK_STATS_FLAGS_RX_TRANSMIT_ANTENNA1,
	MLRS_RADIO_LINK_STATS_FLAGS_RX_TRANSMIT_ANTENNA2,
	MLRS_RADIO_LINK_STATS_FLAGS_TX_RECEIVE_ANTENNA2,
	MLRS_RADIO_LINK_STATS_FLAGS_TX_TRANSMIT_ANTENNA1,
	MLRS_RADIO_LINK_STATS_FLAGS_TX_TRANSMIT_ANTENNA2,
}

var value_to_label_MLRS_RADIO_LINK_STATS_FLAGS = map[MLRS_RADIO_LINK_STATS_FLAGS]string{
	MLRS_RADIO_LINK_STATS_FLAGS_RSSI_DBM:             "MLRS_RADIO_LINK_STATS_FLAGS_RSSI_DBM",
	MLRS_RADIO_LINK_STATS_FLAGS_RX_RECEIVE_ANTENNA2:  "MLRS_RADIO_LINK_STATS_FLAGS_RX_RECEIVE_ANTENNA2",
	MLRS_RADIO_LINK_STATS_FLAGS_RX_TRANSMIT_ANTENNA1: "MLRS_RADIO_LINK_STATS_FLAGS_RX_TRANSMIT_ANTENNA1",
	MLRS_RADIO_LINK_STATS_FLAGS_RX_TRANSMIT_ANTENNA2: "MLRS_RADIO_LINK_STATS_FLAGS_RX_TRANSMIT_ANTENNA2",
	MLRS_RADIO_LINK_STATS_FLAGS_TX_RECEIVE_ANTENNA2:  "MLRS_RADIO_LINK_STATS_FLAGS_TX_RECEIVE_ANTENNA2",
	MLRS_RADIO_LINK_STATS_FLAGS_TX_TRANSMIT_ANTENNA1: "MLRS_RADIO_LINK_STATS_FLAGS_TX_TRANSMIT_ANTENNA1",
	MLRS_RADIO_LINK_STATS_FLAGS_TX_TRANSMIT_ANTENNA2: "MLRS_RADIO_LINK_STATS_FLAGS_TX_TRANSMIT_ANTENNA2",
}

var label_to_value_MLRS_RADIO_LINK_STATS_FLAGS = map[string]MLRS_RADIO_LINK_STATS_FLAGS{
	"MLRS_RADIO_LINK_STATS_FLAGS_RSSI_DBM":             MLRS_RADIO_LINK_STATS_FLAGS_RSSI_DBM,
	"MLRS_RADIO_LINK_STATS_FLAGS_RX_RECEIVE_ANTENNA2":  MLRS_RADIO_LINK_STATS_FLAGS_RX_RECEIVE_ANTENNA2,
	"MLRS_RADIO_LINK_STATS_FLAGS_RX_TRANSMIT_ANTENNA1": MLRS_RADIO_LINK_STATS_FLAGS_RX_TRANSMIT_ANTENNA1,
	"MLRS_RADIO_LINK_STATS_FLAGS_RX_TRANSMIT_ANTENNA2": MLRS_RADIO_LINK_STATS_FLAGS_RX_TRANSMIT_ANTENNA2,
	"MLRS_RADIO_LINK_STATS_FLAGS_TX_RECEIVE_ANTENNA2":  MLRS_RADIO_LINK_STATS_FLAGS_TX_RECEIVE_ANTENNA2,
	"MLRS_RADIO_LINK_STATS_FLAGS_TX_TRANSMIT_ANTENNA1": MLRS_RADIO_LINK_STATS_FLAGS_TX_TRANSMIT_ANTENNA1,
	"MLRS_RADIO_LINK_STATS_FLAGS_TX_TRANSMIT_ANTENNA2": MLRS_RADIO_LINK_STATS_FLAGS_TX_TRANSMIT_ANTENNA2,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MLRS_RADIO_LINK_STATS_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_MLRS_RADIO_LINK_STATS_FLAGS {
		if e&val == val {
			names = append(names, value_to_label_MLRS_RADIO_LINK_STATS_FLAGS[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MLRS_RADIO_LINK_STATS_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask MLRS_RADIO_LINK_STATS_FLAGS
	for _, label := range labels {
		if value, ok := label_to_value_MLRS_RADIO_LINK_STATS_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= MLRS_RADIO_LINK_STATS_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e MLRS_RADIO_LINK_STATS_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
