// Code generated by ifacemaker; DO NOT EDIT.

package hcloud

import (
	"context"
)

// ISSHKeyClient ...
type ISSHKeyClient interface {
	// GetByID retrieves a SSH key by its ID. If the SSH key does not exist, nil is returned.
	GetByID(ctx context.Context, id int64) (*SSHKey, *Response, error)
	// GetByName retrieves a SSH key by its name. If the SSH key does not exist, nil is returned.
	GetByName(ctx context.Context, name string) (*SSHKey, *Response, error)
	// GetByFingerprint retreives a SSH key by its fingerprint. If the SSH key does not exist, nil is returned.
	GetByFingerprint(ctx context.Context, fingerprint string) (*SSHKey, *Response, error)
	// Get retrieves a SSH key by its ID if the input can be parsed as an integer, otherwise it
	// retrieves a SSH key by its name. If the SSH key does not exist, nil is returned.
	Get(ctx context.Context, idOrName string) (*SSHKey, *Response, error)
	// List returns a list of SSH keys for a specific page.
	//
	// Please note that filters specified in opts are not taken into account
	// when their value corresponds to their zero value or when they are empty.
	List(ctx context.Context, opts SSHKeyListOpts) ([]*SSHKey, *Response, error)
	// All returns all SSH keys.
	All(ctx context.Context) ([]*SSHKey, error)
	// AllWithOpts returns all SSH keys with the given options.
	AllWithOpts(ctx context.Context, opts SSHKeyListOpts) ([]*SSHKey, error)
	// Create creates a new SSH key with the given options.
	Create(ctx context.Context, opts SSHKeyCreateOpts) (*SSHKey, *Response, error)
	// Delete deletes a SSH key.
	Delete(ctx context.Context, sshKey *SSHKey) (*Response, error)
	// Update updates a SSH key.
	Update(ctx context.Context, sshKey *SSHKey, opts SSHKeyUpdateOpts) (*SSHKey, *Response, error)
}
