//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ardupilotmega

import (
	"fmt"
	"strconv"
)

// A mapping of copter flight modes for custom_mode field of heartbeat.
type COPTER_MODE uint64

const (
	// STABILIZE
	COPTER_MODE_STABILIZE COPTER_MODE = 0
	// ACRO
	COPTER_MODE_ACRO COPTER_MODE = 1
	// ALT HOLD
	COPTER_MODE_ALT_HOLD COPTER_MODE = 2
	// AUTO
	COPTER_MODE_AUTO COPTER_MODE = 3
	// GUIDED
	COPTER_MODE_GUIDED COPTER_MODE = 4
	// LOITER
	COPTER_MODE_LOITER COPTER_MODE = 5
	// RTL
	COPTER_MODE_RTL COPTER_MODE = 6
	// CIRCLE
	COPTER_MODE_CIRCLE COPTER_MODE = 7
	// LAND
	COPTER_MODE_LAND COPTER_MODE = 9
	// DRIFT
	COPTER_MODE_DRIFT COPTER_MODE = 11
	// SPORT
	COPTER_MODE_SPORT COPTER_MODE = 13
	// FLIP
	COPTER_MODE_FLIP COPTER_MODE = 14
	// AUTOTUNE
	COPTER_MODE_AUTOTUNE COPTER_MODE = 15
	// POSHOLD
	COPTER_MODE_POSHOLD COPTER_MODE = 16
	// BRAKE
	COPTER_MODE_BRAKE COPTER_MODE = 17
	// THROW
	COPTER_MODE_THROW COPTER_MODE = 18
	// AVOID ADSB
	COPTER_MODE_AVOID_ADSB COPTER_MODE = 19
	// GUIDED NOGPS
	COPTER_MODE_GUIDED_NOGPS COPTER_MODE = 20
	// SMARTRTL
	COPTER_MODE_SMART_RTL COPTER_MODE = 21
	// FLOWHOLD
	COPTER_MODE_FLOWHOLD COPTER_MODE = 22
	// FOLLOW
	COPTER_MODE_FOLLOW COPTER_MODE = 23
	// ZIGZAG
	COPTER_MODE_ZIGZAG COPTER_MODE = 24
	// SYSTEMID
	COPTER_MODE_SYSTEMID COPTER_MODE = 25
	// AUTOROTATE
	COPTER_MODE_AUTOROTATE COPTER_MODE = 26
	// AUTO RTL
	COPTER_MODE_AUTO_RTL COPTER_MODE = 27
	// TURTLE
	COPTER_MODE_TURTLE COPTER_MODE = 28
	// RATE_ACRO
	COPTER_MODE_RATE_ACRO COPTER_MODE = 29
)

var value_to_label_COPTER_MODE = map[COPTER_MODE]string{
	COPTER_MODE_STABILIZE:    "COPTER_MODE_STABILIZE",
	COPTER_MODE_ACRO:         "COPTER_MODE_ACRO",
	COPTER_MODE_ALT_HOLD:     "COPTER_MODE_ALT_HOLD",
	COPTER_MODE_AUTO:         "COPTER_MODE_AUTO",
	COPTER_MODE_GUIDED:       "COPTER_MODE_GUIDED",
	COPTER_MODE_LOITER:       "COPTER_MODE_LOITER",
	COPTER_MODE_RTL:          "COPTER_MODE_RTL",
	COPTER_MODE_CIRCLE:       "COPTER_MODE_CIRCLE",
	COPTER_MODE_LAND:         "COPTER_MODE_LAND",
	COPTER_MODE_DRIFT:        "COPTER_MODE_DRIFT",
	COPTER_MODE_SPORT:        "COPTER_MODE_SPORT",
	COPTER_MODE_FLIP:         "COPTER_MODE_FLIP",
	COPTER_MODE_AUTOTUNE:     "COPTER_MODE_AUTOTUNE",
	COPTER_MODE_POSHOLD:      "COPTER_MODE_POSHOLD",
	COPTER_MODE_BRAKE:        "COPTER_MODE_BRAKE",
	COPTER_MODE_THROW:        "COPTER_MODE_THROW",
	COPTER_MODE_AVOID_ADSB:   "COPTER_MODE_AVOID_ADSB",
	COPTER_MODE_GUIDED_NOGPS: "COPTER_MODE_GUIDED_NOGPS",
	COPTER_MODE_SMART_RTL:    "COPTER_MODE_SMART_RTL",
	COPTER_MODE_FLOWHOLD:     "COPTER_MODE_FLOWHOLD",
	COPTER_MODE_FOLLOW:       "COPTER_MODE_FOLLOW",
	COPTER_MODE_ZIGZAG:       "COPTER_MODE_ZIGZAG",
	COPTER_MODE_SYSTEMID:     "COPTER_MODE_SYSTEMID",
	COPTER_MODE_AUTOROTATE:   "COPTER_MODE_AUTOROTATE",
	COPTER_MODE_AUTO_RTL:     "COPTER_MODE_AUTO_RTL",
	COPTER_MODE_TURTLE:       "COPTER_MODE_TURTLE",
	COPTER_MODE_RATE_ACRO:    "COPTER_MODE_RATE_ACRO",
}

var label_to_value_COPTER_MODE = map[string]COPTER_MODE{
	"COPTER_MODE_STABILIZE":    COPTER_MODE_STABILIZE,
	"COPTER_MODE_ACRO":         COPTER_MODE_ACRO,
	"COPTER_MODE_ALT_HOLD":     COPTER_MODE_ALT_HOLD,
	"COPTER_MODE_AUTO":         COPTER_MODE_AUTO,
	"COPTER_MODE_GUIDED":       COPTER_MODE_GUIDED,
	"COPTER_MODE_LOITER":       COPTER_MODE_LOITER,
	"COPTER_MODE_RTL":          COPTER_MODE_RTL,
	"COPTER_MODE_CIRCLE":       COPTER_MODE_CIRCLE,
	"COPTER_MODE_LAND":         COPTER_MODE_LAND,
	"COPTER_MODE_DRIFT":        COPTER_MODE_DRIFT,
	"COPTER_MODE_SPORT":        COPTER_MODE_SPORT,
	"COPTER_MODE_FLIP":         COPTER_MODE_FLIP,
	"COPTER_MODE_AUTOTUNE":     COPTER_MODE_AUTOTUNE,
	"COPTER_MODE_POSHOLD":      COPTER_MODE_POSHOLD,
	"COPTER_MODE_BRAKE":        COPTER_MODE_BRAKE,
	"COPTER_MODE_THROW":        COPTER_MODE_THROW,
	"COPTER_MODE_AVOID_ADSB":   COPTER_MODE_AVOID_ADSB,
	"COPTER_MODE_GUIDED_NOGPS": COPTER_MODE_GUIDED_NOGPS,
	"COPTER_MODE_SMART_RTL":    COPTER_MODE_SMART_RTL,
	"COPTER_MODE_FLOWHOLD":     COPTER_MODE_FLOWHOLD,
	"COPTER_MODE_FOLLOW":       COPTER_MODE_FOLLOW,
	"COPTER_MODE_ZIGZAG":       COPTER_MODE_ZIGZAG,
	"COPTER_MODE_SYSTEMID":     COPTER_MODE_SYSTEMID,
	"COPTER_MODE_AUTOROTATE":   COPTER_MODE_AUTOROTATE,
	"COPTER_MODE_AUTO_RTL":     COPTER_MODE_AUTO_RTL,
	"COPTER_MODE_TURTLE":       COPTER_MODE_TURTLE,
	"COPTER_MODE_RATE_ACRO":    COPTER_MODE_RATE_ACRO,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e COPTER_MODE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_COPTER_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *COPTER_MODE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_COPTER_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = COPTER_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e COPTER_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
