//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Indicates the ESC connection type.
type ESC_CONNECTION_TYPE uint64

const (
	// Traditional PPM ESC.
	ESC_CONNECTION_TYPE_PPM ESC_CONNECTION_TYPE = 0
	// Serial Bus connected ESC.
	ESC_CONNECTION_TYPE_SERIAL ESC_CONNECTION_TYPE = 1
	// One Shot PPM ESC.
	ESC_CONNECTION_TYPE_ONESHOT ESC_CONNECTION_TYPE = 2
	// I2C ESC.
	ESC_CONNECTION_TYPE_I2C ESC_CONNECTION_TYPE = 3
	// CAN-Bus ESC.
	ESC_CONNECTION_TYPE_CAN ESC_CONNECTION_TYPE = 4
	// DShot ESC.
	ESC_CONNECTION_TYPE_DSHOT ESC_CONNECTION_TYPE = 5
)

var value_to_label_ESC_CONNECTION_TYPE = map[ESC_CONNECTION_TYPE]string{
	ESC_CONNECTION_TYPE_PPM:     "ESC_CONNECTION_TYPE_PPM",
	ESC_CONNECTION_TYPE_SERIAL:  "ESC_CONNECTION_TYPE_SERIAL",
	ESC_CONNECTION_TYPE_ONESHOT: "ESC_CONNECTION_TYPE_ONESHOT",
	ESC_CONNECTION_TYPE_I2C:     "ESC_CONNECTION_TYPE_I2C",
	ESC_CONNECTION_TYPE_CAN:     "ESC_CONNECTION_TYPE_CAN",
	ESC_CONNECTION_TYPE_DSHOT:   "ESC_CONNECTION_TYPE_DSHOT",
}

var label_to_value_ESC_CONNECTION_TYPE = map[string]ESC_CONNECTION_TYPE{
	"ESC_CONNECTION_TYPE_PPM":     ESC_CONNECTION_TYPE_PPM,
	"ESC_CONNECTION_TYPE_SERIAL":  ESC_CONNECTION_TYPE_SERIAL,
	"ESC_CONNECTION_TYPE_ONESHOT": ESC_CONNECTION_TYPE_ONESHOT,
	"ESC_CONNECTION_TYPE_I2C":     ESC_CONNECTION_TYPE_I2C,
	"ESC_CONNECTION_TYPE_CAN":     ESC_CONNECTION_TYPE_CAN,
	"ESC_CONNECTION_TYPE_DSHOT":   ESC_CONNECTION_TYPE_DSHOT,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e ESC_CONNECTION_TYPE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_ESC_CONNECTION_TYPE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *ESC_CONNECTION_TYPE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_ESC_CONNECTION_TYPE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = ESC_CONNECTION_TYPE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e ESC_CONNECTION_TYPE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
