//autogenerated:yes
//nolint:revive,misspell,govet,lll
package common

// Message that announces the sequence number of the current target mission item (that the system will fly towards/execute when the mission is running).
// This message should be streamed all the time (nominally at 1Hz).
// This message should be emitted following a call to MAV_CMD_DO_SET_MISSION_CURRENT or MISSION_SET_CURRENT.
type MessageMissionCurrent struct {
	// Sequence
	Seq uint16
	// Total number of mission items on vehicle (on last item, sequence == total). If the autopilot stores its home location as part of the mission this will be excluded from the total. 0: Not supported, UINT16_MAX if no mission is present on the vehicle.
	Total uint16 `mavext:"true"`
	// Mission state machine state. MISSION_STATE_UNKNOWN if state reporting not supported.
	MissionState MISSION_STATE `mavenum:"uint8" mavext:"true"`
	// Vehicle is in a mode that can execute mission items or suspended. 0: Unknown, 1: In mission mode, 2: Suspended (not in mission mode).
	MissionMode uint8 `mavext:"true"`
	// Id of current on-vehicle mission plan, or 0 if IDs are not supported or there is no mission loaded. GCS can use this to track changes to the mission plan type. The same value is returned on mission upload (in the MISSION_ACK).
	MissionId uint32 `mavext:"true"`
	// Id of current on-vehicle fence plan, or 0 if IDs are not supported or there is no fence loaded. GCS can use this to track changes to the fence plan type. The same value is returned on fence upload (in the MISSION_ACK).
	FenceId uint32 `mavext:"true"`
	// Id of current on-vehicle rally point plan, or 0 if IDs are not supported or there are no rally points loaded. GCS can use this to track changes to the rally point plan type. The same value is returned on rally point upload (in the MISSION_ACK).
	RallyPointsId uint32 `mavext:"true"`
}

// GetID implements the message.Message interface.
func (*MessageMissionCurrent) GetID() uint32 {
	return 42
}
