//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
	"strings"
)

// Axes that will be autotuned by MAV_CMD_DO_AUTOTUNE_ENABLE.
// Note that at least one flag must be set in MAV_CMD_DO_AUTOTUNE_ENABLE.param2: if none are set, the flight stack will tune its default set of axes.
type AUTOTUNE_AXIS uint64

const (
	// Autotune roll axis.
	AUTOTUNE_AXIS_ROLL AUTOTUNE_AXIS = 1
	// Autotune pitch axis.
	AUTOTUNE_AXIS_PITCH AUTOTUNE_AXIS = 2
	// Autotune yaw axis.
	AUTOTUNE_AXIS_YAW AUTOTUNE_AXIS = 4
)

var values_AUTOTUNE_AXIS = []AUTOTUNE_AXIS{
	AUTOTUNE_AXIS_ROLL,
	AUTOTUNE_AXIS_PITCH,
	AUTOTUNE_AXIS_YAW,
}

var value_to_label_AUTOTUNE_AXIS = map[AUTOTUNE_AXIS]string{
	AUTOTUNE_AXIS_ROLL:  "AUTOTUNE_AXIS_ROLL",
	AUTOTUNE_AXIS_PITCH: "AUTOTUNE_AXIS_PITCH",
	AUTOTUNE_AXIS_YAW:   "AUTOTUNE_AXIS_YAW",
}

var label_to_value_AUTOTUNE_AXIS = map[string]AUTOTUNE_AXIS{
	"AUTOTUNE_AXIS_ROLL":  AUTOTUNE_AXIS_ROLL,
	"AUTOTUNE_AXIS_PITCH": AUTOTUNE_AXIS_PITCH,
	"AUTOTUNE_AXIS_YAW":   AUTOTUNE_AXIS_YAW,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e AUTOTUNE_AXIS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_AUTOTUNE_AXIS {
		if e&val == val {
			names = append(names, value_to_label_AUTOTUNE_AXIS[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *AUTOTUNE_AXIS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask AUTOTUNE_AXIS
	for _, label := range labels {
		if value, ok := label_to_value_AUTOTUNE_AXIS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= AUTOTUNE_AXIS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e AUTOTUNE_AXIS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
