//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Reboot/shutdown action for selected component in MAV_CMD_PREFLIGHT_REBOOT_SHUTDOWN.
type REBOOT_SHUTDOWN_ACTION uint64

const (
	// Do nothing.
	REBOOT_SHUTDOWN_ACTION_NONE REBOOT_SHUTDOWN_ACTION = 0
	// Reboot component.
	REBOOT_SHUTDOWN_ACTION_REBOOT REBOOT_SHUTDOWN_ACTION = 1
	// Shutdown component.
	REBOOT_SHUTDOWN_ACTION_SHUTDOWN REBOOT_SHUTDOWN_ACTION = 2
	// Reboot component and keep it in the bootloader until upgraded.
	REBOOT_SHUTDOWN_ACTION_REBOOT_TO_BOOTLOADER REBOOT_SHUTDOWN_ACTION = 3
	// Power on component. Do nothing if component is already powered (ACK command with MAV_RESULT_ACCEPTED).
	REBOOT_SHUTDOWN_ACTION_POWER_ON REBOOT_SHUTDOWN_ACTION = 4
)

var value_to_label_REBOOT_SHUTDOWN_ACTION = map[REBOOT_SHUTDOWN_ACTION]string{
	REBOOT_SHUTDOWN_ACTION_NONE:                 "REBOOT_SHUTDOWN_ACTION_NONE",
	REBOOT_SHUTDOWN_ACTION_REBOOT:               "REBOOT_SHUTDOWN_ACTION_REBOOT",
	REBOOT_SHUTDOWN_ACTION_SHUTDOWN:             "REBOOT_SHUTDOWN_ACTION_SHUTDOWN",
	REBOOT_SHUTDOWN_ACTION_REBOOT_TO_BOOTLOADER: "REBOOT_SHUTDOWN_ACTION_REBOOT_TO_BOOTLOADER",
	REBOOT_SHUTDOWN_ACTION_POWER_ON:             "REBOOT_SHUTDOWN_ACTION_POWER_ON",
}

var label_to_value_REBOOT_SHUTDOWN_ACTION = map[string]REBOOT_SHUTDOWN_ACTION{
	"REBOOT_SHUTDOWN_ACTION_NONE":                 REBOOT_SHUTDOWN_ACTION_NONE,
	"REBOOT_SHUTDOWN_ACTION_REBOOT":               REBOOT_SHUTDOWN_ACTION_REBOOT,
	"REBOOT_SHUTDOWN_ACTION_SHUTDOWN":             REBOOT_SHUTDOWN_ACTION_SHUTDOWN,
	"REBOOT_SHUTDOWN_ACTION_REBOOT_TO_BOOTLOADER": REBOOT_SHUTDOWN_ACTION_REBOOT_TO_BOOTLOADER,
	"REBOOT_SHUTDOWN_ACTION_POWER_ON":             REBOOT_SHUTDOWN_ACTION_POWER_ON,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e REBOOT_SHUTDOWN_ACTION) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_REBOOT_SHUTDOWN_ACTION[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *REBOOT_SHUTDOWN_ACTION) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_REBOOT_SHUTDOWN_ACTION[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = REBOOT_SHUTDOWN_ACTION(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e REBOOT_SHUTDOWN_ACTION) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
