//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package development

import (
	"fmt"
	"strconv"
	"strings"
)

// Flags indicating errors in a GPS receiver.
type GPS_SYSTEM_ERROR_FLAGS uint64

const (
	// There are problems with incoming correction streams.
	GPS_SYSTEM_ERROR_INCOMING_CORRECTIONS GPS_SYSTEM_ERROR_FLAGS = 1
	// There are problems with the configuration.
	GPS_SYSTEM_ERROR_CONFIGURATION GPS_SYSTEM_ERROR_FLAGS = 2
	// There are problems with the software on the GPS receiver.
	GPS_SYSTEM_ERROR_SOFTWARE GPS_SYSTEM_ERROR_FLAGS = 4
	// There are problems with an antenna connected to the GPS receiver.
	GPS_SYSTEM_ERROR_ANTENNA GPS_SYSTEM_ERROR_FLAGS = 8
	// There are problems handling all incoming events.
	GPS_SYSTEM_ERROR_EVENT_CONGESTION GPS_SYSTEM_ERROR_FLAGS = 16
	// The GPS receiver CPU is overloaded.
	GPS_SYSTEM_ERROR_CPU_OVERLOAD GPS_SYSTEM_ERROR_FLAGS = 32
	// The GPS receiver is experiencing output congestion.
	GPS_SYSTEM_ERROR_OUTPUT_CONGESTION GPS_SYSTEM_ERROR_FLAGS = 64
)

var values_GPS_SYSTEM_ERROR_FLAGS = []GPS_SYSTEM_ERROR_FLAGS{
	GPS_SYSTEM_ERROR_INCOMING_CORRECTIONS,
	GPS_SYSTEM_ERROR_CONFIGURATION,
	GPS_SYSTEM_ERROR_SOFTWARE,
	GPS_SYSTEM_ERROR_ANTENNA,
	GPS_SYSTEM_ERROR_EVENT_CONGESTION,
	GPS_SYSTEM_ERROR_CPU_OVERLOAD,
	GPS_SYSTEM_ERROR_OUTPUT_CONGESTION,
}

var value_to_label_GPS_SYSTEM_ERROR_FLAGS = map[GPS_SYSTEM_ERROR_FLAGS]string{
	GPS_SYSTEM_ERROR_INCOMING_CORRECTIONS: "GPS_SYSTEM_ERROR_INCOMING_CORRECTIONS",
	GPS_SYSTEM_ERROR_CONFIGURATION:        "GPS_SYSTEM_ERROR_CONFIGURATION",
	GPS_SYSTEM_ERROR_SOFTWARE:             "GPS_SYSTEM_ERROR_SOFTWARE",
	GPS_SYSTEM_ERROR_ANTENNA:              "GPS_SYSTEM_ERROR_ANTENNA",
	GPS_SYSTEM_ERROR_EVENT_CONGESTION:     "GPS_SYSTEM_ERROR_EVENT_CONGESTION",
	GPS_SYSTEM_ERROR_CPU_OVERLOAD:         "GPS_SYSTEM_ERROR_CPU_OVERLOAD",
	GPS_SYSTEM_ERROR_OUTPUT_CONGESTION:    "GPS_SYSTEM_ERROR_OUTPUT_CONGESTION",
}

var label_to_value_GPS_SYSTEM_ERROR_FLAGS = map[string]GPS_SYSTEM_ERROR_FLAGS{
	"GPS_SYSTEM_ERROR_INCOMING_CORRECTIONS": GPS_SYSTEM_ERROR_INCOMING_CORRECTIONS,
	"GPS_SYSTEM_ERROR_CONFIGURATION":        GPS_SYSTEM_ERROR_CONFIGURATION,
	"GPS_SYSTEM_ERROR_SOFTWARE":             GPS_SYSTEM_ERROR_SOFTWARE,
	"GPS_SYSTEM_ERROR_ANTENNA":              GPS_SYSTEM_ERROR_ANTENNA,
	"GPS_SYSTEM_ERROR_EVENT_CONGESTION":     GPS_SYSTEM_ERROR_EVENT_CONGESTION,
	"GPS_SYSTEM_ERROR_CPU_OVERLOAD":         GPS_SYSTEM_ERROR_CPU_OVERLOAD,
	"GPS_SYSTEM_ERROR_OUTPUT_CONGESTION":    GPS_SYSTEM_ERROR_OUTPUT_CONGESTION,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e GPS_SYSTEM_ERROR_FLAGS) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_GPS_SYSTEM_ERROR_FLAGS {
		if e&val == val {
			names = append(names, value_to_label_GPS_SYSTEM_ERROR_FLAGS[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *GPS_SYSTEM_ERROR_FLAGS) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask GPS_SYSTEM_ERROR_FLAGS
	for _, label := range labels {
		if value, ok := label_to_value_GPS_SYSTEM_ERROR_FLAGS[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= GPS_SYSTEM_ERROR_FLAGS(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e GPS_SYSTEM_ERROR_FLAGS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
